/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;

public class LargestEmptyCircle {
    private Geometry obstacles;
    private double tolerance;
    private GeometryFactory factory;
    private Geometry boundary;
    private IndexedPointInAreaLocator ptLocater;
    private IndexedFacetDistance obstacleDistance;
    private IndexedFacetDistance boundaryDistance;
    private Cell farthestCell;
    private Cell centerCell = null;
    private Coordinate centerPt;
    private Point centerPoint = null;
    private Coordinate radiusPt;
    private Point radiusPoint = null;

    public static Point getCenter(Geometry obstacles, double tolerance) {
        LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, tolerance);
        return lec.getCenter();
    }

    public static LineString getRadiusLine(Geometry obstacles, double tolerance) {
        LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, tolerance);
        return lec.getRadiusLine();
    }

    public LargestEmptyCircle(Geometry obstacles, double tolerance) {
        if (obstacles.isEmpty()) {
            throw new IllegalArgumentException("Empty obstacles geometry is not supported");
        }
        this.obstacles = obstacles;
        this.factory = obstacles.getFactory();
        this.tolerance = tolerance;
        this.obstacleDistance = new IndexedFacetDistance(obstacles);
        this.setBoundary(obstacles);
    }

    private void setBoundary(Geometry obstacles) {
        this.boundary = obstacles.convexHull();
        if (this.boundary.getDimension() >= 2) {
            this.ptLocater = new IndexedPointInAreaLocator(this.boundary);
            this.boundaryDistance = new IndexedFacetDistance(this.boundary);
        }
    }

    public Point getCenter() {
        this.compute();
        return this.centerPoint;
    }

    public Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint;
    }

    public LineString getRadiusLine() {
        this.compute();
        LineString radiusLine = this.factory.createLineString(new Coordinate[]{this.centerPt.copy(), this.radiusPt.copy()});
        return radiusLine;
    }

    private double distanceToConstraints(Point p) {
        boolean isOutide;
        boolean bl = isOutide = 2 == this.ptLocater.locate(p.getCoordinate());
        if (isOutide) {
            double boundaryDist = this.boundaryDistance.distance(p);
            return -boundaryDist;
        }
        double dist = this.obstacleDistance.distance(p);
        return dist;
    }

    private double distanceToConstraints(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory.createPoint(coord);
        return this.distanceToConstraints(pt);
    }

    private void compute() {
        if (this.centerCell != null) {
            return;
        }
        if (this.ptLocater == null) {
            Coordinate pt = this.obstacles.getCoordinate();
            this.centerPt = pt.copy();
            this.centerPoint = this.factory.createPoint(pt);
            this.radiusPt = pt.copy();
            this.radiusPoint = this.factory.createPoint(pt);
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        this.createInitialGrid(this.obstacles.getEnvelopeInternal(), cellQueue);
        this.farthestCell = this.createCentroidCell(this.obstacles);
        while (!cellQueue.isEmpty()) {
            Cell cell = (Cell)cellQueue.remove();
            if (cell.getDistance() > this.farthestCell.getDistance()) {
                this.farthestCell = cell;
            }
            if (!this.mayContainCircleCenter(cell)) continue;
            double h2 = cell.getHSide() / 2.0;
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2));
        }
        this.centerCell = this.farthestCell;
        this.centerPt = new Coordinate(this.centerCell.getX(), this.centerCell.getY());
        this.centerPoint = this.factory.createPoint(this.centerPt);
        Coordinate[] nearestPts = this.obstacleDistance.nearestPoints(this.centerPoint);
        this.radiusPt = nearestPts[0].copy();
        this.radiusPoint = this.factory.createPoint(this.radiusPt);
    }

    private boolean mayContainCircleCenter(Cell cell) {
        if (cell.isFullyOutside()) {
            return false;
        }
        if (cell.isOutside()) {
            boolean isOverlapSignificant = cell.getMaxDistance() > this.tolerance;
            return isOverlapSignificant;
        }
        double potentialIncrease = cell.getMaxDistance() - this.farthestCell.getDistance();
        return potentialIncrease > this.tolerance;
    }

    private void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double height = env.getHeight();
        double cellSize = Math.min(width, height);
        double hSize = cellSize / 2.0;
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(this.createCell(x + hSize, y + hSize, hSize));
            }
        }
    }

    private Cell createCell(double x, double y, double h) {
        return new Cell(x, y, h, this.distanceToConstraints(x, y));
    }

    private Cell createCentroidCell(Geometry geom) {
        Point p = geom.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, this.distanceToConstraints(p));
    }

    private static class Cell
    implements Comparable<Cell> {
        private static final double SQRT2 = 1.4142135623730951;
        private double x;
        private double y;
        private double hSide;
        private double distance;
        private double maxDist;

        Cell(double x, double y, double hSide, double distanceToConstraints) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distanceToConstraints;
            this.maxDist = this.distance + hSide * 1.4142135623730951;
        }

        public boolean isFullyOutside() {
            return this.getMaxDistance() < 0.0;
        }

        public boolean isOutside() {
            return this.distance < 0.0;
        }

        public double getMaxDistance() {
            return this.maxDist;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getHSide() {
            return this.hSide;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        public int compareTo(Cell o) {
            return (int)(o.maxDist - this.maxDist);
        }
    }
}

