/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.OverlayImageDescriptor;
import org.jkiss.dbeaver.ui.OverlayImageDescriptorLegacy;

public class DBeaverIcons {
    private static final Log log;
    private static final boolean useLegacyOverlay;
    private static Map<String, IconDescriptor> imageMap;
    private static Map<String, IconDescriptor> compositeMap;
    private static Image viewMenuImage;

    static {
        boolean hasCachedImageDataProvider;
        log = Log.getLog(DBeaverIcons.class);
        try {
            Class.forName("org.eclipse.jface.resource.CompositeImageDescriptor$CachedImageDataProvider");
            hasCachedImageDataProvider = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            hasCachedImageDataProvider = false;
        }
        useLegacyOverlay = !hasCachedImageDataProvider;
        imageMap = new HashMap<String, IconDescriptor>();
        compositeMap = new HashMap<String, IconDescriptor>();
    }

    @NotNull
    public static Image getImage(@NotNull DBPImage image) {
        return DBeaverIcons.getIconDescriptor((DBPImage)image, (boolean)true).image;
    }

    @NotNull
    public static Image getImage(@NotNull DBPImage image, boolean useCache) {
        return DBeaverIcons.getIconDescriptor((DBPImage)image, (boolean)useCache).image;
    }

    @Nullable
    public static Image getImageByLocation(@NotNull String iconLocation) {
        IconDescriptor icon = DBeaverIcons.getIconByLocation(iconLocation);
        if (icon == null) {
            return null;
        }
        return icon.image;
    }

    @NotNull
    public static ImageDescriptor getImageDescriptor(@NotNull DBPImage image) {
        return DBeaverIcons.getIconDescriptor((DBPImage)image, (boolean)true).imageDescriptor;
    }

    @NotNull
    private static IconDescriptor getIconDescriptor(DBPImage image, boolean useCache) {
        if (image == null) {
            return DBeaverIcons.getIconDescriptor((DBPImage)DBIcon.TYPE_UNKNOWN, useCache);
        }
        if (image instanceof DBIconBinary) {
            return new IconDescriptor("[" + image.getLocation() + "]", ((DBIconBinary)image).getImage(), ((DBIconBinary)image).getImageDescriptor());
        }
        if (image instanceof DBIconComposite) {
            IconDescriptor icon = DBeaverIcons.getIconDescriptor(((DBIconComposite)image).getMain(), useCache);
            return DBeaverIcons.getCompositeIcon(icon, (DBIconComposite)image, useCache);
        }
        if (image instanceof DBIcon) {
            IconDescriptor icon = DBeaverIcons.getIconByLocation(image.getLocation());
            if (icon == null) {
                log.error((Object)("Image '" + image.getLocation() + "' not found"));
                return DBeaverIcons.getIconDescriptor((DBPImage)DBIcon.TYPE_UNKNOWN, useCache);
            }
            return icon;
        }
        log.error((Object)("Unexpected image of type " + String.valueOf(image.getClass())));
        return DBeaverIcons.getIconDescriptor((DBPImage)DBIcon.TYPE_UNKNOWN, useCache);
    }

    private static IconDescriptor getCompositeIcon(IconDescriptor mainIcon, DBIconComposite image, boolean useCache) {
        IconDescriptor icon;
        if (!image.hasOverlays()) {
            return mainIcon;
        }
        String compositeId = mainIcon.id + "^" + (image.getTopLeft() == null ? "" : image.getTopLeft().getLocation()) + "^" + (image.getTopRight() == null ? "" : image.getTopRight().getLocation()) + "^" + (image.getBottomLeft() == null ? "" : image.getBottomLeft().getLocation()) + "^" + (image.getBottomRight() == null ? "" : image.getBottomRight().getLocation());
        IconDescriptor iconDescriptor = icon = useCache ? compositeMap.get(compositeId) : null;
        if (icon == null) {
            Image resultImage;
            if (useLegacyOverlay) {
                OverlayImageDescriptorLegacy ovrImage = new OverlayImageDescriptorLegacy(mainIcon.image.getImageData());
                if (image.getTopLeft() != null) {
                    ovrImage.setTopLeft(DBeaverIcons.accumulateDecorations(image, i -> i.getTopLeft()));
                }
                if (image.getTopRight() != null) {
                    ovrImage.setTopRight(DBeaverIcons.accumulateDecorations(image, i -> i.getTopRight()));
                }
                if (image.getBottomLeft() != null) {
                    ovrImage.setBottomLeft(DBeaverIcons.accumulateDecorations(image, i -> i.getBottomLeft()));
                }
                if (image.getBottomRight() != null) {
                    ovrImage.setBottomRight(DBeaverIcons.accumulateDecorations(image, i -> i.getBottomRight()));
                }
                resultImage = ovrImage.createImage();
            } else {
                OverlayImageDescriptor ovrImage = new OverlayImageDescriptor(mainIcon.imageDescriptor);
                if (image.getTopLeft() != null) {
                    ovrImage.setTopLeft(DBeaverIcons.accumulateDecorations(image, i -> i.getTopLeft()));
                }
                if (image.getTopRight() != null) {
                    ovrImage.setTopRight(DBeaverIcons.accumulateDecorations(image, i -> i.getTopRight()));
                }
                if (image.getBottomLeft() != null) {
                    ovrImage.setBottomLeft(DBeaverIcons.accumulateDecorations(image, i -> i.getBottomLeft()));
                }
                if (image.getBottomRight() != null) {
                    ovrImage.setBottomRight(DBeaverIcons.accumulateDecorations(image, i -> i.getBottomRight()));
                }
                resultImage = ovrImage.createImage();
            }
            icon = new IconDescriptor(compositeId, resultImage);
            if (useCache) {
                compositeMap.put(compositeId, icon);
            }
        }
        return icon;
    }

    @NotNull
    private static ImageDescriptor[] accumulateDecorations(@NotNull DBIconComposite image, @NotNull Function<DBIconComposite, DBPImage> map) {
        DBPImage base = image.getMain();
        if (base instanceof DBIconComposite) {
            ArrayList<ImageDescriptor> decorations = new ArrayList<ImageDescriptor>();
            decorations.add(DBeaverIcons.getImageDescriptor(map.apply(image)));
            do {
                image = (DBIconComposite)base;
                decorations.add(DBeaverIcons.getImageDescriptor(map.apply(image)));
            } while ((base = image.getMain()) instanceof DBIconComposite);
            return (ImageDescriptor[])decorations.toArray(ImageDescriptor[]::new);
        }
        return new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(map.apply(image))};
    }

    private static IconDescriptor getIconByLocation(String location) {
        IconDescriptor icon = imageMap.get(location);
        if (icon == null) {
            block4: {
                try {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(location));
                    icon = new IconDescriptor(location, imageDescriptor);
                    if (icon.image != null) break block4;
                    log.warn((Object)("Bad image: " + location));
                    return null;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return null;
                }
            }
            imageMap.put(location, icon);
        }
        return icon;
    }

    private static class IconDescriptor {
        @NotNull
        String id;
        @NotNull
        Image image;
        @NotNull
        ImageDescriptor imageDescriptor;

        IconDescriptor(@NotNull String id, @NotNull ImageDescriptor imageDescriptor) {
            this.id = id;
            this.image = imageDescriptor.createImage(false);
            this.imageDescriptor = imageDescriptor;
        }

        IconDescriptor(@NotNull String id, @NotNull Image image) {
            this.id = id;
            this.image = image;
            this.imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        }

        IconDescriptor(@NotNull String id, @NotNull Image image, @NotNull ImageDescriptor imageDescriptor) {
            this.id = id;
            this.image = image;
            this.imageDescriptor = imageDescriptor;
        }
    }
}

