/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndexColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public class PostgreIndexManager
extends SQLIndexManager<PostgreIndex, PostgreTableBase>
implements DBEObjectRenamer<PostgreIndex> {
    public boolean canRenameObject(PostgreIndex object) {
        return object.getDataSource().getServerType().supportsKeyAndIndexRename();
    }

    @Nullable
    public DBSObjectCache<PostgreTableContainer, PostgreIndex> getObjectsCache(PostgreIndex object) {
        return ((PostgreTableContainer)((PostgreTableBase)object.getTable()).getContainer()).getSchema().getIndexCache();
    }

    protected PostgreIndex createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) {
        PostgreTableBase tableBase = (PostgreTableBase)container;
        return new PostgreIndex(tableBase, "NewIndex", DBSIndexType.UNKNOWN, false);
    }

    protected void appendIndexColumnModifiers(DBRProgressMonitor monitor, StringBuilder decl, DBSTableIndexColumn indexColumn) {
        try {
            PostgreOperatorClass operatorClass = ((PostgreIndexColumn)indexColumn).getOperatorClass(monitor);
            if (operatorClass != null) {
                decl.append(" ").append(operatorClass.getName());
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    public void deleteObject(@NotNull DBECommandContext commandContext, @NotNull PostgreIndex object, @NotNull Map<String, Object> options) throws DBException {
        if (object.isPrimaryKeyIndex()) {
            throw new DBException("You can not drop constraint-based unique index.\nTry to drop constraint '" + object.getName() + "'.");
        }
        super.deleteObject(commandContext, (DBSObject)object, options);
    }

    protected String getDropIndexPattern(PostgreIndex index) {
        return "DROP INDEX %INDEX%";
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        boolean hasDDL = false;
        PostgreIndex index = (PostgreIndex)command.getObject();
        if (index.isPersisted()) {
            try {
                String indexDDL = index.getObjectDefinitionText(monitor, DBPScriptObject.EMPTY_OPTIONS);
                if (!CommonUtils.isEmpty((String)indexDDL)) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, indexDDL));
                    hasDDL = true;
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract index DDL", (Throwable)e);
            }
        }
        if (!hasDDL) {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
        if (!CommonUtils.isEmpty((String)index.getDescription())) {
            PostgreIndexManager.addIndexCommentAction(actions, index);
        }
    }

    private static void addIndexCommentAction(List<DBEPersistAction> actions, PostgreIndex index) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment index", "COMMENT ON INDEX " + index.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)index, (String)index.getDescription())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreIndex object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        PostgreIndex index = (PostgreIndex)command.getObject();
        PostgreDataSource dataSource = index.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename index", "ALTER INDEX " + DBUtils.getQuotedIdentifier((DBSObject)((PostgreTableBase)index.getTable()).getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }
}

