/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.dashboard.registry;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardProvider;
import org.jkiss.dbeaver.model.dashboard.DashboardConstants;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class DashboardProviderDescriptor
extends AbstractContextDescriptor
implements DBPNamedObject {
    private static final Log log = Log.getLog(DashboardProviderDescriptor.class);
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final AbstractDescriptor.ObjectType implType;
    private final boolean supportsCustomDashboards;
    private final boolean supportsFolders;
    private final boolean databaseRequired;
    private final String defaultRenderer;
    private final DBDashboardDataType dataType;
    private DBDashboardProvider instance;
    private final Expression enabledWhen;

    public DashboardProviderDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.supportsCustomDashboards = CommonUtils.toBoolean((Object)config.getAttribute("supportsCustomization"));
        this.supportsFolders = CommonUtils.toBoolean((Object)config.getAttribute("supportsFolders"));
        this.databaseRequired = CommonUtils.toBoolean((Object)config.getAttribute("databaseRequired"));
        this.defaultRenderer = CommonUtils.toString((Object)config.getAttribute("defaultRenderer"));
        this.dataType = (DBDashboardDataType)CommonUtils.valueOf(DBDashboardDataType.class, (String)config.getAttribute("dataType"), (Enum)DashboardConstants.DEF_DASHBOARD_DATA_TYPE);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.enabledWhen = DashboardProviderDescriptor.getEnablementExpression((IConfigurationElement)config);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public AbstractDescriptor.ObjectType getImplType() {
        return this.implType;
    }

    public boolean isSupportsCustomDashboards() {
        return this.supportsCustomDashboards;
    }

    public boolean isSupportsFolders() {
        return this.supportsFolders;
    }

    public boolean isDatabaseRequired() {
        return this.databaseRequired;
    }

    public String getDefaultRenderer() {
        return this.defaultRenderer;
    }

    @NotNull
    public DBDashboardDataType getDataType() {
        return this.dataType;
    }

    public boolean appliesTo(DBPObject object, Object context) {
        if (object instanceof DBPDataSourceContainer) {
            DBPDataSourceContainer ds = (DBPDataSourceContainer)object;
            if (this.getInstance().appliesTo(ds) && this.isExpressionTrue(this.enabledWhen, object)) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isExpressionTrue(this.enabledWhen, (Object)this);
    }

    public DBDashboardProvider getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBDashboardProvider)this.implType.createInstance(DBDashboardProvider.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot instantiate dashboard provider '" + this.id + "'", e);
            }
        }
        return this.instance;
    }

    @NotNull
    public String getName() {
        return this.getLabel();
    }

    public String toString() {
        return this.getName();
    }
}

