/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabFactoryStyle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.api.extension.ReportItemFactory;

public class CrosstabItemFactory
extends ReportItemFactory
implements IMessages,
ICrosstabConstants {
    public IMessages getMessages() {
        return this;
    }

    public IReportItem newReportItem(DesignElementHandle extendedItemHandle) {
        if (extendedItemHandle == null) {
            return null;
        }
        String extensionName = extendedItemHandle.getStringProperty("extensionName");
        if (extensionName == null) {
            return null;
        }
        if ("Crosstab".equals(extensionName)) {
            return new CrosstabReportItemHandle(extendedItemHandle);
        }
        if ("CrosstabView".equals(extensionName)) {
            return new CrosstabViewHandle(extendedItemHandle);
        }
        if ("DimensionView".equals(extensionName)) {
            return new DimensionViewHandle(extendedItemHandle);
        }
        if ("LevelView".equals(extensionName)) {
            return new LevelViewHandle(extendedItemHandle);
        }
        if ("MeasureView".equals(extensionName)) {
            return new MeasureViewHandle(extendedItemHandle);
        }
        if ("ComputedMeasureView".equals(extensionName)) {
            return new ComputedMeasureViewHandle(extendedItemHandle);
        }
        if ("CrosstabCell".equals(extensionName)) {
            return new CrosstabCellHandle(extendedItemHandle);
        }
        if ("AggregationCell".equals(extensionName)) {
            return new AggregationCellHandle(extendedItemHandle);
        }
        return null;
    }

    public String getMessage(String key, Locale locale) {
        return Messages.getString(key, ULocale.forLocale((Locale)locale));
    }

    public String getMessage(String key, ULocale locale) {
        return Messages.getString(key, locale);
    }

    public IStyleDeclaration[] getFactoryStyles(String extensionName) {
        if ("Crosstab".equals(extensionName)) {
            return new IStyleDeclaration[]{new CrosstabFactoryStyle("crosstab"), new CrosstabFactoryStyle("crosstab-cell")};
        }
        return null;
    }
}

