/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultCFoldingStructureProvider
implements ICFoldingStructureProvider {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/folding"));
    private ITextEditor fEditor;
    private ProjectionListener fProjectionListener;
    protected ICElement fInput;
    private boolean fCollapseHeaderComments = true;
    private boolean fCollapseComments = false;
    private boolean fCollapseMacros = false;
    private boolean fCollapseFunctions = true;
    private boolean fCollapseStructures = true;
    private boolean fCollapseMethods = false;
    private boolean fCollapseInactiveCode = true;
    private int fMinCommentLines = 1;
    private boolean fPreprocessorBranchFoldingEnabled = true;
    private boolean fStatementsFoldingEnabled = false;
    private boolean fCommentFoldingEnabled = true;
    private ICReconcilingListener fReconilingListener;
    private volatile boolean fInitialReconcilePending = true;
    private int fCursorPosition;
    private SelectionListener fSelectionListener;

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer) {
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.internalUninstall();
        if (editor instanceof CEditor) {
            this.fEditor = editor;
            this.fProjectionListener = new ProjectionListener(viewer);
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        if (DEBUG) {
            System.out.println("DefaultCFoldingStructureProvider.handleProjectionEnabled()");
        }
        this.handleProjectionDisabled();
        if (this.fEditor instanceof CEditor) {
            this.initialize();
            this.fReconilingListener = new FoldingStructureReconciler();
            ((CEditor)this.fEditor).addReconcileListener(this.fReconilingListener);
            this.fSelectionListener = new SelectionListener();
            this.fEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fReconilingListener != null) {
            ((CEditor)this.fEditor).removeReconcileListener(this.fReconilingListener);
            this.fReconilingListener = null;
        }
        if (this.fSelectionListener != null) {
            this.fEditor.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
            this.fSelectionListener = null;
        }
    }

    @Override
    public final void initialize() {
        if (DEBUG) {
            System.out.println("DefaultCFoldingStructureProvider.initialize()");
        }
        this.fInitialReconcilePending = true;
        this.fCursorPosition = -1;
        this.update(this.createInitialContext());
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private ICElement getInputElement() {
        if (this.fEditor instanceof CEditor) {
            return ((CEditor)this.fEditor).getInputCElement();
        }
        return null;
    }

    private void initializePreferences() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        this.fCollapseFunctions = store.getBoolean("editor_folding_default_functions");
        this.fCollapseStructures = store.getBoolean("editor_folding_default_structures");
        this.fCollapseMacros = store.getBoolean("editor_folding_default_macros");
        this.fCollapseMethods = store.getBoolean("editor_folding_default_methods");
        this.fCollapseHeaderComments = store.getBoolean("editor_folding_default_headers");
        this.fCollapseComments = store.getBoolean("editor_folding_default_comments");
        this.fCollapseInactiveCode = store.getBoolean("editor_folding_default_inactive");
        this.fPreprocessorBranchFoldingEnabled = store.getBoolean("editor_folding_preprocessor_enabled");
        this.fStatementsFoldingEnabled = store.getBoolean("editor_folding_statements");
        this.fCommentFoldingEnabled = true;
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null || !DefaultCFoldingStructureProvider.isConsistent(this.fInput)) {
            return;
        }
        if (!this.fInitialReconcilePending && this.fSelectionListener != null) {
            this.fEditor.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
            this.fSelectionListener = null;
        }
        HashMap<CProjectionAnnotation, Position> additions = new HashMap<CProjectionAnnotation, Position>();
        ArrayList<CProjectionAnnotation> deletions = new ArrayList<CProjectionAnnotation>();
        ArrayList<CProjectionAnnotation> updates = new ArrayList<CProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap updated = ctx.fMap;
        Map<Object, List<Tuple>> previous = this.computeCurrentStructure(ctx);
        for (CProjectionAnnotation newAnnotation : updated.keySet()) {
            Object key = newAnnotation.getElement();
            Position newPosition = (Position)updated.get((Object)newAnnotation);
            List<Tuple> annotations = previous.get(key);
            if (annotations == null) {
                if (DEBUG) {
                    System.out.println("DefaultCFoldingStructureProvider.update() new annotation " + (Object)((Object)newAnnotation));
                }
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator<Tuple> x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                boolean collapseChanged;
                Tuple tuple = x.next();
                CProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (newAnnotation.getCategory() != existingAnnotation.getCategory()) continue;
                boolean bl = collapseChanged = ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed();
                if (existingPosition != null && (collapseChanged || !newPosition.equals((Object)existingPosition))) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (collapseChanged) {
                        if (DEBUG) {
                            System.out.println("DefaultCFoldingStructureProvider.update() change annotation " + (Object)((Object)newAnnotation));
                        }
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                if (DEBUG) {
                    System.out.println("DefaultCFoldingStructureProvider.update() new annotation " + (Object)((Object)newAnnotation));
                }
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            previous.remove(key);
        }
        for (List<Tuple> list : previous.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                CProjectionAnnotation annotation = list.get((int)i).annotation;
                if (DEBUG) {
                    System.out.println("DefaultCFoldingStructureProvider.update() deleted annotation " + (Object)((Object)annotation));
                }
                deletions.add(annotation);
                ++i;
            }
        }
        this.match(deletions, additions, updates, ctx);
        Annotation[] removals = new Annotation[deletions.size()];
        deletions.toArray(removals);
        Annotation[] changes = new Annotation[updates.size()];
        updates.toArray(changes);
        if (DEBUG) {
            System.out.println("DefaultCFoldingStructureProvider.update() " + removals.length + " deleted, " + additions.size() + " added, " + changes.length + " changed");
        }
        ctx.getModel().modifyAnnotations(removals, additions, changes);
    }

    private void match(List<CProjectionAnnotation> deletions, Map<CProjectionAnnotation, Position> additions, List<CProjectionAnnotation> changes, FoldingStructureComputationContext ctx) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<CProjectionAnnotation> newDeletions = new ArrayList<CProjectionAnnotation>();
        ArrayList<CProjectionAnnotation> newChanges = new ArrayList<CProjectionAnnotation>();
        Iterator<CProjectionAnnotation> deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            CProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = ctx.getModel().getPosition((Annotation)deleted);
            if (deletedPosition == null || deletedPosition.length < 5) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null, ctx);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions, ctx);
                addToDeletions = false;
            }
            if (match == null) continue;
            Object element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof CElementPosition && element instanceof ICElement) {
                CElementPosition cep = (CElementPosition)deletedPosition;
                cep.setElement((ICElement)element);
            }
            deletionIterator.remove();
            if (DEBUG) {
                System.out.println("DefaultCFoldingStructureProvider.update() changed annotation " + (Object)((Object)deleted));
            }
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            if (DEBUG) {
                System.out.println("DefaultCFoldingStructureProvider.update() deleted annotation " + (Object)((Object)match.annotation));
            }
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection<CProjectionAnnotation> annotations, Map<CProjectionAnnotation, Position> positionMap, FoldingStructureComputationContext ctx) {
        Iterator<CProjectionAnnotation> it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            CProjectionAnnotation annotation = it.next();
            if (tuple.annotation.getCategory() != annotation.getCategory()) continue;
            Position position2 = position = positionMap == null ? ctx.getModel().getPosition((Annotation)annotation) : positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    private Map<Object, List<Tuple>> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        boolean includeBranches = this.fPreprocessorBranchFoldingEnabled && ctx.fAST != null;
        boolean includeStmts = this.fStatementsFoldingEnabled && ctx.fAST != null;
        boolean includeCModel = ctx.fAST != null || !this.fPreprocessorBranchFoldingEnabled && !this.fStatementsFoldingEnabled;
        HashMap<Object, List<Tuple>> map = new HashMap<Object, List<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            boolean include;
            Object annotation = e.next();
            if (!(annotation instanceof CProjectionAnnotation)) continue;
            CProjectionAnnotation cAnnotation = (CProjectionAnnotation)((Object)annotation);
            switch (cAnnotation.getCategory()) {
                case 2: {
                    include = includeBranches;
                    break;
                }
                case 3: {
                    include = includeStmts;
                    break;
                }
                case 0: {
                    include = includeCModel;
                    break;
                }
                default: {
                    include = true;
                }
            }
            Position position = model.getPosition((Annotation)cAnnotation);
            assert (position != null);
            if (!include && position.length >= 5) continue;
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(cAnnotation.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(cAnnotation.getElement(), list);
            }
            list.add(new Tuple(cAnnotation, position));
        }
        Comparator<Tuple> comparator = new Comparator<Tuple>(){

            @Override
            public int compare(Tuple t1, Tuple t2) {
                return t1.position.getOffset() - t2.position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    private void computeFoldingStructure(final FoldingStructureComputationContext ctx) {
        boolean needAST;
        if (this.fCommentFoldingEnabled) {
            try {
                IDocument doc = ctx.getDocument();
                ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)doc, (String)"___c_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
                this.computeFoldingStructure(partitions, ctx);
            }
            catch (BadLocationException badLocationException) {}
        }
        boolean bl = needAST = this.fPreprocessorBranchFoldingEnabled || this.fStatementsFoldingEnabled;
        if (needAST) {
            IASTTranslationUnit ast = ctx.getAST();
            if (ast != null) {
                this.computeFoldingStructure(ast, ctx);
            } else if (this.fInitialReconcilePending) {
                ASTProvider.WAIT_FLAG waitFlag = ASTProvider.WAIT_ACTIVE_ONLY;
                ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                IStatus status = astProvider.runOnAST(this.getInputElement(), waitFlag, null, new ASTCache.ASTRunnable(){

                    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                        if (ast != null) {
                            ctx.fAST = ast;
                            DefaultCFoldingStructureProvider.this.computeFoldingStructure(ast, ctx);
                        }
                        return Status.OK_STATUS;
                    }
                });
                if (status.matches(4)) {
                    CUIPlugin.log(status);
                }
            }
        }
        if (!needAST || ctx.getAST() != null) {
            this.fInitialReconcilePending = false;
            IParent parent = (IParent)this.fInput;
            try {
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            catch (CModelException cModelException) {}
        }
    }

    static boolean isConsistent(ICElement element) {
        if (element instanceof ITranslationUnit) {
            try {
                return ((ITranslationUnit)element).isConsistent();
            }
            catch (CModelException cModelException) {}
        }
        return false;
    }

    private void computeStatementFoldingStructure(IASTTranslationUnit ast, FoldingStructureComputationContext ctx) {
        Stack iral = new Stack();
        ast.accept((ASTVisitor)new StatementVisitor(iral));
        while (!iral.empty()) {
            StatementRegion mr = (StatementRegion)((Object)iral.pop());
            IRegion aligned = this.alignRegion(mr, ctx, mr.inclusive);
            if (aligned == null) continue;
            Position alignedPos = new Position(aligned.getOffset(), aligned.getLength());
            ctx.addProjectionRange(new CProjectionAnnotation(false, (Object)(String.valueOf(mr.function) + mr.level + this.computeKey(mr, ctx)), 3), alignedPos);
        }
    }

    private void computeFoldingStructure(IASTTranslationUnit ast, FoldingStructureComputationContext ctx) {
        if (ast == null) {
            return;
        }
        String fileName = ast.getFilePath();
        if (fileName == null) {
            return;
        }
        if (this.fStatementsFoldingEnabled) {
            this.computeStatementFoldingStructure(ast, ctx);
        }
        if (this.fPreprocessorBranchFoldingEnabled) {
            this.computePreprocessorFoldingStructure(ast, ctx);
        }
    }

    private void computePreprocessorFoldingStructure(IASTTranslationUnit ast, FoldingStructureComputationContext ctx) {
        IASTPreprocessorStatement[] preprocStmts;
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Stack<Branch> branchStack = new Stack<Branch>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = ast.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation stmtLocation;
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile() && (stmtLocation = statement.getFileLocation()) != null) {
                Branch branch;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifStmt.taken(), "#if " + new String(ifStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifdefStmt.taken(), "#ifdef " + new String(ifdefStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifndefStmt.taken(), "#ifndef " + new String(ifndefStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    if (!branchStack.isEmpty()) {
                        branch = (Branch)((Object)branchStack.pop());
                        IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                        branchStack.push(new Branch(stmtLocation.getNodeOffset(), elseStmt.taken(), branch.fCondition));
                        branch.setEndOffset(stmtLocation.getNodeOffset());
                        branches.add(branch);
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    if (!branchStack.isEmpty()) {
                        branch = (Branch)((Object)branchStack.pop());
                        IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                        branchStack.push(new Branch(stmtLocation.getNodeOffset(), elifStmt.taken(), branch.fCondition));
                        branch.setEndOffset(stmtLocation.getNodeOffset());
                        branches.add(branch);
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement && !branchStack.isEmpty()) {
                    branch = (Branch)((Object)branchStack.pop());
                    branch.setEndOffset(stmtLocation.getNodeOffset() + stmtLocation.getNodeLength());
                    branch.setInclusive(true);
                    branches.add(branch);
                }
            }
            ++n2;
        }
        if (!branchStack.isEmpty()) {
            Branch branch = (Branch)((Object)branchStack.pop());
            branch.setEndOffset(this.getDocument().getLength());
            branch.setInclusive(true);
            branches.add(branch);
        }
        HashMap<String, Counter> keys = new HashMap<String, Counter>(branches.size());
        for (Branch branch : branches) {
            IRegion aligned = this.alignRegion(branch, ctx, branch.fInclusive);
            if (aligned == null) continue;
            Position alignedPos = new Position(aligned.getOffset(), aligned.getLength());
            boolean collapse = !branch.taken() && ctx.collapseInactiveCode() && !alignedPos.includes(this.fCursorPosition);
            String key = branch.fCondition;
            Counter counter = (Counter)keys.get(key);
            if (counter == null) {
                keys.put(key, new Counter());
            } else {
                key = String.valueOf(Integer.toString(counter.fCount++)) + key;
            }
            ctx.addProjectionRange(new CProjectionAnnotation(collapse, (Object)key, 2), alignedPos);
        }
    }

    private Object computeKey(Position pos, FoldingStructureComputationContext ctx) {
        try {
            IDocument document = ctx.getDocument();
            IRegion line = document.getLineInformationOfOffset(pos.offset);
            return document.get(pos.offset, Math.min(32, line.getOffset() + line.getLength() - pos.offset));
        }
        catch (BadLocationException exc) {
            return exc;
        }
    }

    private void computeFoldingStructure(ITypedRegion[] partitions, FoldingStructureComputationContext ctx) throws BadLocationException {
        Position projection;
        boolean collapse = ctx.collapseComments();
        IDocument doc = ctx.getDocument();
        int startLine = -1;
        int endLine = -1;
        ArrayList<Tuple> comments = new ArrayList<Tuple>();
        ModifiableRegion commentRange = new ModifiableRegion();
        ITypedRegion[] iTypedRegionArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                IRegion lineRegion;
                int lineNr;
                block20: {
                    boolean isLineStart;
                    ITypedRegion partition = iTypedRegionArray[n2];
                    boolean singleLine = false;
                    if ("__c_multiline_comment".equals(partition.getType()) || "__c_multiline_doc_comment".equals(partition.getType())) {
                        Position position = this.createCommentPosition(this.alignRegion((IRegion)partition, ctx, true));
                        if (position != null) {
                            if (startLine >= 0 && endLine - startLine >= this.fMinCommentLines) {
                                Position projection2 = this.createCommentPosition(this.alignRegion(commentRange, ctx, true));
                                if (projection2 != null) {
                                    comments.add(new Tuple(new CProjectionAnnotation(collapse, (Object)doc.get(projection2.offset, Math.min(16, projection2.length)), true), projection2));
                                }
                                startLine = -1;
                            }
                            comments.add(new Tuple(new CProjectionAnnotation(collapse, (Object)doc.get(position.offset, Math.min(16, position.length)), true), position));
                        } else {
                            singleLine = true;
                        }
                    } else {
                        singleLine = "__c_singleline_comment".equals(partition.getType());
                    }
                    if (!singleLine) break block19;
                    lineNr = doc.getLineOfOffset(partition.getOffset());
                    lineRegion = doc.getLineInformation(lineNr);
                    boolean bl = isLineStart = partition.getOffset() == lineRegion.getOffset();
                    if (!isLineStart) break block19;
                    if (singleLine) break block20;
                    boolean bl2 = singleLine = lineRegion.getOffset() + lineRegion.getLength() >= partition.getOffset() + partition.getLength();
                    if (!singleLine) break block19;
                }
                if (startLine < 0 || lineNr - endLine > 1) {
                    Position projection3;
                    if (startLine >= 0 && endLine - startLine >= this.fMinCommentLines && (projection3 = this.createCommentPosition(this.alignRegion(commentRange, ctx, true))) != null) {
                        comments.add(new Tuple(new CProjectionAnnotation(collapse, (Object)doc.get(projection3.offset, Math.min(16, projection3.length)), true), projection3));
                    }
                    startLine = lineNr;
                    endLine = lineNr;
                    commentRange.offset = lineRegion.getOffset();
                    commentRange.length = lineRegion.getLength();
                } else {
                    endLine = lineNr;
                    int delta = lineRegion.getOffset() + lineRegion.getLength() - commentRange.offset - commentRange.length;
                    commentRange.length += delta;
                }
            }
            ++n2;
        }
        if (startLine >= 0 && endLine - startLine >= this.fMinCommentLines && (projection = this.createCommentPosition(this.alignRegion(commentRange, ctx, true))) != null) {
            comments.add(new Tuple(new CProjectionAnnotation(collapse, (Object)doc.get(projection.offset, Math.min(16, projection.length)), true), projection));
        }
        if (!comments.isEmpty()) {
            Iterator iter = comments.iterator();
            Tuple tuple = (Tuple)iter.next();
            int lineNr = doc.getLineOfOffset(tuple.position.getOffset());
            if (lineNr < 10) {
                if (ctx.collapseHeaderComments()) {
                    tuple.annotation.markCollapsed();
                } else {
                    tuple.annotation.markExpanded();
                }
            }
            ctx.addProjectionRange(tuple.annotation, tuple.position);
            while (iter.hasNext()) {
                tuple = (Tuple)iter.next();
                ctx.addProjectionRange(tuple.annotation, tuple.position);
            }
        }
    }

    private void computeFoldingStructure(ICElement[] elements, FoldingStructureComputationContext ctx) throws CModelException {
        ICElement[] iCElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement element = iCElementArray[n2];
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++n2;
        }
    }

    protected void computeFoldingStructure(ICElement element, FoldingStructureComputationContext ctx) {
        Position position;
        IRegion normalized;
        boolean collapse = false;
        switch (element.getElementType()) {
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 83: 
            case 85: 
            case 87: {
                collapse = ctx.collapseStructures();
                break;
            }
            case 79: {
                collapse = ctx.collapseMacros();
                break;
            }
            case 74: 
            case 89: {
                collapse = ctx.collapseFunctions();
                break;
            }
            case 70: 
            case 91: {
                collapse = ctx.collapseMethods();
                break;
            }
            case 61: {
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] regions = this.computeProjectionRanges((ISourceReference)element, ctx);
        if (regions.length > 0 && (normalized = this.alignRegion(regions[regions.length - 1], ctx, true)) != null && (position = this.createElementPosition(normalized, element)) != null) {
            collapse = collapse && !position.includes(this.fCursorPosition);
            ctx.addProjectionRange(new CProjectionAnnotation(collapse, (Object)element, false), position);
        }
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference reference, FoldingStructureComputationContext ctx) {
        try {
            ISourceRange range = reference.getSourceRange();
            return new IRegion[]{new Region(range.getStartPos(), range.getLength())};
        }
        catch (CModelException cModelException) {
            return new IRegion[0];
        }
    }

    protected final Position createCommentPosition(IRegion aligned) {
        if (aligned == null) {
            return null;
        }
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createElementPosition(IRegion aligned, ICElement element) {
        return new CElementPosition(aligned.getOffset(), aligned.getLength(), element);
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        return this.alignRegion(region, ctx, true);
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx, boolean inclusive) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = inclusive ? (document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end)) : document.getLineOffset(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fEditor.getEditorInput());
    }

    private static class Branch
    extends ModifiableRegion {
        private final boolean fTaken;
        public final String fCondition;
        public boolean fInclusive;

        Branch(int offset, boolean taken, String key) {
            this(offset, 0, taken, key);
        }

        Branch(int offset, int length, boolean taken, String key) {
            super(offset, length);
            this.fTaken = taken;
            this.fCondition = key;
        }

        public void setEndOffset(int endOffset) {
            this.setLength(endOffset - this.getOffset());
        }

        public boolean taken() {
            return this.fTaken;
        }

        public void setInclusive(boolean inclusive) {
            this.fInclusive = inclusive;
        }
    }

    private static final class CElementPosition
    extends Position
    implements IProjectionPosition {
        private ICElement fElement;

        public CElementPosition(int offset, int length, ICElement element) {
            super(offset, length);
            Assert.isNotNull((Object)element);
            this.fElement = element;
        }

        public void setElement(ICElement member) {
            Assert.isNotNull((Object)member);
            this.fElement = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int captionOffset = this.offset;
            try {
                ISourceRange sourceRange;
                if (this.fElement instanceof ISourceReference && (sourceRange = ((ISourceReference)this.fElement).getSourceRange()) != null) {
                    captionOffset = sourceRange.getIdStartPos() + sourceRange.getIdLength() - 1;
                }
            }
            catch (CModelException cModelException) {}
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(captionOffset);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int captionOffset = this.offset;
            try {
                ISourceRange sourceRange;
                if (this.fElement instanceof ISourceReference && (sourceRange = ((ISourceReference)this.fElement).getSourceRange()) != null && (captionOffset = sourceRange.getIdStartPos() + sourceRange.getIdLength() - 1) < this.offset) {
                    captionOffset = this.offset;
                }
            }
            catch (CModelException cModelException) {}
            return captionOffset - this.offset;
        }
    }

    private static class CProjectionAnnotation
    extends ProjectionAnnotation {
        public static final int CMODEL = 0;
        public static final int COMMENT = 1;
        public static final int BRANCH = 2;
        public static final int STATEMENT = 3;
        private Object fKey;
        private int fCategory;

        public CProjectionAnnotation(boolean isCollapsed, Object key, boolean isComment) {
            this(isCollapsed, key, isComment ? 1 : 0);
        }

        public CProjectionAnnotation(boolean isCollapsed, Object key, int category) {
            super(isCollapsed);
            this.fKey = key;
            this.fCategory = category;
        }

        public Object getElement() {
            return this.fKey;
        }

        public void setElement(Object element) {
            this.fKey = element;
        }

        public int getCategory() {
            return this.fCategory;
        }

        public String toString() {
            return "CProjectionAnnotation:\n\tkey: \t" + this.fKey + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcategory: \t" + this.getCategory() + "\n";
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private static final class Counter {
        int fCount;

        private Counter() {
        }
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private ISourceReference fFirstType;
        private boolean fHasHeaderComment;
        private LinkedHashMap<CProjectionAnnotation, Position> fMap = new LinkedHashMap();
        private IASTTranslationUnit fAST;

        FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            Assert.isNotNull((Object)document);
            Assert.isNotNull((Object)model);
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        void setFirstType(ISourceReference reference) {
            if (this.hasFirstType()) {
                throw new IllegalStateException();
            }
            this.fFirstType = reference;
        }

        boolean hasFirstType() {
            return this.fFirstType != null;
        }

        ISourceReference getFirstType() {
            return this.fFirstType;
        }

        boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        IDocument getDocument() {
            return this.fDocument;
        }

        ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(CProjectionAnnotation annotation, Position position) {
            this.fMap.put(annotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseHeaderComments;
        }

        public boolean collapseComments() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseComments;
        }

        public boolean collapseFunctions() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseFunctions;
        }

        public boolean collapseMacros() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseMacros;
        }

        public boolean collapseMethods() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseMethods;
        }

        public boolean collapseStructures() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseStructures;
        }

        public boolean collapseInactiveCode() {
            return this.fAllowCollapsing && DefaultCFoldingStructureProvider.this.fCollapseInactiveCode;
        }

        public IASTTranslationUnit getAST() {
            return this.fAST;
        }
    }

    private class FoldingStructureReconciler
    implements ICReconcilingListener {
        private volatile boolean fReconciling;

        private FoldingStructureReconciler() {
        }

        @Override
        public void aboutToBeReconciled() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
            if (DefaultCFoldingStructureProvider.this.fInput == null || progressMonitor.isCanceled()) {
                return;
            }
            FoldingStructureReconciler foldingStructureReconciler = this;
            synchronized (foldingStructureReconciler) {
                if (this.fReconciling) {
                    return;
                }
                this.fReconciling = true;
            }
            try {
                boolean initialReconcile = DefaultCFoldingStructureProvider.this.fInitialReconcilePending;
                DefaultCFoldingStructureProvider.this.fInitialReconcilePending = false;
                FoldingStructureComputationContext ctx = DefaultCFoldingStructureProvider.this.createContext(initialReconcile);
                if (ctx != null) {
                    if (initialReconcile || !this.hasSyntaxError(ast)) {
                        ctx.fAST = ast;
                    }
                    DefaultCFoldingStructureProvider.this.update(ctx);
                }
            }
            finally {
                this.fReconciling = false;
            }
        }

        private boolean hasSyntaxError(IASTTranslationUnit ast) {
            IASTProblem problem;
            IASTProblem[] problems;
            if (ast == null) {
                return false;
            }
            IASTProblem[] iASTProblemArray = problems = ast.getPreprocessorProblems();
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                problem = iASTProblemArray[n2];
                if ((problem.getID() & 0x5000001) != 0) {
                    return true;
                }
                ++n2;
            }
            iASTProblemArray = problems = CPPVisitor.getProblems((IASTTranslationUnit)ast);
            n = problems.length;
            n2 = 0;
            while (n2 < n) {
                problem = iASTProblemArray[n2];
                if ((problem.getID() & 0x5000001) != 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class ModifiableRegion
    extends Position
    implements IRegion {
        ModifiableRegion() {
        }

        ModifiableRegion(int offset, int length) {
            super(offset, length);
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultCFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultCFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private final class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection s = event.getSelection();
            if (s instanceof ITextSelection) {
                ITextSelection selection = (ITextSelection)event.getSelection();
                DefaultCFoldingStructureProvider.this.fCursorPosition = selection.getOffset();
            }
        }
    }

    private static class StatementRegion
    extends ModifiableRegion {
        public final String function;
        public int level;
        public boolean inclusive;

        public StatementRegion(String function, int level) {
            this.function = function;
            this.level = level;
        }
    }

    private final class StatementVisitor
    extends ASTVisitor {
        private final Stack<StatementRegion> fStatements;
        int fLevel;
        Stack<String> fScope;

        private StatementVisitor(Stack<StatementRegion> statements) {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.fLevel = 0;
            this.fScope = new Stack();
            this.fStatements = statements;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int visit(IASTStatement statement) {
            ++this.fLevel;
            if (!statement.isPartOfTranslationUnitFile()) {
                return 1;
            }
            try {
                IASTStatement switchstmt;
                if (statement instanceof IASTIfStatement) {
                    IASTIfStatement ifstmt = (IASTIfStatement)statement;
                    IASTFileLocation fl = ifstmt.getFileLocation();
                    if (fl == null) {
                        return 3;
                    }
                    int ifOffset = fl.getNodeOffset();
                    StatementRegion mr = this.createRegion();
                    IASTStatement thenStmt = ifstmt.getThenClause();
                    if (thenStmt == null) {
                        return 3;
                    }
                    fl = thenStmt.getFileLocation();
                    mr.setLength(fl.getNodeOffset() + fl.getNodeLength() - ifOffset);
                    mr.setOffset(ifOffset);
                    mr.inclusive = !(thenStmt instanceof IASTCompoundStatement);
                    IASTStatement elseStmt = ifstmt.getElseClause();
                    if (elseStmt == null) {
                        mr.inclusive = true;
                        this.fStatements.push(mr);
                        return 3;
                    }
                    IASTFileLocation elseStmtLocation = elseStmt.getFileLocation();
                    boolean bl = mr.inclusive = mr.inclusive || fl.getEndingLineNumber() < elseStmtLocation.getStartingLineNumber();
                    if (elseStmt instanceof IASTIfStatement) {
                        this.fStatements.push(mr);
                        return 3;
                    }
                    this.fStatements.push(mr);
                    mr = this.createRegion();
                    mr.setLength(elseStmtLocation.getNodeLength());
                    mr.setOffset(elseStmtLocation.getNodeOffset());
                    mr.inclusive = true;
                    this.fStatements.push(mr);
                    return 3;
                }
                StatementRegion mr = this.createRegion();
                mr.inclusive = true;
                if (statement instanceof IASTDoStatement) {
                    mr.inclusive = false;
                }
                if (statement instanceof IASTSwitchStatement && (switchstmt = ((IASTSwitchStatement)statement).getBody()) instanceof IASTCompoundStatement) {
                    IASTStatement[] stmts = ((IASTCompoundStatement)switchstmt).getStatements();
                    boolean pushedMR = false;
                    IASTStatement[] iASTStatementArray = stmts;
                    int n = stmts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StatementRegion tmpmr;
                        IASTFileLocation tmpfl;
                        IASTStatement tmpstmt = iASTStatementArray[n2];
                        if (!(tmpstmt instanceof IASTCaseStatement) && !(tmpstmt instanceof IASTDefaultStatement)) {
                            if (!pushedMR) {
                                return 1;
                            }
                            tmpfl = tmpstmt.getFileLocation();
                            tmpmr = this.fStatements.peek();
                            tmpmr.setLength(tmpfl.getNodeLength() + tmpfl.getNodeOffset() - tmpmr.getOffset());
                            if (tmpstmt instanceof IASTBreakStatement) {
                                pushedMR = false;
                            }
                        } else {
                            tmpmr = this.createRegion();
                            tmpmr.level = this.fLevel + 1;
                            tmpmr.inclusive = true;
                            if (tmpstmt instanceof IASTCaseStatement) {
                                IASTCaseStatement casestmt = (IASTCaseStatement)tmpstmt;
                                tmpfl = casestmt.getExpression().getFileLocation();
                                tmpmr.setOffset(tmpfl.getNodeOffset());
                                tmpmr.setLength(tmpfl.getNodeLength());
                            } else if (tmpstmt instanceof IASTDefaultStatement) {
                                IASTDefaultStatement defstmt = (IASTDefaultStatement)tmpstmt;
                                tmpfl = defstmt.getFileLocation();
                                tmpmr.setOffset(tmpfl.getNodeOffset() + tmpfl.getNodeLength());
                                tmpmr.setLength(0);
                            }
                            this.fStatements.push(tmpmr);
                            pushedMR = true;
                        }
                        ++n2;
                    }
                }
                if (statement instanceof IASTForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement || statement instanceof IASTSwitchStatement || statement instanceof ICPPASTRangeBasedForStatement) {
                    IASTFileLocation fl = statement.getFileLocation();
                    mr.setLength(fl.getNodeLength());
                    mr.setOffset(fl.getNodeOffset());
                    this.fStatements.push(mr);
                }
                return 3;
            }
            catch (Exception e) {
                CUIPlugin.log(e);
                return 2;
            }
        }

        public int leave(IASTStatement statement) {
            --this.fLevel;
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            IASTDeclSpecifier declSpecifier;
            if (!declaration.isPartOfTranslationUnitFile()) {
                return 1;
            }
            if (declaration instanceof IASTFunctionDefinition) {
                IASTFunctionDeclarator declarator = ((IASTFunctionDefinition)declaration).getDeclarator();
                if (declarator != null) {
                    this.fScope.push(new String(ASTQueries.findInnermostDeclarator((IASTDeclarator)declarator).getName().toCharArray()));
                    this.fLevel = 0;
                }
            } else if (declaration instanceof IASTSimpleDeclaration && (declSpecifier = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTCompositeTypeSpecifier) {
                this.fScope.push(new String(((IASTCompositeTypeSpecifier)declSpecifier).getName().toCharArray()));
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            IASTDeclSpecifier declSpecifier;
            if (declaration instanceof IASTFunctionDefinition) {
                if (!this.fScope.isEmpty()) {
                    this.fScope.pop();
                }
            } else if (declaration instanceof IASTSimpleDeclaration && (declSpecifier = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTCompositeTypeSpecifier && !this.fScope.isEmpty()) {
                this.fScope.pop();
            }
            return 3;
        }

        private StatementRegion createRegion() {
            return new StatementRegion(this.fScope.toString(), this.fLevel);
        }
    }

    private static final class Tuple {
        CProjectionAnnotation annotation;
        Position position;

        Tuple(CProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

