/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.UvmManager;
import com.nvidia.viper.ui.analysis.UvmFilterAddressFamily;
import com.nvidia.viper.ui.analysis.UvmFilterChecksFamily;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UvmFilter
extends Composite {
    private Session activeSession;
    private UvmManager uvmManager;
    private UvmFilterState uvmFilterState;
    private Button filterCheck;
    private UvmFilterAddressFamily uvmFilterAddress;
    private List<UvmItem> filterItems = new ArrayList<UvmItem>();
    private List<UvmFilterChecksFamily> filterChecksFamilyItems = new ArrayList<UvmFilterChecksFamily>();
    private Button analyzeButton;
    private Table summaryTable;
    private TableItem summaryTableItem;
    public ISessionPropertyChangeListener timelineUnfocusListerner = new ISessionPropertyChangeListener(){

        @Override
        public void propertyChange(IModel model, String propertyName) {
            if ("session:unfocus:timelines".equals(propertyName) && UvmFilter.this.activeSession.isUvmFilterEnabled()) {
                try {
                    UvmFilter.this.filterCheck.setSelection(false);
                    UvmFilter.this.filterButtonModified();
                }
                catch (Exception exception) {
                    UvmFilter.this.removeUvmFilter();
                }
            }
        }
    };

    public UvmFilter(Composite parent, Control prev, Session session) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(1, false));
        this.activeSession = session;
        this.uvmManager = this.activeSession.getUvmManager();
        this.createFilterOptions(parent, prev);
        this.activeSession.addPropertyChangeListener(this.timelineUnfocusListerner);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UvmFilter.this.activeSession.removePropertyChangeListener(UvmFilter.this.timelineUnfocusListerner);
            }
        });
    }

    private void createFilterOptions(Composite parent, Control prev) {
        this.filterCheck = new Button((Composite)this, 32);
        this.filterCheck.setText("Filter Timelines");
        this.filterCheck.setToolTipText("Check this to enable filtering and analysing");
        this.filterCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.uvmFilterAddress = new UvmFilterAddressFamily(this, 2048, this.uvmManager.getMinAddress(), this.uvmManager.getMaxAddress());
        this.uvmFilterAddress.setLayoutData(new GridData(1, 0x1000000, true, false));
        Group group = new Group((Composite)this, 2048);
        group.setLayout((Layout)new GridLayout());
        List<TimelineIntervalKind> filterKinds = this.getFilterKinds();
        this.filterItems.clear();
        this.filterChecksFamilyItems.clear();
        for (TimelineIntervalKind filterKind : filterKinds) {
            Button button;
            if (filterKind == TimelineIntervalKind.UVM_THRASHING) {
                button = new Button((Composite)group, 32);
                button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                button.setText("Memory Thrashing");
                button.setSelection(true);
                this.filterItems.add(new UvmItem(button, filterKind));
                continue;
            }
            if (filterKind == TimelineIntervalKind.UVM_PAGE_THROTTLING) {
                button = new Button((Composite)group, 32);
                button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                button.setText("Page Throttling");
                button.setSelection(true);
                this.filterItems.add(new UvmItem(button, filterKind));
                continue;
            }
            UvmFilterChecksFamily checksFamily = new UvmFilterChecksFamily((Composite)group, 2052, filterKind);
            checksFamily.setLayout(prev);
            this.filterChecksFamilyItems.add(checksFamily);
        }
        group.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.analyzeButton = new Button((Composite)this, 8);
        this.analyzeButton.setText("Filter and Analyze");
        this.analyzeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.filterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UvmFilter.this.filterButtonModified();
            }
        });
        this.addAnalyzeButtonListner();
        this.createSummaryTable();
        this.setUvmFilterState();
    }

    private List<TimelineIntervalKind> getFilterKinds() {
        ArrayList<TimelineIntervalKind> filterKinds = new ArrayList<TimelineIntervalKind>();
        HashSet<TimelineIntervalKind> intervalKinds = new HashSet<TimelineIntervalKind>();
        for (Timeline tl : this.activeSession.getTimelines()) {
            intervalKinds.addAll(tl.getIntervalKinds());
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_THRASHING)) {
            filterKinds.add(TimelineIntervalKind.UVM_THRASHING);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_PAGE_THROTTLING)) {
            filterKinds.add(TimelineIntervalKind.UVM_PAGE_THROTTLING);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
            filterKinds.add(TimelineIntervalKind.UVM_PAGE_FAULT);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT)) {
            filterKinds.add(TimelineIntervalKind.UVM_GPU_PAGE_FAULT);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_HTOD)) {
            filterKinds.add(TimelineIntervalKind.UVM_MEMCPY_HTOD);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_DTOH)) {
            filterKinds.add(TimelineIntervalKind.UVM_MEMCPY_DTOH);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_DTOD)) {
            filterKinds.add(TimelineIntervalKind.UVM_MEMCPY_DTOD);
        }
        if (intervalKinds.contains((Object)TimelineIntervalKind.UVM_REMOTE_MAP)) {
            filterKinds.add(TimelineIntervalKind.UVM_REMOTE_MAP);
        }
        return filterKinds;
    }

    private void setUvmFilterState() {
        if (this.uvmManager.getUvmFilterState() == null) {
            this.uvmFilterState = new UvmFilterState();
            this.uvmFilterAddress.setState(null);
            for (UvmFilterChecksFamily checksFamily : this.filterChecksFamilyItems) {
                checksFamily.setState(null);
            }
            for (UvmItem item : this.filterItems) {
                item.item.setEnabled(false);
            }
            this.analyzeButton.setEnabled(false);
        } else {
            this.uvmFilterState = this.uvmManager.getUvmFilterState();
            this.filterCheck.setSelection(this.uvmFilterState.filterCheckState.booleanValue());
            this.uvmFilterAddress.setState(this.uvmFilterState.addressState);
            for (UvmFilterChecksFamily checksFamily : this.filterChecksFamilyItems) {
                checksFamily.setState(this.getFilterCheckState(checksFamily.getKind()));
            }
            for (UvmItem item : this.filterItems) {
                item.item.setEnabled(this.filterCheck.getSelection());
                item.item.setSelection(this.getItemState(item.kind).selectionState.booleanValue());
            }
            this.updateSummaryTable();
        }
    }

    private UvmFilterChecksFamily.UvmFilterCheckState getFilterCheckState(TimelineIntervalKind kind) {
        switch (kind) {
            case UVM_MEMCPY_DTOD: {
                return this.uvmFilterState.dToDFilterState;
            }
            case UVM_MEMCPY_DTOH: {
                return this.uvmFilterState.dToHFilterState;
            }
            case UVM_MEMCPY_HTOD: {
                return this.uvmFilterState.hToDFilterState;
            }
            case UVM_GPU_PAGE_FAULT: {
                return this.uvmFilterState.gpuFilterState;
            }
            case UVM_PAGE_FAULT: {
                return this.uvmFilterState.cpuFilterState;
            }
            case UVM_REMOTE_MAP: {
                return this.uvmFilterState.remoteMapState;
            }
        }
        return null;
    }

    private UvmItemState getItemState(TimelineIntervalKind kind) {
        if (kind == TimelineIntervalKind.UVM_THRASHING) {
            return this.uvmFilterState.thrashingState;
        }
        if (kind == TimelineIntervalKind.UVM_PAGE_THROTTLING) {
            return this.uvmFilterState.throttlingState;
        }
        return null;
    }

    private void addAnalyzeButtonListner() {
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UvmFilter.this.activeSession.focusFilteredUvmIntervals(false);
                UvmFilter.this.setFilteredIntervals();
                UvmFilter.this.updateSummaryTable();
                UvmFilter.this.activeSession.setTimelineFocusMode(Session.TimelineFocusMode.UVM_FILTER, true);
                UvmFilter.this.activeSession.focusFilteredUvmIntervals(true);
            }
        });
    }

    private void updateUvmFilterState() {
        this.uvmFilterState.filterCheckState = this.filterCheck.getSelection();
        this.uvmFilterState.addressState = this.uvmFilterAddress.getState();
        for (UvmFilterChecksFamily checksFamilyItem : this.filterChecksFamilyItems) {
            switch (checksFamilyItem.getKind()) {
                case UVM_MEMCPY_DTOD: {
                    this.uvmFilterState.dToDFilterState = checksFamilyItem.getState();
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    this.uvmFilterState.dToHFilterState = checksFamilyItem.getState();
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    this.uvmFilterState.hToDFilterState = checksFamilyItem.getState();
                    break;
                }
                case UVM_GPU_PAGE_FAULT: {
                    this.uvmFilterState.gpuFilterState = checksFamilyItem.getState();
                    break;
                }
                case UVM_PAGE_FAULT: {
                    this.uvmFilterState.cpuFilterState = checksFamilyItem.getState();
                    break;
                }
                case UVM_REMOTE_MAP: {
                    this.uvmFilterState.remoteMapState = checksFamilyItem.getState();
                }
            }
        }
        for (UvmItem item : this.filterItems) {
            if (item.kind == TimelineIntervalKind.UVM_THRASHING) {
                this.uvmFilterState.thrashingState.selectionState = item.item.getSelection();
                continue;
            }
            if (item.kind != TimelineIntervalKind.UVM_PAGE_THROTTLING) continue;
            this.uvmFilterState.throttlingState.selectionState = item.item.getSelection();
        }
        this.uvmManager.setUvmFilterState(this.uvmFilterState);
    }

    private void filterButtonModified() {
        if (this.filterCheck.getSelection()) {
            this.uvmFilterAddress.setEnabled(true);
            for (UvmFilterChecksFamily checksFamily : this.filterChecksFamilyItems) {
                checksFamily.setEnabled(true);
            }
            for (UvmItem item : this.filterItems) {
                item.item.setEnabled(true);
            }
            this.analyzeButton.setEnabled(true);
        } else {
            this.uvmFilterAddress.setEnabled(false);
            for (UvmFilterChecksFamily checksFamily : this.filterChecksFamilyItems) {
                checksFamily.setEnabled(false);
            }
            for (UvmItem item : this.filterItems) {
                item.item.setEnabled(false);
            }
            this.analyzeButton.setEnabled(false);
            this.removeSummaryTableEntries();
            this.removeUvmFilter();
        }
    }

    private void setFilteredIntervals() {
        this.updateUvmFilterState();
        long startAddress = this.uvmFilterState.addressState.getUserStartAddress();
        long endAddress = this.uvmFilterState.addressState.getUserEndAddress();
        List<Timeline> timelines = this.activeSession.getTimelines();
        ArrayList<Long> intervalIds = new ArrayList<Long>();
        HashSet<ITimelineInterval> hToDMigrationIntervals = new HashSet<ITimelineInterval>();
        HashSet<ITimelineInterval> dToHMigrationIntervals = new HashSet<ITimelineInterval>();
        HashSet<ITimelineInterval> dToDMigrationIntervals = new HashSet<ITimelineInterval>();
        HashSet<ITimelineInterval> gpuPageFaultIntervals = new HashSet<ITimelineInterval>();
        HashSet<ITimelineInterval> cpuPageFaultIntervals = new HashSet<ITimelineInterval>();
        HashSet<ITimelineInterval> thrashingThrottlingRemoteMapIntervals = new HashSet<ITimelineInterval>();
        for (Timeline tl : timelines) {
            switch (tl.getKind()) {
                case UVM_MEMCPY_HTOD: {
                    hToDMigrationIntervals.addAll(tl.getIntervals(true));
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    dToHMigrationIntervals.addAll(tl.getIntervals(true));
                    break;
                }
                case UVM_MEMCPY_DTOD: {
                    dToDMigrationIntervals.addAll(tl.getIntervals(true));
                    break;
                }
                case UVM_GPU_PAGE_FAULT: {
                    gpuPageFaultIntervals.addAll(tl.getIntervals(true));
                    break;
                }
                case UVM_PAGE_FAULT: {
                    cpuPageFaultIntervals.addAll(tl.getIntervals(true));
                    break;
                }
                case UVM_THRASHING_THROTTLING: {
                    thrashingThrottlingRemoteMapIntervals.addAll(tl.getIntervals(false));
                }
            }
        }
        for (UvmFilterChecksFamily checksFamily : this.filterChecksFamilyItems) {
            switch (checksFamily.getKind()) {
                case UVM_MEMCPY_DTOD: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(dToDMigrationIntervals, startAddress, endAddress));
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(dToHMigrationIntervals, startAddress, endAddress));
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(hToDMigrationIntervals, startAddress, endAddress));
                    break;
                }
                case UVM_GPU_PAGE_FAULT: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(gpuPageFaultIntervals, startAddress, endAddress));
                    break;
                }
                case UVM_PAGE_FAULT: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(cpuPageFaultIntervals, startAddress, endAddress));
                    break;
                }
                case UVM_REMOTE_MAP: {
                    intervalIds.addAll(checksFamily.getFilteredIntervals(thrashingThrottlingRemoteMapIntervals, startAddress, endAddress));
                }
            }
        }
        for (UvmItem item : this.filterItems) {
            intervalIds.addAll(this.getFilteredItemIntervals(item.kind, startAddress, endAddress, thrashingThrottlingRemoteMapIntervals));
        }
        this.uvmManager.setFilteredUvmIntervalIds(intervalIds);
    }

    private List<Long> getFilteredItemIntervals(TimelineIntervalKind kind, long startAddress, long endAddress, HashSet<ITimelineInterval> timelineIntervals) {
        ArrayList<Long> intervalIds = new ArrayList<Long>();
        UvmItemState state = this.getItemState(kind);
        state.totalValue = 0L;
        state.filteredAddresses.clear();
        if (state.selectionState.booleanValue()) {
            for (ITimelineInterval interval : timelineIntervals) {
                TimelineIntervalUVM UVMInterval = (TimelineIntervalUVM)interval;
                if (UVMInterval.getAddress() < startAddress || UVMInterval.getAddress() > endAddress || UVMInterval.getKind() != kind) continue;
                intervalIds.add(UVMInterval.getID());
                state.filteredAddresses.add(UVMInterval.getAddress());
                if (kind == TimelineIntervalKind.UVM_THRASHING) {
                    UvmItemState uvmItemState = state;
                    uvmItemState.totalValue = uvmItemState.totalValue + UVMInterval.getCounterValue();
                    continue;
                }
                UvmItemState uvmItemState = state;
                uvmItemState.totalValue = uvmItemState.totalValue + 1L;
            }
        }
        return intervalIds;
    }

    private void removeUvmFilter() {
        this.uvmManager.setFilteredUvmIntervalIds(null);
        this.uvmManager.setUvmFilterState(null);
        this.activeSession.setTimelineFocusMode(Session.TimelineFocusMode.UVM_FILTER, false);
        this.activeSession.focusFilteredUvmIntervals(false);
    }

    private void createSummaryTable() {
        Label desc = new Label((Composite)this, 64);
        desc.setLayoutData((Object)new GridData(4, 4, true, true));
        desc.setText("The following table shows the summary of unified memory migrations and page faults after filtering");
        this.summaryTable = new Table((Composite)this, 2560);
        this.summaryTable.setHeaderVisible(true);
        this.summaryTable.setLinesVisible(true);
        this.summaryTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.summaryTableItem = new TableItem(this.summaryTable, 4);
        for (SummaryTableColumns summaryTableColumn : SummaryTableColumns.getOrderedSummaryTableColumns(this)) {
            TableColumn column = new TableColumn(this.summaryTable, 4);
            column.setText(summaryTableColumn.header);
            column.setToolTipText(summaryTableColumn.tooltip);
        }
        this.packColumns();
    }

    private void updateSummaryTable() {
        int i = 0;
        for (SummaryTableColumns summaryTableColumn : SummaryTableColumns.getOrderedSummaryTableColumns(this)) {
            this.summaryTableItem.setText(i, summaryTableColumn.textManager.getText(this));
            ++i;
        }
        this.packColumns();
    }

    private void removeSummaryTableEntries() {
        int i = 0;
        while (i < SummaryTableColumns.getOrderedSummaryTableColumns(this).size()) {
            this.summaryTableItem.setText(i, "");
            ++i;
        }
        this.packColumns();
    }

    private void packColumns() {
        TableColumn[] tableColumnArray = this.summaryTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private static class CpuFaultsTextManager
    extends TextManager {
        private CpuFaultsTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return Long.toString(uvmFilter.uvmFilterState.cpuFilterState.getTotalValue());
        }
    }

    private static class DtoDTextManager
    extends TextManager {
        private DtoDTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(uvmFilter.uvmFilterState.dToDFilterState.getTotalValue());
        }
    }

    private static class DtoHTextManager
    extends TextManager {
        private DtoHTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(uvmFilter.uvmFilterState.dToHFilterState.getTotalValue());
        }
    }

    private static class GpuFaultsTextManager
    extends TextManager {
        private GpuFaultsTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return Long.toString(uvmFilter.uvmFilterState.gpuFilterState.getTotalValue());
        }
    }

    private static class HtoDTextManager
    extends TextManager {
        private HtoDTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(uvmFilter.uvmFilterState.hToDFilterState.getTotalValue());
        }
    }

    private static class RemoteMapTextManager
    extends TextManager {
        private RemoteMapTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(uvmFilter.uvmFilterState.remoteMapState.getTotalValue());
        }
    }

    private static enum SummaryTableColumns {
        TOTAL_HTOD_MIGRATION_SIZE("Total HtoD migration size", "Total HtoD migration size", new HtoDTextManager()),
        TOTAL_DTOH_MIGRATION_SIZE("Total DtoH migration size", "Total DtoH migration size", new DtoHTextManager()),
        TOTAL_DTOD_MIGRATION_SIZE("Total DtoD migration size", "Total DtoD migration size", new DtoDTextManager()),
        TOTAL_CPU_PAGE_FAULTS("Total CPU Page faults", "Total CPU page faults", new CpuFaultsTextManager()),
        TOTAL_GPU_PAGE_FAULTS("Total GPU Page faults", "Total GPU page faults", new GpuFaultsTextManager()),
        TOTAL_REMOTE_MAP_SIZE("Total Remote Map Size", "Total Remote Map Size", new RemoteMapTextManager()),
        TOTAL_THRASHING("Total thrashing size", "Total thrashing size", new ThrashingTextManager()),
        TOTAL_THROTTLING("Total throttles", "Total throttles", new ThrottlingTextManager()),
        TOTAL_PAGES("Total different pages", "The number of distinct pages in which either migrations or page faults have occured", new TotalPagesTextManager());

        private String header;
        private String tooltip;
        private TextManager textManager;

        private SummaryTableColumns(String header, String tooltip, TextManager textManager) {
            this.header = header;
            this.tooltip = tooltip;
            this.textManager = textManager;
        }

        private static List<SummaryTableColumns> getOrderedSummaryTableColumns(UvmFilter uvmFilter) {
            ArrayList<SummaryTableColumns> columns2 = new ArrayList<SummaryTableColumns>();
            List filterKinds = uvmFilter.getFilterKinds();
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_HTOD)) {
                columns2.add(TOTAL_HTOD_MIGRATION_SIZE);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_DTOH)) {
                columns2.add(TOTAL_DTOH_MIGRATION_SIZE);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_MEMCPY_DTOD)) {
                columns2.add(TOTAL_DTOD_MIGRATION_SIZE);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
                columns2.add(TOTAL_CPU_PAGE_FAULTS);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_GPU_PAGE_FAULT)) {
                columns2.add(TOTAL_GPU_PAGE_FAULTS);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_THRASHING)) {
                columns2.add(TOTAL_THRASHING);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_PAGE_THROTTLING)) {
                columns2.add(TOTAL_THROTTLING);
            }
            if (filterKinds.contains((Object)TimelineIntervalKind.UVM_REMOTE_MAP)) {
                columns2.add(TOTAL_REMOTE_MAP_SIZE);
            }
            columns2.add(TOTAL_PAGES);
            return columns2;
        }
    }

    private static abstract class TextManager {
        private TextManager() {
        }

        protected abstract String getText(UvmFilter var1);
    }

    private static class ThrashingTextManager
    extends TextManager {
        private ThrashingTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(uvmFilter.uvmFilterState.thrashingState.getTotalValue());
        }
    }

    private static class ThrottlingTextManager
    extends TextManager {
        private ThrottlingTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            return Long.toString(uvmFilter.uvmFilterState.throttlingState.getTotalValue());
        }
    }

    private static class TotalPagesTextManager
    extends TextManager {
        private TotalPagesTextManager() {
        }

        @Override
        protected String getText(UvmFilter uvmFilter) {
            HashSet<Long> filteredAddress = new HashSet<Long>();
            for (UvmFilterChecksFamily checkFamily : uvmFilter.filterChecksFamilyItems) {
                filteredAddress.addAll(uvmFilter.getFilterCheckState(checkFamily.getKind()).getFilteredAddresses());
            }
            for (UvmItem item : uvmFilter.filterItems) {
                filteredAddress.addAll(uvmFilter.getItemState(item.kind).filteredAddresses);
            }
            return Integer.toString(filteredAddress.size());
        }
    }

    public static class UvmFilterState {
        private Boolean filterCheckState;
        private UvmFilterAddressFamily.UvmFilterAddressState addressState;
        private UvmItemState thrashingState = new UvmItemState();
        private UvmItemState throttlingState = new UvmItemState();
        private UvmFilterChecksFamily.UvmFilterCheckState cpuFilterState;
        private UvmFilterChecksFamily.UvmFilterCheckState gpuFilterState;
        private UvmFilterChecksFamily.UvmFilterCheckState hToDFilterState;
        private UvmFilterChecksFamily.UvmFilterCheckState dToHFilterState;
        private UvmFilterChecksFamily.UvmFilterCheckState dToDFilterState;
        private UvmFilterChecksFamily.UvmFilterCheckState remoteMapState;
    }

    private static class UvmItem {
        private Button item;
        private TimelineIntervalKind kind;

        public UvmItem(Button item, TimelineIntervalKind kind) {
            this.item = item;
            this.kind = kind;
        }
    }

    private static class UvmItemState {
        private Boolean selectionState;
        private Set<Long> filteredAddresses = new HashSet<Long>();
        private long totalValue;

        private UvmItemState() {
        }

        public long getTotalValue() {
            return this.totalValue;
        }
    }
}

