/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityBranch;
import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.activity.CuptiActivitySharedAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResultDivergentBranch;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.analysis.AnalysisResultSharedAccess;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class CudaViewer
extends ViperViewerBase {
    private long maxInstExecuted = -1L;
    private long avgInstExecuted = -1L;
    private int maxExecCountLine = -1;
    private long maxNumSamples = -1L;
    private long maxNumLatencySamples = -1L;
    private long avgNumSamples = -1L;
    private long avgNumLatencySamples = -1L;
    private long maxL2Transactions = -1L;
    private long avgL2Transactions = -1L;
    private long maxSharedTransactions = -1L;
    private long avgSharedTransactions = -1L;
    private long maxDivergentBranch = -1L;
    private long avgDivergentBranch = -1L;
    private long maxNumStallNoneSamples = -1L;
    private int maxSampleCountLine = -1;
    private int maxLatencySampleCountLine = -1;
    private Map<Integer, Long> instExecutedMap;
    private Map<Integer, Long> threadInstExecutedMap;
    private Map<Integer, Long> notPredOffThreadsMap;
    private Map<Integer, Long> l2TransactionsMap;
    private Map<Integer, Long> idealL2TransactionsMap;
    private Map<Integer, Long> l2InstExecutedMap;
    private Map<Integer, Long> sharedTransactionsMap;
    private Map<Integer, Long> idealSharedTransactionsMap;
    private Map<Integer, Long> sharedInstExecutedMap;
    private Map<Integer, Long> divergentBranchMap;
    private Map<Integer, Long> divergentInstExecutedMap;
    private Map<Integer, Map<CuptiActivityPCSamplingStallReason, Long>> samplingReasonMap;
    private Map<Integer, Map<CuptiActivityPCSamplingStallReason, Long>> latencySamplingReasonMap;
    private Map<Integer, Long> samplingMap;
    private Map<Integer, Long> latencySamplingMap;
    Map<Integer, String> markerMap;
    private String cudaFileName;
    private int lastHighlightedLine = -1;

    public CudaViewer(ViewerControl parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    @Override
    public void highlightLine(int line) {
        StyledText textWidget = this.getTextWidget();
        if (this.lastHighlightedLine != -1) {
            textWidget.setLineBackground(this.lastHighlightedLine, 1, textWidget.getBackground());
        }
        if (line != -1) {
            textWidget.setLineBackground(line, 1, Display.getDefault().getSystemColor(32));
        }
        this.lastHighlightedLine = line;
    }

    private void initInstructionExecuted() {
        SourceSassModel sourceSassModel = this.getModel();
        AnalysisResultInstructionExecution analysisResult = (AnalysisResultInstructionExecution)sourceSassModel.getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind.INSTRUCTION_EXECUTION_KIND);
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorInstExecMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivityInstructionExecution)) continue;
                CuptiActivityInstructionExecution activity = (CuptiActivityInstructionExecution)sResult;
                int locatorId = activity.getSourceLocatorId();
                long instExec = activity.executed;
                if (locatorInstExecMap.containsKey(locatorId)) {
                    instExec += ((Long)locatorInstExecMap.get(locatorId)).longValue();
                }
                locatorInstExecMap.put(locatorId, instExec);
            }
            int avgInstCnt = 0;
            long totalInstExec = 0L;
            for (Long value : locatorInstExecMap.values()) {
                if (value > this.maxInstExecuted) {
                    this.maxInstExecuted = value;
                }
                if (value <= 0L) continue;
                totalInstExec += value.longValue();
                ++avgInstCnt;
            }
            this.avgInstExecuted = avgInstCnt == 0 ? 0L : totalInstExec / (long)avgInstCnt;
        }
    }

    private void initPCSampling() {
        SourceSassModel sourceSassModel = this.getModel();
        AnalysisResultPCSampling analysisResult = (AnalysisResultPCSampling)sourceSassModel.getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind.PC_SAMPLING_KIND);
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorPCSamplingMap = new HashMap<Integer, Long>();
            HashMap<Integer, Long> locatorPCSamplingLatencyMap = new HashMap<Integer, Long>();
            HashMap<Integer, Long> locatorPCSamplingNoStallMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivityPCSampling)) continue;
                CuptiActivityPCSampling activity = (CuptiActivityPCSampling)sResult;
                int locatorId = activity.getSourceLocatorId();
                long samples = activity.samples;
                long latencySamples = activity.latencySamples;
                if (locatorPCSamplingMap.containsKey(locatorId)) {
                    samples += ((Long)locatorPCSamplingMap.get(locatorId)).longValue();
                }
                locatorPCSamplingMap.put(locatorId, samples);
                if (locatorPCSamplingLatencyMap.containsKey(locatorId)) {
                    latencySamples += ((Long)locatorPCSamplingLatencyMap.get(locatorId)).longValue();
                }
                locatorPCSamplingLatencyMap.put(locatorId, latencySamples);
                if (activity.stallReason != CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE.getCode()) continue;
                samples = activity.samples;
                if (locatorPCSamplingNoStallMap.containsKey(locatorId)) {
                    samples += ((Long)locatorPCSamplingNoStallMap.get(locatorId)).longValue();
                }
                locatorPCSamplingNoStallMap.put(locatorId, samples);
            }
            int avgSamples = 0;
            long totalSamples = 0L;
            int avgLatencySamples = 0;
            long totalLatencySamples = 0L;
            for (Long value : locatorPCSamplingMap.values()) {
                if (value > this.maxNumSamples) {
                    this.maxNumSamples = value;
                }
                if (value <= 0L) continue;
                totalSamples += value.longValue();
                ++avgSamples;
            }
            for (Long value : locatorPCSamplingLatencyMap.values()) {
                if (value > this.maxNumLatencySamples) {
                    this.maxNumLatencySamples = value;
                }
                if (value <= 0L) continue;
                totalLatencySamples += value.longValue();
                ++avgLatencySamples;
            }
            for (Long value : locatorPCSamplingNoStallMap.values()) {
                if (value <= this.maxNumStallNoneSamples) continue;
                this.maxNumStallNoneSamples = value;
            }
            this.avgNumSamples = avgSamples == 0 ? 0L : totalSamples / (long)avgSamples;
            this.avgNumLatencySamples = avgLatencySamples == 0 ? 0L : totalLatencySamples / (long)avgLatencySamples;
        }
    }

    private void initDivergentBranch() {
        SourceSassModel sourceSassModel = this.getModel();
        AnalysisResultDivergentBranch analysisResult = (AnalysisResultDivergentBranch)sourceSassModel.getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind.DIVERGENT_EXECUTION_KIND);
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorDivergentBranchMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivityBranch)) continue;
                CuptiActivityBranch activity = (CuptiActivityBranch)sResult;
                int locatorId = activity.getSourceLocatorId();
                long divergentBranch = activity.diverged;
                if (locatorDivergentBranchMap.containsKey(locatorId)) {
                    divergentBranch += ((Long)locatorDivergentBranchMap.get(locatorId)).longValue();
                }
                locatorDivergentBranchMap.put(locatorId, divergentBranch);
            }
            long avgInstCount = 0L;
            long totalDivergentBranch = 0L;
            for (Long value : locatorDivergentBranchMap.values()) {
                if (value > this.maxDivergentBranch) {
                    this.maxDivergentBranch = value;
                }
                if (value <= 0L) continue;
                ++avgInstCount;
                totalDivergentBranch += value.longValue();
            }
            this.avgDivergentBranch = avgInstCount == 0L ? 0L : totalDivergentBranch / avgInstCount;
        }
    }

    private void initGlobalAccess() {
        SourceSassModel sourceSassModel = this.getModel();
        AnalysisResultUncoalescedGlobalMemory analysisResult = (AnalysisResultUncoalescedGlobalMemory)sourceSassModel.getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind.GLOBAL_ACCESS_KIND);
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorL2TransactionsMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivityGlobalAccess)) continue;
                CuptiActivityGlobalAccess activity = (CuptiActivityGlobalAccess)sResult;
                int locatorId = activity.getSourceLocatorId();
                long l2Transactions = activity.l2_transactions;
                if (locatorL2TransactionsMap.containsKey(locatorId)) {
                    l2Transactions += ((Long)locatorL2TransactionsMap.get(locatorId)).longValue();
                }
                locatorL2TransactionsMap.put(locatorId, l2Transactions);
            }
            long avgInstCount = 0L;
            long totalL2Transactions = 0L;
            for (Long value : locatorL2TransactionsMap.values()) {
                if (value > this.maxL2Transactions) {
                    this.maxL2Transactions = value;
                }
                if (value <= 0L) continue;
                ++avgInstCount;
                totalL2Transactions += value.longValue();
            }
            this.avgL2Transactions = avgInstCount == 0L ? 0L : totalL2Transactions / avgInstCount;
        }
    }

    private void initSharedAccess() {
        SourceSassModel sourceSassModel = this.getModel();
        AnalysisResultSharedAccess analysisResult = (AnalysisResultSharedAccess)sourceSassModel.getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind.SHARED_ACCESS_KIND);
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorSharedTransactionsMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivitySharedAccess)) continue;
                CuptiActivitySharedAccess activity = (CuptiActivitySharedAccess)sResult;
                int locatorId = activity.getSourceLocatorId();
                long sharedTransactions = activity.sharedTransactions;
                if (locatorSharedTransactionsMap.containsKey(locatorId)) {
                    sharedTransactions += ((Long)locatorSharedTransactionsMap.get(locatorId)).longValue();
                }
                locatorSharedTransactionsMap.put(locatorId, sharedTransactions);
            }
            long avgInstCount = 0L;
            long totalSharedTransactions = 0L;
            for (Long value : locatorSharedTransactionsMap.values()) {
                if (value > this.maxSharedTransactions) {
                    this.maxSharedTransactions = value;
                }
                if (value <= 0L) continue;
                ++avgInstCount;
                totalSharedTransactions += value.longValue();
            }
            this.avgSharedTransactions = avgInstCount == 0L ? 0L : totalSharedTransactions / avgInstCount;
        }
    }

    @Override
    public long getMaxInstructionExecuted() {
        if (this.maxInstExecuted == -1L) {
            this.initInstructionExecuted();
        }
        return this.maxInstExecuted;
    }

    @Override
    public long getAverageNonZeroInstructionExecuted() {
        if (this.avgInstExecuted == -1L) {
            this.initInstructionExecuted();
        }
        return this.avgInstExecuted;
    }

    @Override
    public long getInstructionExecuted(int line) {
        if (this.instExecutedMap == null) {
            this.calculateInstructionExecutedAggregates();
        }
        if (this.instExecutedMap != null && this.instExecutedMap.containsKey(line)) {
            return this.instExecutedMap.get(line);
        }
        return -1L;
    }

    @Override
    public long getThreadInstructionExecuted(int line) {
        if (this.threadInstExecutedMap == null) {
            this.calculateInstructionExecutedAggregates();
        }
        if (this.threadInstExecutedMap != null && this.threadInstExecutedMap.containsKey(line)) {
            return this.threadInstExecutedMap.get(line);
        }
        return -1L;
    }

    @Override
    public long getNoPredicateOff(int line) {
        if (this.notPredOffThreadsMap == null) {
            this.calculateInstructionExecutedAggregates();
        }
        if (this.notPredOffThreadsMap != null && this.notPredOffThreadsMap.containsKey(line)) {
            return this.notPredOffThreadsMap.get(line);
        }
        return -1L;
    }

    private void calculateInstructionExecutedAggregates() {
        SourceSassEditor editor = this.viewerControl.getEditor();
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            List<Integer> sassLines = editor.getSassLines(line);
            long aggredateInstExec = 0L;
            long aggredateThreadsExec = 0L;
            long aggredateNotPredOff = 0L;
            if (sassLines != null && sassLines.size() > 0) {
                for (Integer sassLine : sassLines) {
                    long noPredOff;
                    long threadsExec;
                    long instExec = editor.getInstructionExecutedSass(sassLine);
                    if (instExec > 0L) {
                        aggredateInstExec += instExec;
                    }
                    if ((threadsExec = editor.getThreadInstExecutedSass(sassLine)) > 0L) {
                        aggredateThreadsExec += threadsExec;
                    }
                    if ((noPredOff = editor.getNoPredicateOffSass(sassLine)) <= 0L) continue;
                    aggredateNotPredOff += noPredOff;
                }
                if (aggredateInstExec > 0L) {
                    if (this.instExecutedMap == null) {
                        this.instExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.instExecutedMap.put(line, aggredateInstExec);
                }
                if (aggredateThreadsExec > 0L) {
                    if (this.threadInstExecutedMap == null) {
                        this.threadInstExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.threadInstExecutedMap.put(line, aggredateThreadsExec);
                }
                if (aggredateNotPredOff > 0L) {
                    if (this.notPredOffThreadsMap == null) {
                        this.notPredOffThreadsMap = new HashMap<Integer, Long>();
                    }
                    this.notPredOffThreadsMap.put(line, aggredateNotPredOff);
                }
            }
            ++line;
        }
    }

    private void calculateGlobalAccessAggregates() {
        SourceSassEditor editor = this.viewerControl.getEditor();
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            List<Integer> sassLines = editor.getSassLines(line);
            long aggregateIdealL2Transactions = 0L;
            long aggredateL2Transactions = 0L;
            long aggregateL2InstExecuted = 0L;
            if (sassLines != null && sassLines.size() > 0) {
                for (Integer sassLine : sassLines) {
                    long l2InstExecuted;
                    long l2Transactions;
                    long idealL2Transactions = editor.getIdealL2TransactionsSass(sassLine);
                    if (idealL2Transactions > 0L) {
                        aggregateIdealL2Transactions += idealL2Transactions;
                    }
                    if ((l2Transactions = editor.getL2TransactionsSass(sassLine)) > 0L) {
                        aggredateL2Transactions += l2Transactions;
                    }
                    if ((l2InstExecuted = editor.getL2InstructionExecutedSass(sassLine)) <= 0L) continue;
                    aggregateL2InstExecuted += l2InstExecuted;
                }
                if (aggregateIdealL2Transactions > 0L) {
                    if (this.idealL2TransactionsMap == null) {
                        this.idealL2TransactionsMap = new HashMap<Integer, Long>();
                    }
                    this.idealL2TransactionsMap.put(line, aggregateIdealL2Transactions);
                }
                if (aggredateL2Transactions > 0L) {
                    if (this.l2TransactionsMap == null) {
                        this.l2TransactionsMap = new HashMap<Integer, Long>();
                    }
                    this.l2TransactionsMap.put(line, aggredateL2Transactions);
                }
                if (aggregateL2InstExecuted > 0L) {
                    if (this.l2InstExecutedMap == null) {
                        this.l2InstExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.l2InstExecutedMap.put(line, aggregateL2InstExecuted);
                }
            }
            ++line;
        }
    }

    private void calculateSharedAccessAggregates() {
        SourceSassEditor editor = this.viewerControl.getEditor();
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            List<Integer> sassLines = editor.getSassLines(line);
            long aggregateIdealSharedTransactions = 0L;
            long aggregateSharedTransactions = 0L;
            long aggregateSharedInstExecuted = 0L;
            if (sassLines != null && sassLines.size() > 0) {
                for (Integer sassLine : sassLines) {
                    long sharedInstExecuted;
                    long sharedTransactions;
                    long idealSharedTransactions = editor.getIdealSharedTransactionsSass(sassLine);
                    if (idealSharedTransactions > 0L) {
                        aggregateIdealSharedTransactions += idealSharedTransactions;
                    }
                    if ((sharedTransactions = editor.getSharedTransactionsSass(sassLine)) > 0L) {
                        aggregateSharedTransactions += sharedTransactions;
                    }
                    if ((sharedInstExecuted = editor.getSharedInstructionExecutedSass(sassLine)) <= 0L) continue;
                    aggregateSharedInstExecuted += sharedInstExecuted;
                }
                if (aggregateIdealSharedTransactions > 0L) {
                    if (this.idealSharedTransactionsMap == null) {
                        this.idealSharedTransactionsMap = new HashMap<Integer, Long>();
                    }
                    this.idealSharedTransactionsMap.put(line, aggregateIdealSharedTransactions);
                }
                if (aggregateSharedTransactions > 0L) {
                    if (this.sharedTransactionsMap == null) {
                        this.sharedTransactionsMap = new HashMap<Integer, Long>();
                    }
                    this.sharedTransactionsMap.put(line, aggregateSharedTransactions);
                }
                if (aggregateSharedInstExecuted > 0L) {
                    if (this.sharedInstExecutedMap == null) {
                        this.sharedInstExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.sharedInstExecutedMap.put(line, aggregateSharedInstExecuted);
                }
            }
            ++line;
        }
    }

    private void calculateDivergentBranchAggregates() {
        SourceSassEditor editor = this.viewerControl.getEditor();
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            List<Integer> sassLines = editor.getSassLines(line);
            long aggregateDivergentBranch = 0L;
            long aggregateDivergedInstExecuted = 0L;
            if (sassLines != null && sassLines.size() > 0) {
                for (Integer sassLine : sassLines) {
                    long divergentInstExecuted;
                    long divergentBranch = editor.getDivergentBranchSass(sassLine);
                    if (divergentBranch > 0L) {
                        aggregateDivergentBranch += divergentBranch;
                    }
                    if ((divergentInstExecuted = editor.getDivergentInstExecutedSass(sassLine)) <= 0L) continue;
                    aggregateDivergedInstExecuted += divergentInstExecuted;
                }
                if (aggregateDivergentBranch > 0L) {
                    if (this.divergentBranchMap == null) {
                        this.divergentBranchMap = new HashMap<Integer, Long>();
                    }
                    this.divergentBranchMap.put(line, aggregateDivergentBranch);
                }
                if (aggregateDivergedInstExecuted > 0L) {
                    if (this.divergentInstExecutedMap == null) {
                        this.divergentInstExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.divergentInstExecutedMap.put(line, aggregateDivergedInstExecuted);
                }
            }
            ++line;
        }
    }

    private void calculatePCSamplingAggregates() {
        SourceSassEditor editor = this.viewerControl.getEditor();
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            Long totalNumSamples = 0L;
            Long totalNumLatencySamples = 0L;
            List<Integer> sassLines = editor.getSassLines(line);
            if (sassLines != null && sassLines.size() > 0) {
                HashMap<CuptiActivityPCSamplingStallReason, Long> samplingPerReasonMap = new HashMap<CuptiActivityPCSamplingStallReason, Long>();
                HashMap<CuptiActivityPCSamplingStallReason, Long> latencySamplingPerReasonMap = new HashMap<CuptiActivityPCSamplingStallReason, Long>();
                for (Integer sassLine : sassLines) {
                    CuptiActivityPCSamplingStallReason[] cuptiActivityPCSamplingStallReasonArray = CuptiActivityPCSamplingStallReason.values();
                    int n = cuptiActivityPCSamplingStallReasonArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CuptiActivityPCSamplingStallReason res = cuptiActivityPCSamplingStallReasonArray[n2];
                        Long numSamples = editor.getNumSamples(sassLine, res);
                        Long numLatencySamples = editor.getNumLatencySamples(sassLine, res);
                        if (numSamples > 0L) {
                            totalNumSamples = totalNumSamples + numSamples;
                            if (samplingPerReasonMap.get((Object)res) != null) {
                                numSamples = numSamples + (Long)samplingPerReasonMap.get((Object)res);
                            }
                            samplingPerReasonMap.put(res, numSamples);
                        }
                        if (numLatencySamples > 0L) {
                            totalNumLatencySamples = totalNumLatencySamples + numLatencySamples;
                            if (latencySamplingPerReasonMap.get((Object)res) != null) {
                                numLatencySamples = numLatencySamples + (Long)latencySamplingPerReasonMap.get((Object)res);
                            }
                            latencySamplingPerReasonMap.put(res, numLatencySamples);
                        }
                        ++n2;
                    }
                }
                if (this.samplingReasonMap == null) {
                    this.samplingReasonMap = new HashMap<Integer, Map<CuptiActivityPCSamplingStallReason, Long>>();
                }
                if (this.latencySamplingReasonMap == null) {
                    this.latencySamplingReasonMap = new HashMap<Integer, Map<CuptiActivityPCSamplingStallReason, Long>>();
                }
                if (!samplingPerReasonMap.isEmpty()) {
                    this.samplingReasonMap.put(line, samplingPerReasonMap);
                }
                if (!latencySamplingPerReasonMap.isEmpty()) {
                    this.latencySamplingReasonMap.put(line, latencySamplingPerReasonMap);
                }
                if (totalNumSamples > 0L) {
                    if (this.samplingMap == null) {
                        this.samplingMap = new HashMap<Integer, Long>();
                    }
                    this.samplingMap.put(line, totalNumSamples);
                }
                if (totalNumLatencySamples > 0L) {
                    if (this.latencySamplingMap == null) {
                        this.latencySamplingMap = new HashMap<Integer, Long>();
                    }
                    this.latencySamplingMap.put(line, totalNumLatencySamples);
                }
            }
            ++line;
        }
    }

    public void clear() {
        this.lastHighlightedLine = -1;
        this.instExecutedMap = null;
        this.threadInstExecutedMap = null;
        this.notPredOffThreadsMap = null;
        this.l2TransactionsMap = null;
        this.idealL2TransactionsMap = null;
        this.sharedTransactionsMap = null;
        this.idealSharedTransactionsMap = null;
        this.divergentBranchMap = null;
        this.maxExecCountLine = -1;
        this.maxSampleCountLine = -1;
        this.maxLatencySampleCountLine = -1;
        this.samplingMap = null;
        this.latencySamplingMap = null;
        this.samplingReasonMap = null;
        this.latencySamplingReasonMap = null;
        this.markerMap = null;
    }

    public void setFileName(String cudaFileName) {
        this.cudaFileName = cudaFileName;
    }

    public String getFileName() {
        return this.cudaFileName;
    }

    private int getMaxInstExecutedLine() {
        if (this.maxExecCountLine == -1) {
            if (this.instExecutedMap == null) {
                this.calculateInstructionExecutedAggregates();
            }
            long max = 0L;
            if (this.instExecutedMap != null) {
                for (Map.Entry<Integer, Long> entry : this.instExecutedMap.entrySet()) {
                    if (entry.getValue() <= max) continue;
                    max = entry.getValue();
                    this.maxExecCountLine = entry.getKey();
                }
            }
        }
        return this.maxExecCountLine;
    }

    private int getMaxPCSamplesLine() {
        if (this.maxSampleCountLine == -1) {
            if (this.samplingMap == null) {
                this.calculatePCSamplingAggregates();
            }
            long max = 0L;
            if (this.samplingMap != null) {
                for (Map.Entry<Integer, Long> entry : this.samplingMap.entrySet()) {
                    if (entry.getValue() <= max) continue;
                    max = entry.getValue();
                    this.maxSampleCountLine = entry.getKey();
                }
            }
        }
        return this.maxSampleCountLine;
    }

    private int getMaxPCLatencySamplesLine() {
        if (this.maxLatencySampleCountLine == -1) {
            if (this.latencySamplingMap == null) {
                this.calculatePCSamplingAggregates();
            }
            long max = 0L;
            if (this.latencySamplingMap != null) {
                for (Map.Entry<Integer, Long> entry : this.latencySamplingMap.entrySet()) {
                    if (entry.getValue() <= max) continue;
                    max = entry.getValue();
                    this.maxLatencySampleCountLine = entry.getKey();
                }
            }
        }
        return this.maxLatencySampleCountLine;
    }

    public void selectMaxExecCountLine() {
        int maxExecCountLine = this.getMaxInstExecutedLine();
        this.selectLine(maxExecCountLine);
    }

    public void selectMaxPCSamplesLine() {
        int maxPCSamplesLine = this.getMaxPCSamplesLine();
        this.selectLine(maxPCSamplesLine);
    }

    public void selectMaxPCLatencySamplesLine() {
        int maxPCLatencySamplesLine = this.getMaxPCLatencySamplesLine();
        this.selectLine(maxPCLatencySamplesLine);
    }

    public void selectDefaultLine() {
        this.selectLine(this.getModel().getLineToSelect() - 1);
    }

    private void selectLine(int lineNumber) {
        try {
            int lineStart = this.getDocument().getLineOffset(lineNumber);
            int lineEnd = this.getDocument().getLineLength(lineNumber) - 1;
            this.revealRange(lineStart, lineEnd);
            this.setSelectedRange(lineStart, lineEnd);
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
    }

    @Override
    public void highlightCorrespondingLines(int line) {
        this.viewerControl.getEditor().highlightSassLines(line);
    }

    @Override
    public long getNumSamples(int lineNum) {
        if (this.samplingMap == null) {
            this.calculatePCSamplingAggregates();
        }
        Long numSamples = null;
        if (this.samplingMap != null) {
            numSamples = this.samplingMap.get(lineNum);
        }
        return numSamples != null ? numSamples : -1L;
    }

    @Override
    public long getNumSamples(int lineNum, CuptiActivityPCSamplingStallReason stallReason) {
        Map<CuptiActivityPCSamplingStallReason, Long> samplingPerReasonMap;
        if (this.samplingReasonMap == null) {
            this.calculatePCSamplingAggregates();
        }
        if ((samplingPerReasonMap = this.samplingReasonMap.get(lineNum)) != null) {
            Long numSamples = samplingPerReasonMap.get((Object)stallReason);
            return numSamples != null ? numSamples : 0L;
        }
        if (this.samplingMap.get(lineNum) == null) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public long getMaxNumSamples() {
        if (this.maxNumSamples == -1L) {
            this.initPCSampling();
        }
        return this.maxNumSamples;
    }

    @Override
    public long getAverageNonZeroSamples() {
        if (this.avgNumSamples == -1L) {
            this.initPCSampling();
        }
        return this.avgNumSamples;
    }

    @Override
    public long getMaxNumStallNoneSamples() {
        if (this.maxNumStallNoneSamples == -1L) {
            this.initPCSampling();
        }
        return this.maxNumStallNoneSamples;
    }

    @Override
    public long getTheoreticalL2Transactions(int lineNum) {
        if (this.idealL2TransactionsMap == null) {
            this.calculateGlobalAccessAggregates();
        }
        if (this.idealL2TransactionsMap != null && this.idealL2TransactionsMap.containsKey(lineNum)) {
            return this.idealL2TransactionsMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getL2Transactions(int lineNum) {
        if (this.l2TransactionsMap == null) {
            this.calculateGlobalAccessAggregates();
        }
        if (this.l2TransactionsMap != null && this.l2TransactionsMap.containsKey(lineNum)) {
            return this.l2TransactionsMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getTheoreticalSharedTransactions(int lineNum) {
        if (this.idealSharedTransactionsMap == null) {
            this.calculateSharedAccessAggregates();
        }
        if (this.idealSharedTransactionsMap != null && this.idealSharedTransactionsMap.containsKey(lineNum)) {
            return this.idealSharedTransactionsMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getSharedTransactions(int lineNum) {
        if (this.sharedTransactionsMap == null) {
            this.calculateSharedAccessAggregates();
        }
        if (this.sharedTransactionsMap != null && this.sharedTransactionsMap.containsKey(lineNum)) {
            return this.sharedTransactionsMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getNumDivergedBranch(int lineNum) {
        if (this.divergentBranchMap == null) {
            this.calculateDivergentBranchAggregates();
        }
        if (this.divergentBranchMap != null && this.divergentBranchMap.containsKey(lineNum)) {
            return this.divergentBranchMap.get(lineNum);
        }
        return 0L;
    }

    @Override
    public long getMaxL2Transactions() {
        if (this.maxL2Transactions == -1L) {
            this.initGlobalAccess();
        }
        return this.maxL2Transactions;
    }

    @Override
    public long getMaxSharedTransactions() {
        if (this.maxSharedTransactions == -1L) {
            this.initSharedAccess();
        }
        return this.maxSharedTransactions;
    }

    @Override
    public long getL2InstExecuted(int lineNum) {
        if (this.l2InstExecutedMap == null) {
            this.calculateGlobalAccessAggregates();
        }
        if (this.l2InstExecutedMap != null && this.l2InstExecutedMap.containsKey(lineNum)) {
            return this.l2InstExecutedMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getSharedInstExecuted(int lineNum) {
        if (this.sharedInstExecutedMap == null) {
            this.calculateSharedAccessAggregates();
        }
        if (this.sharedInstExecutedMap != null && this.sharedInstExecutedMap.containsKey(lineNum)) {
            return this.sharedInstExecutedMap.get(lineNum);
        }
        return -1L;
    }

    @Override
    public long getDivergeInstExecuted(int lineNum) {
        if (this.divergentInstExecutedMap == null) {
            this.calculateDivergentBranchAggregates();
        }
        if (this.divergentInstExecutedMap != null && this.divergentInstExecutedMap.containsKey(lineNum)) {
            return this.divergentInstExecutedMap.get(lineNum);
        }
        return 0L;
    }

    @Override
    public long getMaxDivergentBranch() {
        if (this.maxDivergentBranch == -1L) {
            this.initDivergentBranch();
        }
        return this.maxDivergentBranch;
    }

    @Override
    public long getAverageDivergentBranch() {
        if (this.avgDivergentBranch == -1L) {
            this.initDivergentBranch();
        }
        return this.avgDivergentBranch;
    }

    @Override
    public long getAverageL2Transactions() {
        if (this.avgL2Transactions == -1L) {
            this.initGlobalAccess();
        }
        return this.avgL2Transactions;
    }

    @Override
    public long getAverageSharedTransactions() {
        if (this.avgSharedTransactions == -1L) {
            this.initSharedAccess();
        }
        return this.avgSharedTransactions;
    }

    @Override
    public long getNumLatencySamples(int lineNum) {
        if (this.latencySamplingMap == null) {
            this.calculatePCSamplingAggregates();
        }
        Long numLatencySamples = null;
        if (this.latencySamplingMap != null) {
            numLatencySamples = this.latencySamplingMap.get(lineNum);
        }
        return numLatencySamples != null ? numLatencySamples : -1L;
    }

    @Override
    public long getNumLatencySamples(int lineNum, CuptiActivityPCSamplingStallReason stallReason) {
        Map<CuptiActivityPCSamplingStallReason, Long> latencySamplingPerReasonMap;
        if (this.latencySamplingReasonMap == null) {
            this.calculatePCSamplingAggregates();
        }
        if ((latencySamplingPerReasonMap = this.latencySamplingReasonMap.get(lineNum)) != null) {
            Long numLatencySamples = latencySamplingPerReasonMap.get((Object)stallReason);
            return numLatencySamples != null ? numLatencySamples : 0L;
        }
        if (this.latencySamplingMap.get(lineNum) == null) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public long getMaxNumLatencySamples() {
        if (this.maxNumLatencySamples == -1L) {
            this.initPCSampling();
        }
        return this.maxNumLatencySamples;
    }

    @Override
    public long getAverageNonZeroLatencySamples() {
        if (this.avgNumLatencySamples == -1L) {
            this.initPCSampling();
        }
        return this.avgNumLatencySamples;
    }
}

