/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

public class UtilizationRange {
    private long start;
    private long end;
    private double totalUtilization = 0.0;

    public UtilizationRange(long start, long end) throws IllegalArgumentException {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException("range start/end time expected greater than or eqaul to zero, found start = " + start + ", end = " + end);
        }
        this.start = start;
        this.end = end;
    }

    public UtilizationRange(long start, long end, double utilization) throws IllegalArgumentException {
        if (utilization > 1.0) {
            utilization = 1.0;
        }
        if (start < 0L || end < 0L || utilization < 0.0) {
            throw new IllegalArgumentException("range start/end time and utilization expected greater than or eqaul to zero, found start = " + start + ", end = " + end + ", utilization = " + utilization);
        }
        this.start = start;
        this.end = end;
        this.totalUtilization = utilization;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void addUtilization(double utilization) {
        if (this.totalUtilization < 1.0) {
            if (utilization > 1.0) {
                utilization = 1.0;
            }
            if (utilization > 0.0) {
                this.totalUtilization += utilization;
            }
        }
        if (this.totalUtilization > 1.0) {
            this.totalUtilization = 1.0;
        }
    }

    public double getUtilization() {
        return this.totalUtilization;
    }
}

