/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import java.util.HashMap;
import java.util.Map;

public enum CuptiMetricValueKind {
    CUPTI_METRIC_VALUE_KIND_DOUBLE(0),
    CUPTI_METRIC_VALUE_KIND_UINT64(1),
    CUPTI_METRIC_VALUE_KIND_PERCENT(2),
    CUPTI_METRIC_VALUE_KIND_THROUGHPUT(3),
    CUPTI_METRIC_VALUE_KIND_INT64(4),
    CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL(5);

    private int code;
    private static Map<Integer, CuptiMetricValueKind> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiMetricValueKind>();
        CuptiMetricValueKind[] cuptiMetricValueKindArray = CuptiMetricValueKind.values();
        int n = cuptiMetricValueKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiMetricValueKind res = cuptiMetricValueKindArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiMetricValueKind(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isLongValue() {
        return CUPTI_METRIC_VALUE_KIND_UINT64.equals((Object)this) || CUPTI_METRIC_VALUE_KIND_INT64.equals((Object)this) || CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)this) || CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL.equals((Object)this);
    }

    public boolean isValidValue(Number num) {
        switch (this) {
            case CUPTI_METRIC_VALUE_KIND_DOUBLE: {
                return num instanceof Double;
            }
            case CUPTI_METRIC_VALUE_KIND_INT64: {
                return num instanceof Long;
            }
            case CUPTI_METRIC_VALUE_KIND_UINT64: 
            case CUPTI_METRIC_VALUE_KIND_THROUGHPUT: {
                return num instanceof Long && num.longValue() >= 0L;
            }
            case CUPTI_METRIC_VALUE_KIND_PERCENT: {
                return num instanceof Double && num.doubleValue() >= 0.0;
            }
            case CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL: {
                return num instanceof Long && num.longValue() >= (long)CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_IDLE.getCode() && num.longValue() <= (long)CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_MAX.getCode();
            }
        }
        return false;
    }

    public static CuptiMetricValueKind valueOf(String string) {
        return Enum.valueOf(CuptiMetricValueKind.class, string);
    }
}

