/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.actions.ForceAllAnalysisResultsAction;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelFlops;
import com.nvidia.viper.analysis.AnalysisResultKernelInstructionClass;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.analysis.AnalysisResultKernelStall;
import com.nvidia.viper.analysis.AnalysisResultKernelUnitBusy;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.CriticalPathAnalysis;
import com.nvidia.viper.analysis.GPUAnalysis;
import com.nvidia.viper.analysis.IAnalysis;
import com.nvidia.viper.analysis.KernelInstanceBoundsAnalysis;
import com.nvidia.viper.analysis.KernelInstanceDivergentBranchAnalysis;
import com.nvidia.viper.analysis.KernelInstanceInstructionExecutionAnalysis;
import com.nvidia.viper.analysis.KernelInstanceLatencyAnalysis;
import com.nvidia.viper.analysis.KernelInstanceMemoryAnalysis;
import com.nvidia.viper.analysis.KernelInstanceMemoryStatAnalysis;
import com.nvidia.viper.analysis.KernelInstancePCSamplingAnalysis;
import com.nvidia.viper.analysis.KernelInstanceSMAnalysis;
import com.nvidia.viper.analysis.KernelInstanceSharedAccessAnalysis;
import com.nvidia.viper.analysis.KernelInstanceUncoalescedGlobalMemoryAnalysis;
import com.nvidia.viper.analysis.KernelInstructionAnalysis;
import com.nvidia.viper.analysis.KernelMemoryAnalysis;
import com.nvidia.viper.analysis.KernelPriorityAnalysis;
import com.nvidia.viper.analysis.MemcpyAnalysis;
import com.nvidia.viper.analysis.MultiprocessorAnalysis;
import com.nvidia.viper.analysis.NVLinkAnalysis;
import com.nvidia.viper.analysis.UvmAnalysis;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricAggregate;
import com.nvidia.viper.model.MetricPerInstance;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public enum AnalysisStage {
    NONE("<none>"),
    TIMELINE("Data Movement And Concurrency"),
    KERNELS("Compute Utilization"),
    KERNELS_PERFORMANCE("Kernel Performance"),
    NVLINK_TOPOLOGY("NVLink"),
    UNIFIED_MEMORY("Unified Memory"),
    KERNEL_INSTANCE_BOUNDS("Kernel Performance Limiter"),
    KERNEL_INSTANCE_MEMORY("Kernel Memory"),
    KERNEL_INSTANCE_SM("Kernel Compute"),
    KERNEL_INSTANCE_LATENCY("Kernel Latency"),
    KERNEL_INSTANCE_UNCOALESCED_GLOBAL("Global Memory Access Pattern"),
    KERNEL_INSTANCE_SHARED_ACCESS("Shared Memory Access Pattern"),
    KERNEL_INSTANCE_DIVERGENT_BRANCH("Divergent Execution"),
    KERNEL_INSTANCE_INSTRUCTION_EXECUTION("Kernel Profile - Instruction Execution"),
    KERNEL_INSTANCE_PC_SAMPLING("Kernel Profile - PC Sampling"),
    KERNEL_INSTANCE_MEMORY_STAT("Memory Statistics"),
    DEPENDENCY_ANALYSIS("Dependency Analysis");

    private String label;

    private AnalysisStage(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean updateExpert(IDevicesData deviceData, Session session, Expert expert) throws ViperException {
        boolean needCollection = false;
        switch (this) {
            case NONE: 
            case TIMELINE: {
                break;
            }
            case NVLINK_TOPOLOGY: {
                needCollection |= this.updateExpertForNVLinkAnalysis(deviceData, session, expert);
                break;
            }
            case DEPENDENCY_ANALYSIS: {
                break;
            }
            case UNIFIED_MEMORY: {
                break;
            }
            case KERNELS: {
                needCollection |= this.updateExpertForKernelsAnalysis(deviceData, session, expert);
                break;
            }
            case KERNELS_PERFORMANCE: {
                needCollection |= this.updateExpertForKernelPerformanceAnalysis(deviceData, session, expert);
                break;
            }
            case KERNEL_INSTANCE_BOUNDS: {
                needCollection |= this.updateExpertForKernelInstanceBoundsAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceFunctionUnitAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceMemoryUtilizationAnalysis(deviceData, session, expert);
                break;
            }
            case KERNEL_INSTANCE_MEMORY: {
                needCollection |= this.updateExpertForKernelInstanceMemoryAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceMemoryUtilizationAnalysis(deviceData, session, expert);
                break;
            }
            case KERNEL_INSTANCE_SM: {
                needCollection |= this.updateExpertForKernelInstanceSMAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceFunctionUnitAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceInstructionClassAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceFlopsAnalysis(deviceData, session, expert);
                break;
            }
            case KERNEL_INSTANCE_LATENCY: {
                needCollection |= this.updateExpertForKernelInstanceLatencyAnalysis(deviceData, session, expert);
                needCollection |= this.updateExpertForKernelInstanceStallAnalysis(deviceData, session, expert);
                break;
            }
            case KERNEL_INSTANCE_UNCOALESCED_GLOBAL: {
                needCollection |= this.updateExpertForKernelInstanceUncoalescedGlobalMemoryAnalysis(session, expert);
                break;
            }
            case KERNEL_INSTANCE_SHARED_ACCESS: {
                needCollection |= this.updateExpertForKernelInstanceSharedAccessAnalysis(session, expert);
                break;
            }
            case KERNEL_INSTANCE_DIVERGENT_BRANCH: {
                needCollection |= this.updateExpertForKernelInstanceDivergentBranchAnalysis(session, expert);
                break;
            }
            case KERNEL_INSTANCE_INSTRUCTION_EXECUTION: {
                needCollection |= this.updateExpertForKernelInstanceInstructionExecutionAnalysis(session, expert);
                break;
            }
            case KERNEL_INSTANCE_PC_SAMPLING: {
                needCollection |= this.updateExpertForKernelInstancePCSamplingAnalysis(session, expert);
                break;
            }
            case KERNEL_INSTANCE_MEMORY_STAT: {
                needCollection |= this.updateExpertForKernelInstanceMemoryChartAnalysis(deviceData, session, expert);
                break;
            }
            default: {
                throw new ViperException("Unknown analysis stage " + (Object)((Object)this));
            }
        }
        return needCollection;
    }

    private boolean updateExpertForKernelInstanceMemoryChartAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, Arrays.asList(KernelInstanceMemoryStatAnalysis.MEMORY_CHART_METRICS), null);
    }

    private boolean updateExpertForKernelInstanceAnalysis(IDevicesData deviceData, Session session, Expert expert, Collection<Event> events, Collection<String> aggregateMetricNames, Collection<String> instanceMetricNames) {
        boolean needsCollection = false;
        TimelineIntervalKernel interval = AnalysisStage.getAnalysisHostLaunchedKernel(session);
        if (interval != null) {
            Object metric;
            TimelineDevice deviceTimeline = (TimelineDevice)CoreUtil.safeCast((Object)interval.getPrimaryTimeline().getAncestor(TimelineKind.DEVICE), TimelineDevice.class);
            String deviceName = deviceTimeline.getNameWithId();
            if (events != null) {
                HashSet<Event> kiEvents = new HashSet<Event>(events);
                kiEvents.retainAll(deviceData.getEvents(deviceName));
                if (!kiEvents.isEmpty()) {
                    expert.enableAll(deviceName, interval, kiEvents);
                    needsCollection = true;
                }
            }
            if (aggregateMetricNames != null) {
                HashSet<Metric> kiaMetrics = new HashSet<Metric>();
                for (String metricName : aggregateMetricNames) {
                    metric = deviceData.getMetric(deviceName, metricName);
                    if (metric == null) continue;
                    kiaMetrics.add((Metric)metric);
                }
                kiaMetrics.retainAll(deviceData.getMetrics(deviceName));
                if (!kiaMetrics.isEmpty()) {
                    HashSet<MetricAggregate> aggs = new HashSet<MetricAggregate>();
                    for (Metric metric2 : kiaMetrics) {
                        aggs.add(new MetricAggregate(metric2));
                    }
                    expert.enableAll(deviceName, interval, aggs);
                    needsCollection = true;
                }
            }
            if (instanceMetricNames != null) {
                HashSet<Object> kiiMetrics = new HashSet<Object>();
                for (String metricName : instanceMetricNames) {
                    metric = deviceData.getMetric(deviceName, metricName);
                    if (metric == null || !((Metric)metric).getEvaluationMode().isPerInstanceMode()) continue;
                    kiiMetrics.add(metric);
                }
                kiiMetrics.retainAll(deviceData.getMetrics(deviceName));
                if (!kiiMetrics.isEmpty()) {
                    HashSet<MetricPerInstance> insts = new HashSet<MetricPerInstance>();
                    for (Metric metric3 : kiiMetrics) {
                        insts.add(new MetricPerInstance(metric3));
                    }
                    expert.enableAll(deviceName, interval, insts);
                    needsCollection = true;
                }
            }
        }
        return needsCollection;
    }

    private boolean updateExpertForWholeApplicationAnalysis(IDevicesData deviceData, Expert expert, Collection<Event> events, Collection<String> aggregateMetricNames, Collection<String> instanceMetricNames, boolean continuousMode) {
        String[] deviceTypes;
        boolean needsCollection = false;
        if (deviceData == null) {
            return needsCollection;
        }
        String[] stringArray = deviceTypes = deviceData.getDeviceTypes();
        int n = deviceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object metric;
            String deviceType = stringArray[n2];
            if (events != null) {
                HashSet<Event> kiEvents = new HashSet<Event>(events);
                kiEvents.retainAll(deviceData.getEvents(deviceType));
                if (!kiEvents.isEmpty()) {
                    expert.enableAll(deviceType, null, kiEvents);
                    needsCollection = true;
                }
            }
            if (aggregateMetricNames != null) {
                HashSet<Metric> kiaMetrics = new HashSet<Metric>();
                for (String metricName : aggregateMetricNames) {
                    metric = deviceData.getMetric(deviceType, metricName);
                    if (metric == null) continue;
                    kiaMetrics.add((Metric)metric);
                }
                kiaMetrics.retainAll(deviceData.getMetrics(deviceType));
                if (!kiaMetrics.isEmpty()) {
                    HashSet<MetricAggregate> aggs = new HashSet<MetricAggregate>();
                    for (Metric metric2 : kiaMetrics) {
                        aggs.add(new MetricAggregate(metric2));
                    }
                    expert.enableAll(deviceType, null, aggs);
                    needsCollection = true;
                }
            }
            if (instanceMetricNames != null) {
                HashSet<Metric> kiiMetrics = new HashSet<Metric>();
                for (String metricName : instanceMetricNames) {
                    metric = deviceData.getMetric(deviceType, metricName);
                    if (metric == null) continue;
                    kiiMetrics.add((Metric)metric);
                }
                kiiMetrics.retainAll(deviceData.getMetrics(deviceType));
                if (!kiiMetrics.isEmpty()) {
                    HashSet<MetricPerInstance> insts = new HashSet<MetricPerInstance>();
                    for (Metric metric3 : kiiMetrics) {
                        insts.add(new MetricPerInstance(metric3, continuousMode));
                    }
                    expert.enableAll(deviceType, null, insts);
                    needsCollection = true;
                }
            }
            ++n2;
        }
        return needsCollection;
    }

    private boolean updateExpertForWholeApplicationAnalysis(IDevicesData deviceData, Expert expert, Collection<Event> events, Collection<String> aggregateMetricNames, Collection<String> instanceMetricNames) {
        return this.updateExpertForWholeApplicationAnalysis(deviceData, expert, events, aggregateMetricNames, instanceMetricNames, false);
    }

    private boolean updateExpertForKernelsAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForWholeApplicationAnalysis(deviceData, expert, null, Arrays.asList("achieved_occupancy"), null);
    }

    private boolean updateExpertForKernelPerformanceAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForWholeApplicationAnalysis(deviceData, expert, null, Arrays.asList("gld_efficiency", "gst_efficiency", "shared_efficiency", "warp_execution_efficiency", "warp_nonpred_execution_efficiency"), null);
    }

    private boolean updateExpertForNVLinkAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        if (!session.isNVLinkTopologyPresent()) {
            return false;
        }
        return this.updateExpertForWholeApplicationAnalysis(deviceData, expert, null, null, Arrays.asList("nvlink_receive_throughput", "nvlink_transmit_throughput", "nvlink_total_data_transmitted", "nvlink_total_data_received"), true);
    }

    private boolean updateExpertForKernelInstanceBoundsAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, Arrays.asList("issue_slots", "issue_slot_utilization", "cf_issued", "ldst_issued"), null);
    }

    private boolean updateExpertForKernelInstanceLatencyAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, Arrays.asList("issue_slot_utilization", "achieved_occupancy"), Arrays.asList("sm_efficiency_instance", "sm_efficiency"));
    }

    private boolean updateExpertForKernelInstanceMemoryAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, Arrays.asList("local_memory_overhead", "dram_read_transactions", "dram_write_transactions", "sysmem_read_transactions", "sysmem_write_transactions", "l2_read_transactions", "l2_write_transactions", "l2_l1_read_transactions", "l2_l1_write_transactions", "l2_tex_read_transactions", "l2_tex_write_transactions", "l2_atomic_transactions", "nc_l2_read_transactions", "tex_cache_transactions", "shared_load_transactions", "shared_store_transactions", "local_load_transactions", "local_store_transactions", "gld_transactions", "gst_transactions", "atomic_transactions", "ecc_transactions", "dram_read_throughput", "dram_write_throughput", "sysmem_read_throughput", "sysmem_write_throughput", "l2_read_throughput", "l2_write_throughput", "l2_l1_read_throughput", "l2_l1_write_throughput", "l2_texture_read_throughput", "l2_tex_write_throughput", "l2_atomic_throughput", "nc_l2_read_throughput", "tex_cache_throughput", "shared_load_throughput", "shared_store_throughput", "local_load_throughput", "local_store_throughput", "gld_throughput", "gst_throughput", "atomic_throughput", "ecc_throughput", "sysmem_read_utilization", "sysmem_write_utilization"), null);
    }

    private boolean updateExpertForKernelInstanceMemoryUtilizationAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        ArrayList<String> metrics = new ArrayList<String>();
        AnalysisResultKernelMemory.MemoryUnit[] memoryUnitArray = AnalysisResultKernelMemory.MemoryUnit.values();
        int n = memoryUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelMemory.MemoryUnit mu = memoryUnitArray[n2];
            metrics.add(mu.getUtilizationMetricName());
            ++n2;
        }
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, metrics, null);
    }

    private boolean updateExpertForKernelInstanceSMAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, Arrays.asList("warp_execution_efficiency", "warp_nonpred_execution_efficiency"), null);
    }

    private boolean updateExpertForKernelInstanceFunctionUnitAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        ArrayList<String> metrics = new ArrayList<String>();
        AnalysisResultKernelUnitBusy.FunctionUnit[] functionUnitArray = AnalysisResultKernelUnitBusy.FunctionUnit.values();
        int n = functionUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelUnitBusy.FunctionUnit fu = functionUnitArray[n2];
            metrics.add(fu.getUtilizationMetricName());
            ++n2;
        }
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, metrics, null);
    }

    private boolean updateExpertForKernelInstanceInstructionClassAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add("inst_executed");
        AnalysisResultKernelInstructionClass.InstructionClass[] instructionClassArray = AnalysisResultKernelInstructionClass.InstructionClass.values();
        int n = instructionClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelInstructionClass.InstructionClass ic = instructionClassArray[n2];
            metrics.add(ic.getMetricName());
            ++n2;
        }
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, metrics, null);
    }

    private boolean updateExpertForKernelInstanceFlopsAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add("inst_executed");
        AnalysisResultKernelFlops.FlopsKind[] flopsKindArray = AnalysisResultKernelFlops.FlopsKind.values();
        int n = flopsKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelFlops.FlopsKind kind = flopsKindArray[n2];
            metrics.add(kind.getMetricName());
            ++n2;
        }
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, metrics, null);
    }

    private boolean updateExpertForKernelInstanceStallAnalysis(IDevicesData deviceData, Session session, Expert expert) {
        ArrayList<String> stalls = new ArrayList<String>();
        AnalysisResultKernelStall.StallKind[] stallKindArray = AnalysisResultKernelStall.StallKind.values();
        int n = stallKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelStall.StallKind kind = stallKindArray[n2];
            stalls.add(kind.getStallMetricName());
            ++n2;
        }
        return this.updateExpertForKernelInstanceAnalysis(deviceData, session, expert, null, stalls, null);
    }

    private boolean enableSourceResult(Session session, Expert expert, SourceLevelResult sourceResult) {
        TimelineDevice deviceTimeline;
        TimelineIntervalKernel interval = AnalysisStage.getAnalysisHostLaunchedKernel(session);
        if (interval != null && (deviceTimeline = (TimelineDevice)CoreUtil.safeCast((Object)interval.getPrimaryTimeline().getAncestor(TimelineKind.DEVICE), TimelineDevice.class)) != null) {
            expert.enable(deviceTimeline.getNameWithId(), interval, sourceResult);
            return true;
        }
        return false;
    }

    private boolean updateExpertForKernelInstanceUncoalescedGlobalMemoryAnalysis(Session session, Expert expert) {
        return this.enableSourceResult(session, expert, SourceLevelResult.GLOBAL_ACCESS);
    }

    private boolean updateExpertForKernelInstanceSharedAccessAnalysis(Session session, Expert expert) {
        return this.enableSourceResult(session, expert, SourceLevelResult.SHARED_ACCESS);
    }

    private boolean updateExpertForKernelInstanceDivergentBranchAnalysis(Session session, Expert expert) {
        return this.enableSourceResult(session, expert, SourceLevelResult.BRANCH);
    }

    private boolean updateExpertForKernelInstanceInstructionExecutionAnalysis(Session session, Expert expert) {
        return this.enableSourceResult(session, expert, SourceLevelResult.INSTRUCTION_EXECUTION);
    }

    private boolean updateExpertForKernelInstancePCSamplingAnalysis(Session session, Expert expert) {
        return this.enableSourceResult(session, expert, SourceLevelResult.PC_SAMPLING);
    }

    public boolean analyze(Session session) throws ViperException {
        ArrayList<IAnalysis> passes = new ArrayList<IAnalysis>();
        switch (this) {
            case TIMELINE: {
                passes.add(new GPUAnalysis());
                passes.add(new MemcpyAnalysis());
                break;
            }
            case KERNELS: {
                passes.add(new MultiprocessorAnalysis());
                passes.add(new KernelPriorityAnalysis());
                break;
            }
            case KERNELS_PERFORMANCE: {
                passes.add(new KernelMemoryAnalysis());
                passes.add(new KernelInstructionAnalysis());
                break;
            }
            case NVLINK_TOPOLOGY: {
                passes.add(new NVLinkAnalysis());
                break;
            }
            case UNIFIED_MEMORY: {
                passes.add(new UvmAnalysis());
                break;
            }
            case DEPENDENCY_ANALYSIS: {
                passes.add(new CriticalPathAnalysis());
                break;
            }
            case KERNEL_INSTANCE_BOUNDS: {
                passes.add(new KernelInstanceBoundsAnalysis());
                break;
            }
            case KERNEL_INSTANCE_MEMORY: {
                passes.add(new KernelInstanceMemoryAnalysis());
                break;
            }
            case KERNEL_INSTANCE_SM: {
                passes.add(new KernelInstanceSMAnalysis());
                break;
            }
            case KERNEL_INSTANCE_LATENCY: {
                passes.add(new KernelInstanceLatencyAnalysis());
                break;
            }
            case KERNEL_INSTANCE_UNCOALESCED_GLOBAL: {
                passes.add(new KernelInstanceUncoalescedGlobalMemoryAnalysis());
                break;
            }
            case KERNEL_INSTANCE_SHARED_ACCESS: {
                passes.add(new KernelInstanceSharedAccessAnalysis());
                break;
            }
            case KERNEL_INSTANCE_DIVERGENT_BRANCH: {
                passes.add(new KernelInstanceDivergentBranchAnalysis());
                break;
            }
            case KERNEL_INSTANCE_INSTRUCTION_EXECUTION: {
                passes.add(new KernelInstanceInstructionExecutionAnalysis());
                break;
            }
            case KERNEL_INSTANCE_PC_SAMPLING: {
                passes.add(new KernelInstancePCSamplingAnalysis());
                break;
            }
            case KERNEL_INSTANCE_MEMORY_STAT: {
                passes.add(new KernelInstanceMemoryStatAnalysis());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new ViperException("Unknown analysis stage " + (Object)((Object)this));
            }
        }
        boolean ret = true;
        if (!passes.isEmpty()) {
            try {
                session.getAnalysis().disableNotifications();
                session.getAnalysis().clearAnalysisResults(this);
            }
            finally {
                session.getAnalysis().enableNotifications();
            }
            ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>();
            for (IAnalysis pass : passes) {
                boolean passRet = pass.run(session, results, ForceAllAnalysisResultsAction.isForceEnabled());
                boolean bl = ret = ret && passRet;
            }
            session.getAnalysis().setAnalysisResults(this, results);
        }
        return ret;
    }

    public AnalysisScope getScope(ITimelineInterval interval) {
        switch (this) {
            case KERNEL_INSTANCE_BOUNDS: 
            case KERNEL_INSTANCE_MEMORY: 
            case KERNEL_INSTANCE_SM: 
            case KERNEL_INSTANCE_LATENCY: 
            case KERNEL_INSTANCE_UNCOALESCED_GLOBAL: 
            case KERNEL_INSTANCE_SHARED_ACCESS: 
            case KERNEL_INSTANCE_DIVERGENT_BRANCH: 
            case KERNEL_INSTANCE_INSTRUCTION_EXECUTION: 
            case KERNEL_INSTANCE_PC_SAMPLING: 
            case KERNEL_INSTANCE_MEMORY_STAT: {
                if (!(interval instanceof TimelineIntervalKernel)) {
                    return AnalysisScope.NONE;
                }
                return AnalysisScope.KERNEL_INSTANCE;
            }
            case NONE: 
            case TIMELINE: 
            case KERNELS: 
            case KERNELS_PERFORMANCE: 
            case NVLINK_TOPOLOGY: 
            case UNIFIED_MEMORY: 
            case DEPENDENCY_ANALYSIS: {
                return AnalysisScope.APPLICATION;
            }
        }
        throw new IllegalArgumentException("Unknown analysis stage " + (Object)((Object)this));
    }

    public static TimelineIntervalKernel getAnalysisHostLaunchedKernel(Session session) {
        if (session.getAnalysis() == null) {
            return null;
        }
        return AnalysisStage.getHostLaunchedKernel(session.getAnalysis().getActiveScopeInterval());
    }

    public static TimelineIntervalKernel getHostLaunchedKernel(ITimelineInterval interval) {
        if (interval == null || !(interval instanceof TimelineIntervalKernel) || !((TimelineIntervalKernel)interval).isHostLaunched()) {
            return null;
        }
        interval.getPrimaryTimeline().getSession().addAnalysisResults(interval);
        return (TimelineIntervalKernel)interval;
    }
}

