# Design - Gameplay

### Gameplay Table of Contents
* [Objectives](#objectives)
* [Game Stages and Timeline](#game-stages-and-timeline)

The player can interact with the game world in a huge number of ways, if there's something a survivor can do on their own in reality, they should be able to do it in the game.  The game world is a huge uncaring machine, it doesn't react to the player's existence, it's just passively hostile.  Generally speaking the player advances in capabilities by acquiring better equipment, learning things, practicing skills, and gaining allies.

## Objectives

DDA fully embraces the sandbox concept of gaming.  There are goals in DDA, and stories and missions, but the only universal goal is survival.

Short-term objectives include obtaining gear and supplies, learning things, crafting items, helping fellow survivors and exploring.

Medium-term objectives include securing supply sources, establishing a base camp or base vehicle, recruiting NPC allies, joining a faction and clearing an area of enemies.

Long-term objectives include deeply customizing your base camp and/or vehicle, securing a large surplus of supplies, founding a faction and/or making a faction self-sufficient and defeating large groups of enemies.

## Game Stages and Timeline
#### Game Stages and Timeline Table of Contents
* [Overview](#overview-1)
* ["Lone Wolf" Play Element](#lone-wolf-play-element)
* ["Faction" Play Element](#faction-play-element)

### Overview
This is an approximation, and does not describe the expected timeline from a player perspective, but rather the expected design structure.  In other words, it should not be hard-coded that a given feature is only available on a given day, but rather, game design should make access to that feature require a particular time investment making it unlikely to obtain earlier.

**Dev/balance notes:**  
The bottom lines is that there needs to be a ton of stuff to do and explore in the game, rather than the main game objective being to level up in large leaps and bounds.  This playstyle depending on longer frames of time and things taking realistic periods to be built/developed depends heavily on things being automated, for example:

- fast travel options
- schedule eat/drink/sleep/stoke fire options to allow players to skip a week or two of time
- NPCs doing more of the long term crafting and projects in a more automated way.

Some of these features already exist, or exist partially, at the time of this writing.  More features in this vein will help to further capture this play speed.

### "Lone Wolf" Play Element
#### Early game

*Characterized by*: Low to no transhuman/sci fi elements.  Focus on food security and basic survival.  Development of the skills and tools that change you from a "survivor" to a "Survivor".  Little major role for factions or large groups of NPCs except as a backdrop.  Many wandering NPCs that may be hostile, but aren't part of organized groups yet.
##### Terrified and Wet Phase

first couple days to at most first week.

**Key events**:

* Find a basic safe shelter.
* Find enough food to keep you sort of alive.
* Find some clean water.
* Make a safe fire.
* Get a basic weapon and some good clothing.

**Dangers/threats**:

* The weather and elements
* Hunger and thirst
* Zombies are a mortal danger.  A single zombie is manageable but risky.  Multiple probably merit running away.
* Dormant zombies are a major factor in cities, lying around as corpses unless disturbed.

**Other Survivors/Factions**:

*    At this stage of the game, they should be very common, and pose a huge threat if hostile.
*    Factions haven't really formed strongly at this time.  (The evacuees that will become the Free Merchants are forming the basis of their governance and have started writing notes on old money to make for fair division of resources.)

**Travel/Range**:

*    Travel is almost certainly on foot, within a day's range of shelter if one has been secured.

**Special notes**:

*    Many elements of this phase, or the entire phase, might be skipped simply by starting with a particular profession or scenario.

###### New Scavenger Phase:
From mid-spring to end of spring, year 1

**Key Events**:

*    Get some armor and weaponry that deals better with zombies
*    Scavenge small settlements and their outskirts, mainly at night
*    Obtain a stockpile of food and a more serious water source, allowing you to spend a little while crafting or reading between exploration runs
*    Begin to stockpile food, books, and tools, but shouldn't have enough food supplies to be able to spend much time reading or learning

**Dangers/Threats**:

*    Special zombies should start appearing and pose a significant threat at this point
*    Individual normal zombies can probably be managed pretty safely, with a bit of caution, but more than one or two is still a big threat.
*    Dormant zombies are still much more common than active ones (although there are many active ones)
*    Food security is not a day to day concern but is still an ever-looming issue.
*    The elements are not as big a problem at this point except when extreme.

**Other Survivors/Factions**:

*    May have one NPC follower, but they are not yet very loyal.
*    At this stage of the game, they should be very common, and pose a huge threat if hostile.
*    During this phase, factions begin to form as it becomes clear that the world has basically ended.
*    Find rumors of nearby factions (e.g.  graffiti, radio signals, other survivors, computer in evac shelter)

**Travel/Range**:

*    While survivors may have a car or bike during this phase, range is still going to be restricted to "not far from home base" as they won't have fuel reserves or ways to repair their vehicles

##### Wasteland Scavenger Phase
End of spring to mid-to-late summer, year 1

**Key events**:

*    Armour can reliably protect you from one or two zombies
*    Have at least one reliable but low-power long-range weapon, with enough ammo for regular combat, and/or a good, battle-ready melee weapon.  Possibly a more powerful long-ranged weapon with rarer ammo for emergencies.
*    Food security is currently not an issue, starting to stockpile food for winter
*    Develop a pretty secure base, with little concern about small bands of zombies slipping in.  Wandering hordes are a major threat (see below)
*    Almost certainly starting a farming operation around now
*    Have a vehicle, but it's hard to repair and still pretty precious at this point
*    Able to make scavenging runs deeper into cities to get some good loot and tools, with a bit of free time to use books and things.
*    Possibly able to set up a basic electric power grid at the base.
*    Exploring Facilities is a very risky proposition at this time.

**Dangers/Threats**:

*    A lone zombie, or even two or three, pose little threat at this point unless backed up by specials.  More than that and they run the risk of swarming and overwhelming you without careful tactics.
*    Evolutions of special zombies begin to appear and are a larger threat
*    Dormant zombies begin to wake up, forming the backbone of the first wandering hordes.  The first necromancers and a few masters appear.

**Other Survivors/Factions**

*    May have a one or two followers, at least one of which is starting to build up some loyalty
*    Still a lot of other NPCs wandering dynamically around.  Aside from bandits, they are probably becoming a little more cautiously interested in fellow survivors, rather than panicked and fearful.
*    Factions have now completely formed along their main lines and begin opening trade with each other.
*    Gain trust in other factions by running missions for them regularly

**Travel/Range**

*    Likely have a vehicle, especially an easy to maintain one like a bicycle.  Welders and repair tools are at a premium if available at all, so the vehicle is fairly precious.  Range begins to extend to fill probably the entire starting overmap as the player is able to set up safe camps and things.

##### Preparation/Skilled Scavenger Phase
Mid-to-late summer to winter, year 1

**Key Events**:

*    Return of focus to food security as winter comes closer and survivor needs to work hard on stockpiling
*    Most other key resources are now well stocked - ammo, clothing, armor.  Survivor has likely managed to make some deep forays into a few towns, loot a mansion or the upper levels of a Lab.
*    Although the player isn't equipped to install CBMs or develop higher level mutagens they probably have access to the components now, and can start projects to get them on the go over the winter.  Likewise for fancier gear and equipment that isn't available readily from raids.
*    Decreasing focus on wide ranging travel in favor of developing base defenses
*    May at this point have achieved welding tools
*    Probably has electricity and a secure water supply at home base.

**Danger/Threats**:

*    Small groups of zombies are pretty easily handled.  Evolved zombies may pose a threat.
*    Wandering hordes are becoming a big risk.  Base defense from them becomes important, especially with food stockpile protection being important.  This serves to keep the player a bit more grounded at home as well, where running into a horde is more manageable.
*    More dormant zombies coming alive, but probably at least half are still dormant (gonna need cannon fodder next spring)

**Other Survivors/Factions**:

*    Have a small group of followers of varying levels of loyalty, some of whom can be left safely at the base to protect it and work on farming/crafting
*    Begin developing a relationship with some of the major factions esp.  by selling off extra scavenged stuff now that you probably have a surplus of some things
*    Reach the point where some faction missions have run far enough to earn you enmity of opposing factions.  May have to start choosing loyalties.

**Travel/Range**:

*    Possibly able to keep a fancier vehicle running now, making range quite a bit longer, but a higher risk associated if you have a stationary base due to wandering.

##### First Winter
**Key Events**:

* Traveling outside becomes onerous (slow travel through snow), cold, and dangerous (zombies and other threats not visible under snow)
* Encourage player to stay inside, building up the base, studying, and crafting

**Dangers/Threats**:

*    Wandering hordes travel less, slowed by the snow.  Masters might take their hordes into cities and forests to avoid it
*    Dormant zombies aren't visible under the snow making towns even more dangerous.
*    The winter itself is a threat with minimal electricity and no snowplows

**Other Survivors/Factions**:

*    Survivors without factions at this point die in large numbers as hordes move into the towns they've holed up in.  This is probably the biggest die-off of survivors since the cataclysm
*    Factions hunker down, trade routes close off.  Brave players able to travel in the snow might find this a very effective time to get a huge amount of faction favor by doing important jobs, at very high risk.
*    Players who haven't set up a safe enough base might choose to use their faction favor to hunker down with one of them.

**Side note**:

*    Features to automatically consume food and drink and sleep on schedule while engages in long crafting projects would be a good way to make the winter speed by and not feel tedious, while also keeping the "homestead winter" shut-in feeling.

#### Mid-Game

*Characterized by*: Player beginning to adopt transhuman elements if desired.  First serious raids to Facilities - labs, bunkers, military bases, and other 'dungeons' - become possible.  Zombies "level up", so that you're facing not so much individual monsters as nemesis-level masters and their hordes.  Other enemy factions (triffids, mycus, mi-go, others?) begin to expand as threats.

**Side note**: As this is a switch to a very different play style, it should be possible to start out in this phase with some scenarios.

#### Late-Game

*Characterized by*: Player has numerous transhuman elements and top-tier gear.  A single player can probably take on even top-shelf zombies in large numbers, if they're smart about it.  If the player has a faction or a community of their own, protecting that group is more the challenge than trying to survive themselves as they're basically a superhero.  Earth becomes a battleground, with warring factions claiming most of the overmap.

**Balance note**: at no point should a player ever be able to simply wade into a horde of zombies without fear.  Drive a tank, sure.  Man a turret, perhaps.  Walking into the crowd however should always be at least a last ditch fool's errand.  Superhero, not demigod.

**Side note**: This shouldn't be something players can start in straight-away as the challenges of late game derive from things developed in the mid-game.

### "Faction" Play Element

*	 Starts in late Early phase or later
*    Develop and protect a community either from scratch or by joining an existing faction and rising through its ranks.
*    Focuses on building, protecting, recruiting, trading, research, and diplomacy.
*    End-game: Carve out a "safe" portion of the world, or abandon this world hoping to find another that you can survive in.
