/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.internal.ReportOutputFolder;

public class Resources {
    public static final String STYLESHEET = "report.css";
    public static final String PRETTIFY_STYLESHEET = "prettify.css";
    public static final String PRETTIFY_SCRIPT = "prettify.js";
    public static final String SORT_SCRIPT = "sort.js";
    public static final String REDBAR = "redbar.gif";
    public static final String GREENBAR = "greenbar.gif";
    private final ReportOutputFolder folder;

    public Resources(ReportOutputFolder root) {
        this.folder = root.subFolder("jacoco-resources");
    }

    public String getLink(ReportOutputFolder base, String name) {
        return this.folder.getLink(base, name);
    }

    public static String getElementStyle(ICoverageNode.ElementType type) {
        switch (type) {
            case GROUP: {
                return "el_group";
            }
            case BUNDLE: {
                return "el_bundle";
            }
            case PACKAGE: {
                return "el_package";
            }
            case SOURCEFILE: {
                return "el_source";
            }
            case CLASS: {
                return "el_class";
            }
            case METHOD: {
                return "el_method";
            }
        }
        throw new AssertionError((Object)("Unknown element type: " + type));
    }

    public void copyResources() throws IOException {
        this.copyResource(STYLESHEET);
        this.copyResource("report.gif");
        this.copyResource("group.gif");
        this.copyResource("bundle.gif");
        this.copyResource("package.gif");
        this.copyResource("source.gif");
        this.copyResource("class.gif");
        this.copyResource("method.gif");
        this.copyResource("session.gif");
        this.copyResource("sort.gif");
        this.copyResource("up.gif");
        this.copyResource("down.gif");
        this.copyResource("branchfc.gif");
        this.copyResource("branchnc.gif");
        this.copyResource("branchpc.gif");
        this.copyResource(REDBAR);
        this.copyResource(GREENBAR);
        this.copyResource(PRETTIFY_STYLESHEET);
        this.copyResource(PRETTIFY_SCRIPT);
        this.copyResource(SORT_SCRIPT);
    }

    private void copyResource(String name) throws IOException {
        int len;
        InputStream in = Resources.class.getResourceAsStream(name);
        OutputStream out = this.folder.createFile(name);
        byte[] buffer = new byte[256];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

