﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/groundstation/GroundStation_EXPORTS.h>
#include <aws/groundstation/model/ConfigCapabilityType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GroundStation {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ConfigIdResponse">AWS
 * API Reference</a></p>
 */
class UpdateConfigResult {
 public:
  AWS_GROUNDSTATION_API UpdateConfigResult() = default;
  AWS_GROUNDSTATION_API UpdateConfigResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GROUNDSTATION_API UpdateConfigResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>UUID of a <code>Config</code>.</p>
   */
  inline const Aws::String& GetConfigId() const { return m_configId; }
  template <typename ConfigIdT = Aws::String>
  void SetConfigId(ConfigIdT&& value) {
    m_configIdHasBeenSet = true;
    m_configId = std::forward<ConfigIdT>(value);
  }
  template <typename ConfigIdT = Aws::String>
  UpdateConfigResult& WithConfigId(ConfigIdT&& value) {
    SetConfigId(std::forward<ConfigIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Type of a <code>Config</code>.</p>
   */
  inline ConfigCapabilityType GetConfigType() const { return m_configType; }
  inline void SetConfigType(ConfigCapabilityType value) {
    m_configTypeHasBeenSet = true;
    m_configType = value;
  }
  inline UpdateConfigResult& WithConfigType(ConfigCapabilityType value) {
    SetConfigType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ARN of a <code>Config</code>.</p>
   */
  inline const Aws::String& GetConfigArn() const { return m_configArn; }
  template <typename ConfigArnT = Aws::String>
  void SetConfigArn(ConfigArnT&& value) {
    m_configArnHasBeenSet = true;
    m_configArn = std::forward<ConfigArnT>(value);
  }
  template <typename ConfigArnT = Aws::String>
  UpdateConfigResult& WithConfigArn(ConfigArnT&& value) {
    SetConfigArn(std::forward<ConfigArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateConfigResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configId;

  ConfigCapabilityType m_configType{ConfigCapabilityType::NOT_SET};

  Aws::String m_configArn;

  Aws::String m_requestId;
  bool m_configIdHasBeenSet = false;
  bool m_configTypeHasBeenSet = false;
  bool m_configArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GroundStation
}  // namespace Aws
