﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/waf-regional/model/XssMatchSet.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAFRegional {
namespace Model {
/**
 * <p>The response to a <code>CreateXssMatchSet</code> request.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateXssMatchSetResponse">AWS
 * API Reference</a></p>
 */
class CreateXssMatchSetResult {
 public:
  AWS_WAFREGIONAL_API CreateXssMatchSetResult() = default;
  AWS_WAFREGIONAL_API CreateXssMatchSetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAFREGIONAL_API CreateXssMatchSetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An <a>XssMatchSet</a>.</p>
   */
  inline const XssMatchSet& GetXssMatchSet() const { return m_xssMatchSet; }
  template <typename XssMatchSetT = XssMatchSet>
  void SetXssMatchSet(XssMatchSetT&& value) {
    m_xssMatchSetHasBeenSet = true;
    m_xssMatchSet = std::forward<XssMatchSetT>(value);
  }
  template <typename XssMatchSetT = XssMatchSet>
  CreateXssMatchSetResult& WithXssMatchSet(XssMatchSetT&& value) {
    SetXssMatchSet(std::forward<XssMatchSetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>ChangeToken</code> that you used to submit the
   * <code>CreateXssMatchSet</code> request. You can also use this value to query the
   * status of the request. For more information, see
   * <a>GetChangeTokenStatus</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  CreateXssMatchSetResult& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateXssMatchSetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  XssMatchSet m_xssMatchSet;

  Aws::String m_changeToken;

  Aws::String m_requestId;
  bool m_xssMatchSetHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
