﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lookoutmetrics/LookoutMetrics_EXPORTS.h>
#include <aws/lookoutmetrics/model/AnomalyGroup.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace LookoutMetrics
{
namespace Model
{
  class GetAnomalyGroupResult
  {
  public:
    AWS_LOOKOUTMETRICS_API GetAnomalyGroupResult() = default;
    AWS_LOOKOUTMETRICS_API GetAnomalyGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_LOOKOUTMETRICS_API GetAnomalyGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Details about the anomaly group.</p>
     */
    inline const AnomalyGroup& GetAnomalyGroup() const { return m_anomalyGroup; }
    template<typename AnomalyGroupT = AnomalyGroup>
    void SetAnomalyGroup(AnomalyGroupT&& value) { m_anomalyGroupHasBeenSet = true; m_anomalyGroup = std::forward<AnomalyGroupT>(value); }
    template<typename AnomalyGroupT = AnomalyGroup>
    GetAnomalyGroupResult& WithAnomalyGroup(AnomalyGroupT&& value) { SetAnomalyGroup(std::forward<AnomalyGroupT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    GetAnomalyGroupResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    AnomalyGroup m_anomalyGroup;
    bool m_anomalyGroupHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace LookoutMetrics
} // namespace Aws
