﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/athena/model/PreparedStatementSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListPreparedStatementsResult
  {
  public:
    AWS_ATHENA_API ListPreparedStatementsResult() = default;
    AWS_ATHENA_API ListPreparedStatementsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListPreparedStatementsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The list of prepared statements for the workgroup.</p>
     */
    inline const Aws::Vector<PreparedStatementSummary>& GetPreparedStatements() const { return m_preparedStatements; }
    template<typename PreparedStatementsT = Aws::Vector<PreparedStatementSummary>>
    void SetPreparedStatements(PreparedStatementsT&& value) { m_preparedStatementsHasBeenSet = true; m_preparedStatements = std::forward<PreparedStatementsT>(value); }
    template<typename PreparedStatementsT = Aws::Vector<PreparedStatementSummary>>
    ListPreparedStatementsResult& WithPreparedStatements(PreparedStatementsT&& value) { SetPreparedStatements(std::forward<PreparedStatementsT>(value)); return *this;}
    template<typename PreparedStatementsT = PreparedStatementSummary>
    ListPreparedStatementsResult& AddPreparedStatements(PreparedStatementsT&& value) { m_preparedStatementsHasBeenSet = true; m_preparedStatements.emplace_back(std::forward<PreparedStatementsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListPreparedStatementsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListPreparedStatementsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<PreparedStatementSummary> m_preparedStatements;
    bool m_preparedStatementsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
