"use strict";

module.exports = function (res, fn) {
  res.text = '';
  res.setEncoding('utf8');
  res.on('data', function (chunk) {
    res.text += chunk;
  });
  res.on('end', function () {
    var body;
    var error;

    try {
      body = res.text && JSON.parse(res.text);
    } catch (err) {
      error = err; // issue #675: return the raw response if the response parsing fails

      error.rawResponse = res.text || null; // issue #876: return the http status code if the response parsing fails

      error.statusCode = res.statusCode;
    } finally {
      fn(error, body);
    }
  });
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJtb2R1bGUiLCJleHBvcnRzIiwicmVzIiwiZm4iLCJ0ZXh0Iiwic2V0RW5jb2RpbmciLCJvbiIsImNodW5rIiwiYm9keSIsImVycm9yIiwiSlNPTiIsInBhcnNlIiwiZXJyIiwicmF3UmVzcG9uc2UiLCJzdGF0dXNDb2RlIl0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL25vZGUvcGFyc2Vycy9qc29uLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gZnVuY3Rpb24gKHJlcywgZm4pIHtcbiAgcmVzLnRleHQgPSAnJztcbiAgcmVzLnNldEVuY29kaW5nKCd1dGY4Jyk7XG4gIHJlcy5vbignZGF0YScsIChjaHVuaykgPT4ge1xuICAgIHJlcy50ZXh0ICs9IGNodW5rO1xuICB9KTtcbiAgcmVzLm9uKCdlbmQnLCAoKSA9PiB7XG4gICAgbGV0IGJvZHk7XG4gICAgbGV0IGVycm9yO1xuICAgIHRyeSB7XG4gICAgICBib2R5ID0gcmVzLnRleHQgJiYgSlNPTi5wYXJzZShyZXMudGV4dCk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBlcnJvciA9IGVycjtcbiAgICAgIC8vIGlzc3VlICM2NzU6IHJldHVybiB0aGUgcmF3IHJlc3BvbnNlIGlmIHRoZSByZXNwb25zZSBwYXJzaW5nIGZhaWxzXG4gICAgICBlcnJvci5yYXdSZXNwb25zZSA9IHJlcy50ZXh0IHx8IG51bGw7XG4gICAgICAvLyBpc3N1ZSAjODc2OiByZXR1cm4gdGhlIGh0dHAgc3RhdHVzIGNvZGUgaWYgdGhlIHJlc3BvbnNlIHBhcnNpbmcgZmFpbHNcbiAgICAgIGVycm9yLnN0YXR1c0NvZGUgPSByZXMuc3RhdHVzQ29kZTtcbiAgICB9IGZpbmFsbHkge1xuICAgICAgZm4oZXJyb3IsIGJvZHkpO1xuICAgIH1cbiAgfSk7XG59O1xuIl0sIm1hcHBpbmdzIjoiOztBQUFBQSxNQUFNLENBQUNDLE9BQVAsR0FBaUIsVUFBVUMsR0FBVixFQUFlQyxFQUFmLEVBQW1CO0VBQ2xDRCxHQUFHLENBQUNFLElBQUosR0FBVyxFQUFYO0VBQ0FGLEdBQUcsQ0FBQ0csV0FBSixDQUFnQixNQUFoQjtFQUNBSCxHQUFHLENBQUNJLEVBQUosQ0FBTyxNQUFQLEVBQWUsVUFBQ0MsS0FBRCxFQUFXO0lBQ3hCTCxHQUFHLENBQUNFLElBQUosSUFBWUcsS0FBWjtFQUNELENBRkQ7RUFHQUwsR0FBRyxDQUFDSSxFQUFKLENBQU8sS0FBUCxFQUFjLFlBQU07SUFDbEIsSUFBSUUsSUFBSjtJQUNBLElBQUlDLEtBQUo7O0lBQ0EsSUFBSTtNQUNGRCxJQUFJLEdBQUdOLEdBQUcsQ0FBQ0UsSUFBSixJQUFZTSxJQUFJLENBQUNDLEtBQUwsQ0FBV1QsR0FBRyxDQUFDRSxJQUFmLENBQW5CO0lBQ0QsQ0FGRCxDQUVFLE9BQU9RLEdBQVAsRUFBWTtNQUNaSCxLQUFLLEdBQUdHLEdBQVIsQ0FEWSxDQUVaOztNQUNBSCxLQUFLLENBQUNJLFdBQU4sR0FBb0JYLEdBQUcsQ0FBQ0UsSUFBSixJQUFZLElBQWhDLENBSFksQ0FJWjs7TUFDQUssS0FBSyxDQUFDSyxVQUFOLEdBQW1CWixHQUFHLENBQUNZLFVBQXZCO0lBQ0QsQ0FSRCxTQVFVO01BQ1JYLEVBQUUsQ0FBQ00sS0FBRCxFQUFRRCxJQUFSLENBQUY7SUFDRDtFQUNGLENBZEQ7QUFlRCxDQXJCRCJ9