/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;

public final class TypedLiteralNode
extends Pattern {
    private final String _groupName;
    private final Class<?> _primitiveType;

    public TypedLiteralNode(Class<?> primitiveType) {
        this._groupName = null;
        this._primitiveType = VerifyArgument.notNull(primitiveType, "primitiveType");
    }

    public TypedLiteralNode(String groupName, Class<?> primitiveType) {
        this._groupName = groupName;
        this._primitiveType = VerifyArgument.notNull(primitiveType, "primitiveType");
    }

    @Override
    public final boolean matches(INode other, Match match) {
        PrimitiveExpression primitive;
        if (other instanceof PrimitiveExpression && this._primitiveType.isInstance((primitive = (PrimitiveExpression)other).getValue())) {
            match.add(this._groupName, other);
            return true;
        }
        return false;
    }
}

