/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.ArraySpecifier;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class ArrayCreationExpression
extends Expression {
    public static final TokenRole NEW_KEYWORD_ROLE = new TokenRole("new", 1);
    public static final Role<ArraySpecifier> ADDITIONAL_ARRAY_SPECIFIER_ROLE = new Role<ArraySpecifier>("AdditionalArraySpecifier", ArraySpecifier.class);
    public static final Role<ArrayInitializerExpression> INITIALIZER_ROLE = new Role<ArrayInitializerExpression>("Initializer", ArrayInitializerExpression.class, ArrayInitializerExpression.NULL);

    public ArrayCreationExpression(int offset) {
        super(offset);
    }

    public final AstNodeCollection<Expression> getDimensions() {
        return this.getChildrenByRole(Roles.ARGUMENT);
    }

    public final ArrayInitializerExpression getInitializer() {
        return this.getChildByRole(INITIALIZER_ROLE);
    }

    public final void setInitializer(ArrayInitializerExpression value) {
        this.setChildByRole(INITIALIZER_ROLE, value);
    }

    public final AstNodeCollection<ArraySpecifier> getAdditionalArraySpecifiers() {
        return this.getChildrenByRole(ADDITIONAL_ARRAY_SPECIFIER_ROLE);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final JavaTokenNode getNewToken() {
        return this.getChildByRole(NEW_KEYWORD_ROLE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitArrayCreationExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ArrayCreationExpression) {
            ArrayCreationExpression otherExpression = (ArrayCreationExpression)other;
            return !otherExpression.isNull() && this.getType().matches(otherExpression.getType(), match) && this.getDimensions().matches(otherExpression.getDimensions(), match) && this.getInitializer().matches(otherExpression.getInitializer(), match) && this.getAdditionalArraySpecifiers().matches(otherExpression.getAdditionalArraySpecifiers(), match);
        }
        return false;
    }
}

