/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BytecodeConstant;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodHandlePlaceholder;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.AbstractHelperClassTransform;
import java.util.HashMap;
import java.util.Map;

public class MethodHandleConstantRewriter
extends AbstractHelperClassTransform {
    private final Map<MethodHandle, LcdMHHelperBuilder> helpers = new HashMap<MethodHandle, LcdMHHelperBuilder>();

    public MethodHandleConstantRewriter(DecompilerContext context) {
        super(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        this.helpers.clear();
        super.run(compilationUnit);
    }

    @Override
    public Void visitBytecodeConstant(BytecodeConstant node, Void data) {
        if (node instanceof MethodHandlePlaceholder) {
            return this.visitMethodHandlePlaceholder((MethodHandlePlaceholder)node, data);
        }
        return (Void)super.visitBytecodeConstant(node, data);
    }

    protected Void visitMethodHandlePlaceholder(MethodHandlePlaceholder node, Void data) {
        TypeDeclaration currentType = this.currentType;
        TypeDefinition currentTypeDefinition = currentType != null ? currentType.getUserData(Keys.TYPE_DEFINITION) : null;
        MethodHandle handle = node.getHandle();
        if (currentTypeDefinition == null || handle == null || this.resolver == null) {
            return null;
        }
        boolean needsInsertion = false;
        LcdMHHelperBuilder hb = this.helpers.get(handle);
        if (hb == null) {
            needsInsertion = true;
            hb = new LcdMHHelperBuilder(currentType, currentTypeDefinition, handle);
            this.helpers.put(handle, hb);
        }
        if (hb.build()) {
            MemberReferenceExpression replacement = this.makeType(hb.definition).member(hb.definition.fdHandle);
            node.replaceWith(replacement);
            replacement.getParent().insertChildBefore(replacement, new Comment(" ldc_method_handle(!) ", CommentType.MultiLine), Roles.COMMENT);
            if (needsInsertion) {
                currentType.getMembers().insertAfter(currentType.getMembers().lastOrNullObject(), hb.declaration);
                if (hb.extraLookupField != null) {
                    currentType.getMembers().insertBefore(hb.declaration, hb.extraLookupField);
                }
                AstNode commentAnchor = hb.declaration.getFirstChild();
                hb.declaration.insertChildBefore(commentAnchor, new Comment(" This helper class was generated by Procyon to approximate the behavior of a"), Roles.COMMENT);
                hb.declaration.insertChildBefore(commentAnchor, new Comment(" MethodHandle constant that cannot (currently) be represented in Java code."), Roles.COMMENT);
            }
        }
        return null;
    }

    protected final class LcdMHHelperBuilder {
        static final String T_DESC_METHOD_HANDLE = "java/lang/invoke/MethodHandle";
        static final String F_DESC_ENSURE_HANDLE = "Ljava/lang/invoke/MethodHandle;";
        static final String M_DESC_ENSURE_HANDLE = "()Ljava/lang/invoke/MethodHandle;";
        final TypeDeclaration parentDeclaration;
        final TypeReference parentType;
        final MethodHandle handle;
        final TypeReference callSiteType;
        final TypeReference methodHandleType;
        final TypeReference methodTypeType;
        final TypeReference methodHandlesType;
        final TypeReference lookupType;
        final MethodReference handleMethod;
        final MethodReference ensureHandleMethod;
        final HelperTypeDefinition definition;
        final int generatedTypeId;
        Boolean alreadyBuilt;
        TypeDeclaration declaration;
        FieldDeclaration extraLookupField;
        MethodDeclaration handleDeclaration;

        LcdMHHelperBuilder(TypeDeclaration parentDeclaration, TypeReference parentType, MethodHandle handle) {
            this.parentDeclaration = VerifyArgument.notNull(parentDeclaration, "parentDeclaration");
            this.parentType = VerifyArgument.notNull(parentType, "parentType");
            this.handle = VerifyArgument.notNull(handle, "handle");
            this.generatedTypeId = AbstractHelperClassTransform.nextUniqueId();
            TypeReference helperType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor(String.format("%s_%x", "ProcyonConstantHelper", this.generatedTypeId));
            this.callSiteType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/CallSite");
            this.methodTypeType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/MethodType");
            this.methodHandleType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor(T_DESC_METHOD_HANDLE);
            this.methodHandlesType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/MethodHandles");
            this.definition = new HelperTypeDefinition(helperType, parentType);
            this.handleMethod = MethodHandleConstantRewriter.this.parser.parseMethod(this.definition, "handle", M_DESC_ENSURE_HANDLE);
            this.ensureHandleMethod = MethodHandleConstantRewriter.this.parser.parseMethod(this.definition, "ensureHandle", M_DESC_ENSURE_HANDLE);
            this.lookupType = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/MethodHandles$Lookup");
        }

        boolean build() {
            TypeDeclaration declaration;
            Boolean built = this.alreadyBuilt;
            if (built != null) {
                return built;
            }
            this.declaration = declaration = new TypeDeclaration();
            AstNodeCollection<JavaModifierToken> modifiers = this.declaration.getModifiers();
            for (Flags.Flag modifier : Flags.asFlagSet(26L)) {
                modifiers.add(new JavaModifierToken(TextLocation.EMPTY, modifier));
            }
            declaration.setClassType(ClassType.CLASS);
            declaration.setName(this.definition.getSimpleName());
            declaration.putUserData(Keys.TYPE_REFERENCE, this.definition.selfReference);
            declaration.putUserData(Keys.TYPE_DEFINITION, this.definition);
            AstNodeCollection<EntityDeclaration> members = declaration.getMembers();
            members.add(this.buildHandleField());
            members.add(this.buildTypeInitializer());
            this.alreadyBuilt = true;
            return true;
        }

        FieldDeclaration buildHandleField() {
            return MethodHandleConstantRewriter.this.declareField(this.definition.fdHandle, Expression.NULL, 0);
        }

        VariableDeclarationStatement makeMethodTypeVariableDeclaration() {
            Variable v = new Variable();
            VariableDeclarationStatement vd = new VariableDeclarationStatement(MethodHandleConstantRewriter.this.makeType(this.methodTypeType), "type", MethodHandleConstantRewriter.this.makeMethodType(this.handle.getMethod()));
            v.setGenerated(false);
            v.setName("type");
            v.setType(this.methodTypeType);
            vd.addModifier(Flags.Flag.FINAL);
            vd.putUserData(Keys.VARIABLE, v);
            return vd;
        }

        VariableDeclarationStatement makeHandleVariableDeclaration() {
            Variable v = new Variable();
            VariableDeclarationStatement vd = new VariableDeclarationStatement(MethodHandleConstantRewriter.this.makeType(this.methodHandleType), "handle");
            v.setGenerated(false);
            v.setName("handle");
            v.setType(this.methodHandleType);
            vd.putUserData(Keys.VARIABLE, v);
            return vd;
        }

        MethodDeclaration buildTypeInitializer() {
            Expression lookup;
            MethodReference insertArguments = MethodHandleConstantRewriter.this.parser.parseMethod(this.methodHandlesType, "insertArguments", "(Ljava/lang/invoke/MethodHandle;I[Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;");
            MethodReference permuteArguments = MethodHandleConstantRewriter.this.parser.parseMethod(this.methodHandlesType, "permuteArguments", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;[I)Ljava/lang/invoke/MethodHandle;");
            MethodReference throwException = MethodHandleConstantRewriter.this.parser.parseMethod(this.methodHandlesType, "throwException", "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;");
            MethodReference returnType = MethodHandleConstantRewriter.this.parser.parseMethod(this.methodTypeType, "returnType", "()Ljava/lang/Class;");
            MethodReference getClass = MethodHandleConstantRewriter.this.parser.parseMethod(BuiltinTypes.Object, "getClass", "()Ljava/lang/Class;");
            TypeReference reflectionException = MethodHandleConstantRewriter.this.parser.parseTypeDescriptor("java/lang/ReflectiveOperationException");
            MethodDeclaration declaration = MethodHandleConstantRewriter.this.newMethod(this.definition.mdTypeInit);
            VariableDeclarationStatement handle = this.makeHandleVariableDeclaration();
            VariableDeclarationStatement type = this.makeMethodTypeVariableDeclaration();
            TryCatchStatement tryCatch = new TryCatchStatement();
            Variable vHandle = handle.getUserData(Keys.VARIABLE);
            Variable vType = type.getUserData(Keys.VARIABLE);
            MethodReference lookupMethod = MethodHandleConstantRewriter.this.parser.parseMethod(this.methodHandlesType, "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;");
            if (MethodHandleConstantRewriter.this.context.isSupported(LanguageFeature.PRIVATE_LOOKUP)) {
                lookup = MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(MethodHandleConstantRewriter.this.parser.parseMethod(this.methodHandlesType, "privateLookupIn", "()Ljava/lang/invoke/MethodHandles$Lookup;"), MethodHandleConstantRewriter.this.makeType(MethodHandleConstantRewriter.this.currentType.getUserData(Keys.TYPE_DEFINITION)).classOf(), MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(lookupMethod, new Expression[0]));
            } else {
                FieldDefinition lookupField = new FieldDefinition(this.lookupType){
                    {
                        this.setName(String.format("__PROCYON__LOOKUP_%x__", LcdMHHelperBuilder.this.generatedTypeId));
                        this.setDeclaringType(MethodHandleConstantRewriter.this.currentType.getUserData(Keys.TYPE_DEFINITION));
                        this.setFlags(10L);
                    }
                };
                this.extraLookupField = MethodHandleConstantRewriter.this.declareField(lookupField, MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(lookupMethod, new Expression[0]), 24);
                lookup = MethodHandleConstantRewriter.this.makeReference(lookupField);
            }
            tryCatch.setTryBlock(new BlockStatement(new ExpressionStatement(new AssignmentExpression(MethodHandleConstantRewriter.this.varReference(vHandle), MethodHandleConstantRewriter.this.makeMethodHandle(lookup, this.handle, MethodHandleConstantRewriter.this.varReference(type))))));
            CatchClause cc = new CatchClause();
            cc.setVariableName("e");
            cc.addVariableModifier(Flags.Flag.FINAL);
            cc.putUserData(Keys.VARIABLE, MethodHandleConstantRewriter.this.makeCatchVariable("e", reflectionException));
            cc.getExceptionTypes().add(MethodHandleConstantRewriter.this.makeType(reflectionException));
            Variable vException = cc.getUserData(Keys.VARIABLE);
            cc.setBody(new BlockStatement(new ExpressionStatement(new AssignmentExpression(MethodHandleConstantRewriter.this.varReference(vHandle), MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(permuteArguments, MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(insertArguments, MethodHandleConstantRewriter.this.makeType(this.methodHandlesType).invoke(throwException, MethodHandleConstantRewriter.this.varReference(vType).invoke(returnType, new Expression[0]), MethodHandleConstantRewriter.this.varReference(vException).invoke(getClass, new Expression[0])), new PrimitiveExpression((Object)0), MethodHandleConstantRewriter.this.varReference(vException)), MethodHandleConstantRewriter.this.varReference(vType))))));
            tryCatch.getCatchClauses().add(cc);
            declaration.setBody(new BlockStatement(handle, type, tryCatch, new ExpressionStatement(new AssignmentExpression(MethodHandleConstantRewriter.this.makeReference(this.definition.fdHandle), MethodHandleConstantRewriter.this.varReference(vHandle)))));
            this.handleDeclaration = declaration;
            return declaration;
        }

        private final class HelperTypeDefinition
        extends TypeDefinition {
            final TypeReference selfReference;
            final FieldDefinition fdHandle;
            final MethodDefinition mdTypeInit;

            HelperTypeDefinition(TypeReference selfReference, TypeReference parentType) {
                super(AbstractHelperClassTransform.resolver(parentType));
                this.selfReference = selfReference;
                this.setPackageName(selfReference.getPackageName());
                this.setSimpleName(selfReference.getSimpleName());
                this.setBaseType(BuiltinTypes.Object);
                this.setFlags(18L);
                this.setDeclaringType(parentType);
                TypeDefinition resolvedParent = parentType.resolve();
                if (resolvedParent != null) {
                    this.setResolver(resolvedParent.getResolver());
                    this.setCompilerVersion(resolvedParent.getCompilerMajorVersion(), resolvedParent.getCompilerMinorVersion());
                } else {
                    this.setResolver(MethodHandleConstantRewriter.this.resolver());
                    this.setCompilerVersion(CompilerTarget.JDK1_7.majorVersion, CompilerTarget.JDK1_7.minorVersion);
                }
                final HelperTypeDefinition self = this;
                this.fdHandle = new FieldDefinition(LcdMHHelperBuilder.this.methodHandleType){
                    {
                        super(fieldType);
                        this.setName("HANDLE");
                        this.setDeclaringType(self);
                        this.setFlags(24L);
                    }
                };
                this.mdTypeInit = new MethodDefinition(){
                    {
                        this.setName("<clinit>");
                        this.setDeclaringType(self);
                        this.setFlags(8L);
                        this.setReturnType(BuiltinTypes.Void);
                    }
                };
                Collection<FieldDefinition> fields = this.getDeclaredFieldsInternal();
                Collection<MethodDefinition> methods = this.getDeclaredMethodsInternal();
                fields.add(this.fdHandle);
                methods.add(this.mdTypeInit);
            }
        }
    }
}

