/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class Scanline<T> {
    private List<T> points;
    private Comparator<T> comparator;
    private List<EventHandler<T>> eventHandlers;

    private Scanline(List<T> points, Comparator<T> comparator, Iterable<EventHandler<T>> eventHandlers) {
        this.comparator = comparator;
        this.points = points;
        this.eventHandlers = Lists.newArrayList(eventHandlers);
    }

    public static <T> void execute(Iterable<T> points, Comparator<T> comparator, Iterable<EventHandler<T>> eventHandlers) {
        ArrayList<T> copy = Lists.newArrayList(points);
        new Scanline<T>(copy, comparator, eventHandlers).go();
    }

    public static <T> void execute(Iterable<T> points, Comparator<T> comparator, EventHandler<T> eventHandler) {
        Scanline.execute(points, comparator, Arrays.asList(eventHandler));
    }

    private void go() {
        Collections.sort(this.points, this.comparator);
        for (T p : this.points) {
            for (EventHandler<T> h2 : this.eventHandlers) {
                h2.handle(p);
            }
        }
    }

    @FunctionalInterface
    public static interface EventHandler<T> {
        public void handle(T var1);
    }
}

