/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmFlags;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmProtoBufUtil {
    @NotNull
    public static final JvmProtoBufUtil INSTANCE = new JvmProtoBufUtil();
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;

    private JvmProtoBufUtil() {
    }

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(BitEncoding.decodeBytes(data2));
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Function.parseFrom(input, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(InputStream $this$readNameResolver, String[] strings) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom($this$readNameResolver, EXTENSION_REGISTRY);
        Intrinsics.checkNotNullExpressionValue((Object)stringTableTypes, (String)"parseDelimitedFrom(this, EXTENSION_REGISTRY)");
        return new JvmNameResolver(stringTableTypes, strings);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JvmMemberSignature.Method getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"methodSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n = name = signature2 != null && signature2.hasName() ? signature2.getName() : proto.getName();
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $this$mapTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Collection collection = CollectionsKt.listOfNotNull((Object)ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            Iterable<ProtoBuf.ValueParameter> iterable = proto.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"proto.valueParameterList");
            iterable = iterable;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable);
                object.add(type2);
            }
            object = (List)destination$iv$iv;
            List parameterTypes = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object));
            Iterable $this$map$iv2 = parameterTypes;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type bl = (ProtoBuf.Type)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string2 = this.mapTypeDefault((ProtoBuf.Type)it, nameResolver);
                if (string2 == null) {
                    return null;
                }
                object = string2;
                collection2.add(object);
            }
            List parametersDesc = (List)destination$iv$iv2;
            String string3 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string3 == null) {
                return null;
            }
            String returnTypeDesc = string3;
            string = Intrinsics.stringPlus((String)CollectionsKt.joinToString$default((Iterable)parametersDesc, (CharSequence)"", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null), (Object)returnTypeDesc);
        }
        String desc = string;
        return new JvmMemberSignature.Method(nameResolver.getString(name), desc);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JvmMemberSignature.Method getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        String name;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"constructorSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        String string2 = name = signature2 != null && signature2.hasName() ? nameResolver.getString(signature2.getName()) : "<init>";
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $this$mapTo$iv$iv;
            List<ProtoBuf.ValueParameter> list = proto.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"proto.valueParameterList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string3 = this.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable), nameResolver);
                if (string3 == null) {
                    return null;
                }
                String string4 = string3;
                collection.add(string4);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", (CharSequence)"(", (CharSequence)")V", (int)0, null, null, (int)56, null);
        }
        String desc = string;
        return new JvmMemberSignature.Method(name, desc);
    }

    @Nullable
    public final JvmMemberSignature.Field getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, boolean requireHasFieldFlag) {
        String string;
        int name;
        JvmProtoBuf.JvmFieldSignature field;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"propertySignature");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature;
        JvmProtoBuf.JvmFieldSignature jvmFieldSignature = field = signature2.hasField() ? signature2.getField() : null;
        if (field == null && requireHasFieldFlag) {
            return null;
        }
        int n = name = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            string = string2;
        }
        String desc = string;
        return new JvmMemberSignature.Field(nameResolver.getString(name), desc);
    }

    public static /* synthetic */ JvmMemberSignature.Field getJvmFieldSignature$default(JvmProtoBufUtil jvmProtoBufUtil, ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return jvmProtoBufUtil.getJvmFieldSignature(property, nameResolver, typeTable, bl);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        return type2.hasClassName() ? ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(type2.getClassName())) : null;
    }

    @JvmStatic
    public static final boolean isMovedFromInterfaceCompanion(@NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_MOVED_FROM_INTERFACE_COMPANION();
        Integer n = proto.getExtension(JvmProtoBuf.flags);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"proto.getExtension(JvmProtoBuf.flags)");
        Boolean bl = booleanFlagField.get(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"JvmFlags.IS_MOVED_FROM_INTERFACE_COMPANION.get(proto.getExtension(JvmProtoBuf.flags))");
        return bl;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionRegistryLite p0 = extensionRegistryLite;
        boolean bl3 = false;
        JvmProtoBuf.registerAllExtensions(p0);
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite;
        Intrinsics.checkNotNullExpressionValue((Object)extensionRegistryLite2, (String)"newInstance().apply(JvmProtoBuf::registerAllExtensions)");
        EXTENSION_REGISTRY = extensionRegistryLite2;
    }
}

