/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.expression.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.opensearch.sql.legacy.expression.model.ExprMissingValue;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import org.opensearch.sql.legacy.expression.model.ExprValueFactory;

public class BindingTuple {
    private final Map<String, ExprValue> bindingMap;

    public ExprValue resolve(String bindingName) {
        return this.bindingMap.getOrDefault(bindingName, new ExprMissingValue());
    }

    public String toString() {
        return this.bindingMap.entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",", "<", ">"));
    }

    public static BindingTuple from(Map<String, Object> map) {
        return BindingTuple.from(new JSONObject(map));
    }

    public static BindingTuple from(JSONObject json) {
        Map map = json.toMap();
        BindingTupleBuilder bindingTupleBuilder = BindingTuple.builder();
        map.forEach((key, value) -> bindingTupleBuilder.binding((String)key, ExprValueFactory.from(value)));
        return bindingTupleBuilder.build();
    }

    BindingTuple(Map<String, ExprValue> bindingMap) {
        this.bindingMap = bindingMap;
    }

    public static BindingTupleBuilder builder() {
        return new BindingTupleBuilder();
    }

    public Map<String, ExprValue> getBindingMap() {
        return this.bindingMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingTuple)) {
            return false;
        }
        BindingTuple other = (BindingTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ExprValue> this$bindingMap = this.getBindingMap();
        Map<String, ExprValue> other$bindingMap = other.getBindingMap();
        return !(this$bindingMap == null ? other$bindingMap != null : !((Object)this$bindingMap).equals(other$bindingMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BindingTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ExprValue> $bindingMap = this.getBindingMap();
        result = result * 59 + ($bindingMap == null ? 43 : ((Object)$bindingMap).hashCode());
        return result;
    }

    public static class BindingTupleBuilder {
        private ArrayList<String> bindingMap$key;
        private ArrayList<ExprValue> bindingMap$value;

        BindingTupleBuilder() {
        }

        public BindingTupleBuilder binding(String bindingKey, ExprValue bindingValue) {
            if (this.bindingMap$key == null) {
                this.bindingMap$key = new ArrayList();
                this.bindingMap$value = new ArrayList();
            }
            this.bindingMap$key.add(bindingKey);
            this.bindingMap$value.add(bindingValue);
            return this;
        }

        public BindingTupleBuilder bindingMap(Map<? extends String, ? extends ExprValue> bindingMap) {
            if (bindingMap == null) {
                throw new NullPointerException("bindingMap cannot be null");
            }
            if (this.bindingMap$key == null) {
                this.bindingMap$key = new ArrayList();
                this.bindingMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ExprValue> $lombokEntry : bindingMap.entrySet()) {
                this.bindingMap$key.add($lombokEntry.getKey());
                this.bindingMap$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BindingTupleBuilder clearBindingMap() {
            if (this.bindingMap$key != null) {
                this.bindingMap$key.clear();
                this.bindingMap$value.clear();
            }
            return this;
        }

        public BindingTuple build() {
            Map<String, ExprValue> bindingMap;
            switch (this.bindingMap$key == null ? 0 : this.bindingMap$key.size()) {
                case 0: {
                    bindingMap = Collections.emptyMap();
                    break;
                }
                case 1: {
                    bindingMap = Collections.singletonMap(this.bindingMap$key.get(0), this.bindingMap$value.get(0));
                    break;
                }
                default: {
                    bindingMap = new LinkedHashMap<String, ExprValue>(this.bindingMap$key.size() < 0x40000000 ? 1 + this.bindingMap$key.size() + (this.bindingMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.bindingMap$key.size(); ++$i) {
                        bindingMap.put(this.bindingMap$key.get($i), this.bindingMap$value.get($i));
                    }
                    bindingMap = Collections.unmodifiableMap(bindingMap);
                }
            }
            return new BindingTuple(bindingMap);
        }

        public String toString() {
            return "BindingTuple.BindingTupleBuilder(bindingMap$key=" + this.bindingMap$key + ", bindingMap$value=" + this.bindingMap$value + ")";
        }
    }
}

