/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.util;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.RestRequest;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0000\u001a\u001e\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001e\u0010\u0015\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019*\u00020\rH\u0000\u00a8\u0006\u001a"}, d2={"buildReportLink", "", "origin", "tenant", "reportInstanceId", "logger", "Lkotlin/Lazy;", "Lorg/apache/logging/log4j/Logger;", "T", "", "forClass", "Ljava/lang/Class;", "contentParserNextToken", "Lorg/opensearch/core/xcontent/XContentParser;", "Lorg/opensearch/rest/RestRequest;", "createJsonParser", "Lorg/opensearch/core/common/io/stream/StreamInput;", "fieldIfNotNull", "Lorg/opensearch/core/xcontent/XContentBuilder;", "name", "value", "objectIfNotNull", "xContentObject", "Lorg/opensearch/core/xcontent/ToXContentObject;", "stringList", "", "opensearch-reports-scheduler"})
public final class HelpersKt {
    @NotNull
    public static final XContentParser createJsonParser(@NotNull StreamInput $this$createJsonParser) {
        Intrinsics.checkNotNullParameter((Object)$this$createJsonParser, (String)"<this>");
        XContentParser xContentParser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, (InputStream)$this$createJsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"JSON.xContent().createPa\u2026GNORE_DEPRECATIONS, this)");
        return xContentParser;
    }

    @NotNull
    public static final XContentParser contentParserNextToken(@NotNull RestRequest $this$contentParserNextToken) {
        Intrinsics.checkNotNullParameter((Object)$this$contentParserNextToken, (String)"<this>");
        XContentParser parser = $this$contentParserNextToken.contentParser();
        parser.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
        return parser;
    }

    @NotNull
    public static final List<String> stringList(@NotNull XContentParser $this$stringList) {
        Intrinsics.checkNotNullParameter((Object)$this$stringList, (String)"<this>");
        List retList = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)$this$stringList.currentToken(), (XContentParser)$this$stringList);
        while ($this$stringList.nextToken() != XContentParser.Token.END_ARRAY) {
            String string = $this$stringList.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text()");
            retList.add(string);
        }
        return retList;
    }

    @NotNull
    public static final <T> Lazy<Logger> logger(@NotNull Class<T> forClass) {
        Intrinsics.checkNotNullParameter(forClass, (String)"forClass");
        return LazyKt.lazy((Function0)((Function0)new Function0<Logger>(forClass){
            final /* synthetic */ Class<T> $forClass;
            {
                this.$forClass = $forClass;
                super(0);
            }

            public final Logger invoke() {
                return LogManager.getLogger(this.$forClass);
            }
        }));
    }

    @NotNull
    public static final XContentBuilder fieldIfNotNull(@NotNull XContentBuilder $this$fieldIfNotNull, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$fieldIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            $this$fieldIfNotNull.field(name, value);
        }
        return $this$fieldIfNotNull;
    }

    @NotNull
    public static final XContentBuilder objectIfNotNull(@NotNull XContentBuilder $this$objectIfNotNull, @NotNull String name, @Nullable ToXContentObject xContentObject) {
        Intrinsics.checkNotNullParameter((Object)$this$objectIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (xContentObject != null) {
            $this$objectIfNotNull.field(name);
            xContentObject.toXContent($this$objectIfNotNull, ToXContent.EMPTY_PARAMS);
        }
        return $this$objectIfNotNull;
    }

    @NotNull
    public static final String buildReportLink(@NotNull String origin, @NotNull String tenant, @NotNull String reportInstanceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)reportInstanceId, (String)"reportInstanceId");
        String tenantValueInUrl = tenant;
        String string2 = tenant;
        if (Intrinsics.areEqual((Object)string2, (Object)"__user__")) {
            string = "private";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"")) {
            string = "global";
        } else {
            String string3 = new URI(null, null, tenantValueInUrl, null).getRawPath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"URI(null, null, tenantValueInUrl, null).rawPath");
        }
        tenantValueInUrl = string;
        return origin + "/app/reports-dashboards?security_tenant=" + tenantValueInUrl + "#/report_details/" + reportInstanceId;
    }
}

