/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api;

import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.SymptomFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public abstract class Symptom
extends NonLeafNode<SymptomFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(Symptom.class);

    public Symptom(long evaluationIntervalSeconds) {
        super(0, evaluationIntervalSeconds);
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        SymptomFlowUnit result;
        LOG.debug("rca: Executing handleRca: {}", (Object)this.getClass().getSimpleName());
        long startTime = System.currentTimeMillis();
        try {
            result = (SymptomFlowUnit)this.operate();
        }
        catch (Exception ex) {
            ServiceMetrics.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), (Number)1);
            LOG.error("Exception caught during operate", (Throwable)ex);
            result = SymptomFlowUnit.generic();
        }
        long endTime = System.currentTimeMillis();
        long durationMillis = endTime - startTime;
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), (Number)durationMillis);
        this.setFlowUnits(Collections.singletonList(result));
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(SymptomFlowUnit.generic());
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }
}

