/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree.impl;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class IntArrayContainer {
    private static final Logger logger = Logger.getLogger(IntArrayContainer.class.getName());
    public int[] array;
    public int size;

    public IntArrayContainer(int initialCapacity) {
        this.array = new int[initialCapacity];
        this.size = 0;
    }

    public void grow(int requestedSize) {
        if (requestedSize > this.array.length) {
            int oldCapacity = this.array.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - requestedSize < 0) {
                newCapacity = requestedSize;
            }
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    public int[] copy() {
        return Arrays.copyOf(this.array, this.size);
    }

    public void fill(int[] otherArray) {
        if (otherArray.length > this.array.length) {
            this.array = Arrays.copyOf(otherArray, otherArray.length);
        } else {
            System.arraycopy(otherArray, 0, this.array, 0, otherArray.length);
        }
        this.size = otherArray.length;
    }

    public void fill(IntArrayContainer other) {
        if (other.array.length > this.array.length) {
            this.array = Arrays.copyOf(other.array, other.size);
        } else {
            System.arraycopy(other.array, 0, this.array, 0, other.size);
        }
        this.size = other.size;
    }

    public static void removeOther(IntArrayContainer input, int[] otherArray, IntArrayContainer output) {
        int newSize = input.size - otherArray.length;
        if (newSize > output.array.length) {
            output.grow(newSize);
        }
        int[] inputArray = input.array;
        int inputSize = input.size;
        int[] outputArray = output.array;
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < inputSize) {
            if (j == otherArray.length) {
                outputArray[k] = inputArray[i];
                ++i;
                ++k;
                continue;
            }
            if (inputArray[i] < otherArray[j]) {
                outputArray[k] = inputArray[i];
                ++i;
                ++k;
                continue;
            }
            if (inputArray[i] == otherArray[j]) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        output.size = k;
        assert (k == newSize);
    }

    public static int[] merge(List<int[]> input, IntArrayContainer firstBuffer, IntArrayContainer secondBuffer) {
        if (input.size() > 0) {
            firstBuffer.fill(input.get(0));
            for (int i = 0; i < input.size(); ++i) {
                IntArrayContainer.merge(firstBuffer, input.get(i), secondBuffer);
                IntArrayContainer tmp = secondBuffer;
                secondBuffer = firstBuffer;
                firstBuffer = tmp;
            }
            return firstBuffer.copy();
        }
        return new int[0];
    }

    public static void merge(IntArrayContainer input, int[] otherArray, IntArrayContainer output) {
        int newSize = input.size + otherArray.length;
        if (newSize > output.array.length) {
            output.grow(newSize);
        }
        int[] inputArray = input.array;
        int inputSize = input.size;
        int[] outputArray = output.array;
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < inputSize || j < otherArray.length) {
            if (i == inputSize) {
                outputArray[k] = otherArray[j];
                ++j;
                ++k;
                continue;
            }
            if (j == otherArray.length) {
                outputArray[k] = inputArray[i];
                ++i;
                ++k;
                continue;
            }
            if (inputArray[i] < otherArray[j]) {
                outputArray[k] = inputArray[i];
                ++i;
                ++k;
                continue;
            }
            outputArray[k] = otherArray[j];
            ++j;
            ++k;
        }
        output.size = k;
        assert (k == newSize);
    }
}

