/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.BaseModelConfig;

public class TextEmbeddingModelConfig
extends BaseModelConfig {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(TextEmbeddingModelConfig.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> TextEmbeddingModelConfig.parse(it));
    public static final String EMBEDDING_DIMENSION_FIELD = "embedding_dimension";
    public static final String FRAMEWORK_TYPE_FIELD = "framework_type";
    public static final String POOLING_MODE_FIELD = "pooling_mode";
    public static final String NORMALIZE_RESULT_FIELD = "normalize_result";
    public static final String MODEL_MAX_LENGTH_FIELD = "model_max_length";
    public static final String QUERY_PREFIX = "query_prefix";
    public static final String PASSAGE_PREFIX = "passage_prefix";
    private final Integer embeddingDimension;
    private final FrameworkType frameworkType;
    private final PoolingMode poolingMode;
    private final boolean normalizeResult;
    private final Integer modelMaxLength;
    private final String queryPrefix;
    private final String passagePrefix;

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, FrameworkType frameworkType, String allConfig, Map<String, Object> additionalConfig, PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength) {
        this(modelType, embeddingDimension, frameworkType, allConfig, additionalConfig, poolingMode, normalizeResult, modelMaxLength, null, null);
    }

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, FrameworkType frameworkType, String allConfig, Map<String, Object> additionalConfig, PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength, String queryPrefix, String passagePrefix) {
        super(modelType, allConfig, additionalConfig);
        if (embeddingDimension == null) {
            throw new IllegalArgumentException("embedding dimension is null");
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException("framework type is null");
        }
        this.validateNoDuplicateKeys(allConfig, additionalConfig);
        this.embeddingDimension = embeddingDimension;
        this.frameworkType = frameworkType;
        this.poolingMode = poolingMode;
        this.normalizeResult = normalizeResult;
        this.modelMaxLength = modelMaxLength;
        this.queryPrefix = queryPrefix;
        this.passagePrefix = passagePrefix;
    }

    public static TextEmbeddingModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        Integer embeddingDimension = null;
        FrameworkType frameworkType = null;
        String allConfig = null;
        Map additionalConfig = null;
        PoolingMode poolingMode = null;
        boolean normalizeResult = false;
        Integer modelMaxLength = null;
        String queryPrefix = null;
        String passagePrefix = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block24;
                }
                case "embedding_dimension": {
                    embeddingDimension = parser.intValue();
                    continue block24;
                }
                case "framework_type": {
                    frameworkType = FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block24;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block24;
                }
                case "additional_config": {
                    additionalConfig = parser.map();
                    continue block24;
                }
                case "pooling_mode": {
                    poolingMode = PoolingMode.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block24;
                }
                case "normalize_result": {
                    normalizeResult = parser.booleanValue();
                    continue block24;
                }
                case "model_max_length": {
                    modelMaxLength = parser.intValue();
                    continue block24;
                }
                case "query_prefix": {
                    queryPrefix = parser.text();
                    continue block24;
                }
                case "passage_prefix": {
                    passagePrefix = parser.text();
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return new TextEmbeddingModelConfig(modelType, embeddingDimension, frameworkType, allConfig, additionalConfig, poolingMode, normalizeResult, modelMaxLength, queryPrefix, passagePrefix);
    }

    @Override
    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public TextEmbeddingModelConfig(StreamInput in) throws IOException {
        super(in);
        this.embeddingDimension = in.readInt();
        this.frameworkType = (FrameworkType)in.readEnum(FrameworkType.class);
        this.poolingMode = in.readBoolean() ? (PoolingMode)in.readEnum(PoolingMode.class) : null;
        this.normalizeResult = in.readBoolean();
        this.modelMaxLength = in.readOptionalInt();
        this.queryPrefix = in.readOptionalString();
        this.passagePrefix = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.embeddingDimension.intValue());
        out.writeEnum((Enum)this.frameworkType);
        if (this.poolingMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.poolingMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.normalizeResult);
        out.writeOptionalInt(this.modelMaxLength);
        out.writeOptionalString(this.queryPrefix);
        out.writeOptionalString(this.passagePrefix);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.embeddingDimension != null) {
            builder.field(EMBEDDING_DIMENSION_FIELD, this.embeddingDimension);
        }
        if (this.frameworkType != null) {
            builder.field(FRAMEWORK_TYPE_FIELD, (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.additionalConfig != null) {
            builder.field("additional_config", this.additionalConfig);
        }
        if (this.modelMaxLength != null) {
            builder.field(MODEL_MAX_LENGTH_FIELD, this.modelMaxLength);
        }
        if (this.poolingMode != null) {
            builder.field(POOLING_MODE_FIELD, (Object)this.poolingMode);
        }
        if (this.normalizeResult) {
            builder.field(NORMALIZE_RESULT_FIELD, this.normalizeResult);
        }
        if (this.queryPrefix != null) {
            builder.field(QUERY_PREFIX, this.queryPrefix);
        }
        if (this.passagePrefix != null) {
            builder.field(PASSAGE_PREFIX, this.passagePrefix);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static TextEmbeddingModelConfigBuilder builder() {
        return new TextEmbeddingModelConfigBuilder();
    }

    @Generated
    public TextEmbeddingModelConfigBuilder toBuilder() {
        return new TextEmbeddingModelConfigBuilder().modelType(this.modelType).embeddingDimension(this.embeddingDimension).frameworkType(this.frameworkType).allConfig(this.allConfig).additionalConfig(this.additionalConfig).poolingMode(this.poolingMode).normalizeResult(this.normalizeResult).modelMaxLength(this.modelMaxLength).queryPrefix(this.queryPrefix).passagePrefix(this.passagePrefix);
    }

    @Generated
    public Integer getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    @Generated
    public FrameworkType getFrameworkType() {
        return this.frameworkType;
    }

    @Generated
    public PoolingMode getPoolingMode() {
        return this.poolingMode;
    }

    @Generated
    public boolean isNormalizeResult() {
        return this.normalizeResult;
    }

    @Generated
    public Integer getModelMaxLength() {
        return this.modelMaxLength;
    }

    @Generated
    public String getQueryPrefix() {
        return this.queryPrefix;
    }

    @Generated
    public String getPassagePrefix() {
        return this.passagePrefix;
    }

    public static enum FrameworkType {
        HUGGINGFACE_TRANSFORMERS,
        SENTENCE_TRANSFORMERS,
        HUGGINGFACE_TRANSFORMERS_NEURON;


        public static FrameworkType from(String value) {
            try {
                return FrameworkType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong framework type");
            }
        }
    }

    public static enum PoolingMode {
        MEAN("mean"),
        MEAN_SQRT_LEN("mean_sqrt_len"),
        MAX("max"),
        WEIGHTED_MEAN("weightedmean"),
        CLS("cls"),
        LAST_TOKEN("lasttoken");

        private String name;

        public String getName() {
            return this.name;
        }

        private PoolingMode(String name) {
            this.name = name;
        }

        public static PoolingMode from(String value) {
            try {
                return PoolingMode.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong pooling method");
            }
        }
    }

    @Generated
    public static class TextEmbeddingModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private FrameworkType frameworkType;
        @Generated
        private String allConfig;
        @Generated
        private Map<String, Object> additionalConfig;
        @Generated
        private PoolingMode poolingMode;
        @Generated
        private boolean normalizeResult;
        @Generated
        private Integer modelMaxLength;
        @Generated
        private String queryPrefix;
        @Generated
        private String passagePrefix;

        @Generated
        TextEmbeddingModelConfigBuilder() {
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder embeddingDimension(Integer embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder frameworkType(FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder additionalConfig(Map<String, Object> additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder poolingMode(PoolingMode poolingMode) {
            this.poolingMode = poolingMode;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder normalizeResult(boolean normalizeResult) {
            this.normalizeResult = normalizeResult;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelMaxLength(Integer modelMaxLength) {
            this.modelMaxLength = modelMaxLength;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder queryPrefix(String queryPrefix) {
            this.queryPrefix = queryPrefix;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder passagePrefix(String passagePrefix) {
            this.passagePrefix = passagePrefix;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfig build() {
            return new TextEmbeddingModelConfig(this.modelType, this.embeddingDimension, this.frameworkType, this.allConfig, this.additionalConfig, this.poolingMode, this.normalizeResult, this.modelMaxLength, this.queryPrefix, this.passagePrefix);
        }

        @Generated
        public String toString() {
            return "TextEmbeddingModelConfig.TextEmbeddingModelConfigBuilder(modelType=" + this.modelType + ", embeddingDimension=" + this.embeddingDimension + ", frameworkType=" + String.valueOf((Object)this.frameworkType) + ", allConfig=" + this.allConfig + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ", poolingMode=" + String.valueOf((Object)this.poolingMode) + ", normalizeResult=" + this.normalizeResult + ", modelMaxLength=" + this.modelMaxLength + ", queryPrefix=" + this.queryPrefix + ", passagePrefix=" + this.passagePrefix + ")";
        }
    }
}

