/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskResponse;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;
import org.opensearch.ml.repackage.com.google.common.collect.ImmutableList;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.ml.utils.error.ErrorMessage;
import org.opensearch.ml.utils.error.ErrorMessageFactory;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLExecuteAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLExecuteAction.class);
    private static final String ML_EXECUTE_ACTION = "ml_execute_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLExecuteAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_EXECUTE_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_execute/{%s}", "/_plugins/_ml", "algorithm")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/agents/{%s}/_execute", "/_plugins/_ml", "agent_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLExecuteTaskRequest mlExecuteTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)mlExecuteTaskRequest, (ActionListener)new ActionListener<MLExecuteTaskResponse>(){

            public void onResponse(MLExecuteTaskResponse response) {
                try {
                    RestMLExecuteAction.this.sendResponse(channel, response);
                }
                catch (Exception e) {
                    RestMLExecuteAction.this.reportError(channel, e, RestStatus.INTERNAL_SERVER_ERROR);
                }
            }

            public void onFailure(Exception e) {
                RestStatus status = RestMLExecuteAction.this.isClientError(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                RestMLExecuteAction.this.reportError(channel, e, status);
            }
        });
    }

    @VisibleForTesting
    MLExecuteTaskRequest getRequest(RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        boolean async = RestActionUtils.isAsync(request);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String uri = request.getHttpRequest().uri();
        FunctionName functionName = null;
        Input input = null;
        if (uri.startsWith("/_plugins/_ml/agents/")) {
            if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
                throw new IllegalStateException("Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.");
            }
            String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
            String agentId = request.param("agent_id");
            functionName = FunctionName.AGENT;
            input = MLInput.parse((XContentParser)parser, (String)functionName.name());
            ((AgentMLInput)input).setAgentId(agentId);
            ((AgentMLInput)input).setTenantId(tenantId);
            ((AgentMLInput)input).setIsAsync(Boolean.valueOf(async));
        } else {
            String algorithm = RestActionUtils.getAlgorithm(request).toUpperCase(Locale.ROOT);
            functionName = FunctionName.from((String)algorithm);
            input = (Input)parser.namedObject(Input.class, functionName.name(), null);
        }
        return new MLExecuteTaskRequest(functionName, input);
    }

    private void sendResponse(RestChannel channel, MLExecuteTaskResponse response) throws Exception {
        channel.sendResponse(new RestToXContentListener(channel).buildResponse((ToXContentObject)response));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        ErrorMessage errorMessage = ErrorMessageFactory.createErrorMessage(e, status.getStatus());
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field("status", errorMessage.getStatus());
            builder.startObject("error");
            builder.field("type", errorMessage.getType());
            builder.field("reason", errorMessage.getReason());
            builder.field("details", errorMessage.getDetails());
            builder.endObject();
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.fromCode((int)errorMessage.getStatus()), builder));
        }
        catch (Exception exception) {
            log.error("Failed to build xContent for an error response, so reply with a plain string.", (Throwable)exception);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.fromCode((int)errorMessage.getStatus()), errorMessage.toString()));
        }
    }

    private boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalAccessException;
    }
}

