/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.util.IndexUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/ControlCenterIndices;", "", "client", "Lorg/opensearch/client/IndicesAdminClient;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/client/IndicesAdminClient;Lorg/opensearch/cluster/service/ClusterService;)V", "checkAndUpdateControlCenterIndex", "", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "controlCenterIndexExists", "", "Companion", "opensearch-index-management"})
public final class ControlCenterIndices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesAdminClient client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private static final String controlCenterMappings;

    public ControlCenterIndices(@NotNull IndicesAdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
    }

    public final void checkAndUpdateControlCenterIndex(@NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.controlCenterIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opensearch-control-center").mapping(controlCenterMappings).settings(Settings.builder().put("index.hidden", true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(actionListener){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                {
                    this.$actionListener = $actionListener;
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        this.$actionListener.onResponse((Object)new CreateIndexResponse(true, true, ".opensearch-control-center"));
                    } else {
                        this.$actionListener.onFailure(e);
                    }
                }

                public void onResponse(@NotNull CreateIndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }
            });
        } else {
            long l = IndexUtils.Companion.getSchemaVersion(controlCenterMappings);
            ClusterState clusterState = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
            IndexUtils.Companion.checkAndUpdateIndexMapping(".opensearch-control-center", l, controlCenterMappings, clusterState, this.client, actionListener);
        }
    }

    private final boolean controlCenterIndexExists() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opensearch-control-center");
    }

    static {
        URL uRL = ControlCenterIndices.class.getClassLoader().getResource("mappings/opensearch-control-center.json");
        Intrinsics.checkNotNull((Object)uRL);
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        controlCenterMappings = new String(byArray, charset);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/ControlCenterIndices$Companion;", "", "()V", "controlCenterMappings", "", "getControlCenterMappings", "()Ljava/lang/String;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getControlCenterMappings() {
            return controlCenterMappings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

