/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.cal;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.Credentials;

public final class EccKeyPair
extends CrtResource {
    private EccKeyPair(long nativeHandle) {
        this.acquireNativeHandle(nativeHandle);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            EccKeyPair.eccKeyPairRelease(this.getNativeHandle());
        }
    }

    public static EccKeyPair newDeriveFromCredentials(Credentials credentials, AwsEccCurve curve) {
        long nativeHandle = EccKeyPair.eccKeyPairNewFromCredentials(credentials, curve.getNativeValue());
        if (nativeHandle != 0L) {
            return new EccKeyPair(nativeHandle);
        }
        return null;
    }

    public byte[] signMessage(byte[] message) {
        return EccKeyPair.eccKeyPairSignMessage(this.getNativeHandle(), message);
    }

    private static native long eccKeyPairNewFromCredentials(Credentials var0, int var1);

    private static native void eccKeyPairRelease(long var0);

    private static native byte[] eccKeyPairSignMessage(long var0, byte[] var2);

    public static enum AwsEccCurve {
        AWS_ECDSA_P256(0),
        AWS_ECDSA_P384(1);

        private int nativeValue;
        private static Map<Integer, AwsEccCurve> enumMapping;

        private AwsEccCurve(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsEccCurve getEnumValueFromInteger(int value) {
            AwsEccCurve enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal ecc curve name value");
        }

        private static Map<Integer, AwsEccCurve> buildEnumMapping() {
            HashMap<Integer, AwsEccCurve> enumMapping = new HashMap<Integer, AwsEccCurve>();
            enumMapping.put(AWS_ECDSA_P256.getNativeValue(), AWS_ECDSA_P256);
            enumMapping.put(AWS_ECDSA_P384.getNativeValue(), AWS_ECDSA_P384);
            return enumMapping;
        }

        static {
            enumMapping = AwsEccCurve.buildEnumMapping();
        }
    }
}

