/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CoipPool;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;

public class DescribeCoipPoolsIterable
implements SdkIterable<DescribeCoipPoolsResponse> {
    private final Ec2Client client;
    private final DescribeCoipPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCoipPoolsIterable(Ec2Client client, DescribeCoipPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCoipPoolsResponseFetcher();
    }

    public Iterator<DescribeCoipPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoipPool> coipPools() {
        Function<DescribeCoipPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coipPools() != null) {
                return response.coipPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCoipPoolsResponseFetcher
    implements SyncPageFetcher<DescribeCoipPoolsResponse> {
        private DescribeCoipPoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCoipPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCoipPoolsResponse nextPage(DescribeCoipPoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCoipPoolsIterable.this.client.describeCoipPools(DescribeCoipPoolsIterable.this.firstRequest);
            }
            return DescribeCoipPoolsIterable.this.client.describeCoipPools((DescribeCoipPoolsRequest)((Object)DescribeCoipPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

