"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRONG_THROTTLE_WARNING = exports.URL = exports.PLUGIN_NAME = exports.OPEN_SEARCH_PREFIX = exports.MAX_THROTTLE_VALUE = exports.INDEX_PREFIX = exports.INDEX = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Keeping index prefix as 'opendistro' as migrating the system index is currently difficult to complete
const OPEN_SEARCH_PREFIX = 'opendistro';
exports.OPEN_SEARCH_PREFIX = OPEN_SEARCH_PREFIX;
const PLUGIN_NAME = `alerting`;
exports.PLUGIN_NAME = PLUGIN_NAME;
const INDEX_PREFIX = `${OPEN_SEARCH_PREFIX}-alerting`;
exports.INDEX_PREFIX = INDEX_PREFIX;
const INDEX = {
  SCHEDULED_JOBS: `.${INDEX_PREFIX}-config`,
  ALERTS: `.${INDEX_PREFIX}-alerts`,
  ALL_ALERTS: `.${INDEX_PREFIX}-alert*`,
  ALERT_HISTORY_WRITE: `.${INDEX_PREFIX}-alert-history-write`
};
exports.INDEX = INDEX;
const URL = {
  MUSTACHE: 'https://mustache.github.io/mustache.5.html',
  DOCUMENTATION: 'https://docs-beta.opensearch.org/monitoring-plugins/alerting/',
  CREATE_MONITOR_DOCUMENTATION: 'https://opensearch.org/docs/monitoring-plugins/alerting/monitors/#create-monitors'
};
exports.URL = URL;
const MAX_THROTTLE_VALUE = 1440;
exports.MAX_THROTTLE_VALUE = MAX_THROTTLE_VALUE;
const WRONG_THROTTLE_WARNING = `Throttle value must be greater than 0 and less than ${MAX_THROTTLE_VALUE}.`;
exports.WRONG_THROTTLE_WARNING = WRONG_THROTTLE_WARNING;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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