/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexCommit;
import org.opensearch.action.StepListener;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.SetOnce;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.RunUnderPrimaryPermit;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transports;

public class LocalStorePeerRecoverySourceHandler
extends RecoverySourceHandler {
    public LocalStorePeerRecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations) {
        super(shard, recoveryTarget, threadPool, request, fileChunkSizeInBytes, maxConcurrentFileChunks, maxConcurrentOperations);
    }

    @Override
    protected void innerRecoveryToTarget(ActionListener<RecoveryResponse> listener, Consumer<Exception> onFailure) throws IOException {
        long startingSeqNo;
        boolean isSequenceNumberBasedRecovery;
        SetOnce retentionLeaseRef = new SetOnce();
        RunUnderPrimaryPermit.run(() -> {
            IndexShardRoutingTable routingTable = this.shard.getReplicationGroup().getRoutingTable();
            ShardRouting targetShardRouting = routingTable.getByAllocationId(this.request.targetAllocationId());
            if (targetShardRouting == null) {
                this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", (Object)this.request.shardId(), (Object)this.request.targetNode());
                throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
            }
            assert (targetShardRouting.initializing()) : "expected recovery target to be initializing but was " + targetShardRouting;
            retentionLeaseRef.set((Object)this.shard.getRetentionLeases().get(ReplicationTracker.getPeerRecoveryRetentionLeaseId(targetShardRouting)));
        }, this.shardId + " validating recovery target [" + this.request.targetAllocationId() + "] registered ", this.shard, this.cancellableThreads, this.logger);
        Closeable retentionLock = this.shard.acquireHistoryRetentionLock();
        this.resources.add(retentionLock);
        boolean bl = isSequenceNumberBasedRecovery = this.request.startingSeqNo() != -2L && this.isTargetSameHistory() && this.shard.hasCompleteHistoryOperations("peer-recovery", this.request.startingSeqNo()) && (retentionLeaseRef.get() == null && !this.shard.useRetentionLeasesInPeerRecovery() || retentionLeaseRef.get() != null && ((RetentionLease)retentionLeaseRef.get()).retainingSequenceNumber() <= this.request.startingSeqNo());
        if (isSequenceNumberBasedRecovery && retentionLeaseRef.get() != null) {
            retentionLock.close();
            this.logger.trace("history is retained by {}", retentionLeaseRef.get());
        } else {
            this.logger.trace("history is retained by retention lock");
        }
        StepListener<RecoverySourceHandler.SendFileResult> sendFileStep = new StepListener<RecoverySourceHandler.SendFileResult>();
        StepListener<TimeValue> prepareEngineStep = new StepListener<TimeValue>();
        StepListener<RecoverySourceHandler.SendSnapshotResult> sendSnapshotStep = new StepListener<RecoverySourceHandler.SendSnapshotResult>();
        if (isSequenceNumberBasedRecovery) {
            this.logger.trace("performing sequence numbers based recovery. starting at [{}]", (Object)this.request.startingSeqNo());
            startingSeqNo = this.request.startingSeqNo();
            if (retentionLeaseRef.get() == null) {
                this.createRetentionLease(startingSeqNo, (ActionListener<RetentionLease>)ActionListener.map(sendFileStep, ignored -> RecoverySourceHandler.SendFileResult.EMPTY));
            } else {
                sendFileStep.onResponse(RecoverySourceHandler.SendFileResult.EMPTY);
            }
        } else {
            GatedCloseable<IndexCommit> wrappedSafeCommit;
            try {
                wrappedSafeCommit = this.acquireSafeCommit(this.shard);
                this.resources.add(wrappedSafeCommit);
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e);
            }
            startingSeqNo = Long.parseLong((String)wrappedSafeCommit.get().getUserData().get("local_checkpoint")) + 1L;
            this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
            try {
                int estimateNumOps = this.countNumberOfHistoryOperations(startingSeqNo);
                Releasable releaseStore = this.acquireStore(this.shard.store());
                this.resources.add(releaseStore);
                this.onSendFileStepComplete(sendFileStep, wrappedSafeCommit, releaseStore);
                StepListener deleteRetentionLeaseStep = new StepListener();
                RunUnderPrimaryPermit.run(() -> {
                    try {
                        this.shard.removePeerRecoveryRetentionLease(this.request.targetNode().getId(), new ThreadedActionListener<ReplicationResponse>(this.logger, this.shard.getThreadPool(), "generic", (ActionListener<ReplicationResponse>)deleteRetentionLeaseStep, false));
                    }
                    catch (RetentionLeaseNotFoundException e) {
                        this.logger.debug("no peer-recovery retention lease for " + this.request.targetAllocationId());
                        deleteRetentionLeaseStep.onResponse(null);
                    }
                }, this.shardId + " removing retention lease for [" + this.request.targetAllocationId() + "]", this.shard, this.cancellableThreads, this.logger);
                deleteRetentionLeaseStep.whenComplete(ignored -> {
                    this.logger.debug("deleteRetentionLeaseStep completed");
                    assert (Transports.assertNotTransportThread(this + "[phase1]"));
                    this.phase1((IndexCommit)wrappedSafeCommit.get(), startingSeqNo, () -> estimateNumOps, (ActionListener<RecoverySourceHandler.SendFileResult>)sendFileStep, false);
                }, onFailure);
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e);
            }
        }
        assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
        sendFileStep.whenComplete(r -> {
            this.logger.debug("sendFileStep completed");
            assert (Transports.assertNotTransportThread(this + "[prepareTargetForTranslog]"));
            this.prepareTargetForTranslog(this.countNumberOfHistoryOperations(startingSeqNo), (ActionListener<TimeValue>)prepareEngineStep);
        }, onFailure);
        prepareEngineStep.whenComplete(prepareEngineTime -> {
            this.logger.debug("prepareEngineStep completed");
            assert (Transports.assertNotTransportThread(this + "[phase2]"));
            RunUnderPrimaryPermit.run(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
            long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("snapshot translog for recovery; current size is [{}]", (Object)this.countNumberOfHistoryOperations(startingSeqNo));
            }
            Translog.Snapshot phase2Snapshot = this.shard.newChangesSnapshot("peer-recovery", startingSeqNo, Long.MAX_VALUE, false, true);
            this.resources.add(phase2Snapshot);
            retentionLock.close();
            long maxSeenAutoIdTimestamp = this.shard.getMaxSeenAutoIdTimestamp();
            long maxSeqNoOfUpdatesOrDeletes = this.shard.getMaxSeqNoOfUpdatesOrDeletes();
            RetentionLeases retentionLeases = this.shard.getRetentionLeases();
            long mappingVersionOnPrimary = this.shard.indexSettings().getIndexMetadata().getMappingVersion();
            this.phase2(startingSeqNo, endingSeqNo, phase2Snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, (ActionListener<RecoverySourceHandler.SendSnapshotResult>)sendSnapshotStep);
        }, onFailure);
        this.finalizeStepAndCompleteFuture(startingSeqNo, sendSnapshotStep, sendFileStep, prepareEngineStep, onFailure);
    }
}

