/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.ICUData;
import sun.text.normalizer.RangeValueIterator;
import sun.text.normalizer.TrieIterator;
import sun.text.normalizer.UCharacterPropertyReader;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeSet;
import sun.text.normalizer.VersionInfo;

public final class UCharacterProperty {
    public CharTrie m_trie_;
    public char[] m_trieIndex_;
    public char[] m_trieData_;
    public int m_trieInitialValue_;
    public VersionInfo m_unicodeVersion_;
    public static final int SRC_PROPSVEC = 2;
    public static final int SRC_COUNT = 9;
    CharTrie m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    private static UCharacterProperty INSTANCE_ = null;
    private static final String DATA_FILE_NAME_ = "/sun/text/resources/uprops.icu";
    private static final int DATA_BUFFER_SIZE_ = 25000;
    private static final int VALUE_SHIFT_ = 8;
    private static final int UNSIGNED_VALUE_MASK_AFTER_SHIFT_ = 255;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;

    public void setIndexData(CharTrie.FriendAgent friendagent) {
        this.m_trieIndex_ = friendagent.getPrivateIndex();
        this.m_trieData_ = friendagent.getPrivateData();
        this.m_trieInitialValue_ = friendagent.getPrivateInitialValue();
    }

    public final int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return this.m_trieData_[(this.m_trieIndex_[ch >> 5] << 2) + (ch & 0x1F)];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return this.m_trieInitialValue_;
            }
        }
        if (ch <= 56319) {
            return this.m_trieData_[(this.m_trieIndex_[320 + (ch >> 5)] << 2) + (ch & 0x1F)];
        }
        if (ch <= 0x10FFFF) {
            return this.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return this.m_trieInitialValue_;
    }

    public static int getUnsignedValue(int prop) {
        return prop >> 8 & 0xFF;
    }

    public int getAdditional(int codepoint, int column) {
        if (column == -1) {
            return this.getProperty(codepoint);
        }
        if (column < 0 || column >= this.m_additionalColumnsCount_) {
            return 0;
        }
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(codepoint) + column];
    }

    public VersionInfo getAge(int codepoint) {
        int version = this.getAdditional(codepoint, 0) >> 24;
        return VersionInfo.getInstance(version >> 4 & 0xF, version & 0xF, 0, 0);
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public static UCharacterProperty getInstance() {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception e) {
                throw new MissingResourceException(e.getMessage(), "", "");
            }
        }
        return INSTANCE_;
    }

    public static boolean isRuleWhiteSpace(int c) {
        return c >= 9 && c <= 8233 && (c <= 13 || c == 32 || c == 133 || c == 8206 || c == 8207 || c >= 8232);
    }

    private UCharacterProperty() throws IOException {
        InputStream is = ICUData.getRequiredStream(DATA_FILE_NAME_);
        BufferedInputStream b = new BufferedInputStream(is, 25000);
        UCharacterPropertyReader reader = new UCharacterPropertyReader(b);
        reader.read(this);
        b.close();
        this.m_trie_.putIndexData(this);
    }

    public void upropsvec_addPropertyStarts(UnicodeSet set) {
        if (this.m_additionalColumnsCount_ > 0) {
            TrieIterator propsVectorsIter = new TrieIterator(this.m_additionalTrie_);
            RangeValueIterator.Element propsVectorsResult = new RangeValueIterator.Element();
            while (propsVectorsIter.next(propsVectorsResult)) {
                set.add(propsVectorsResult.start);
            }
        }
    }
}

