/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.Command;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.olc.OlcArea;
import tim.prune.function.olc.OlcDecoder;
import tim.prune.function.olc.OlcField;
import tim.prune.gui.GuiGridLayout;

public class PlusCodeFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private OlcField _codeField = null;
    private JButton _okButton = null;

    public PlusCodeFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.enterpluscode";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._codeField.setText("");
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pluscode.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._codeField = new OlcField();
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PlusCodeFunction.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    PlusCodeFunction.this._dialog.dispose();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlusCodeFunction.this.enableOK();
            }
        };
        this._codeField.addKeyListener(keyAdapter);
        this._codeField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.pluscode.code"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._codeField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> {
            if (this._okButton.isEnabled()) {
                this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        this._codeField.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        String string = this._codeField.getText().trim();
        this._okButton.setEnabled(OlcDecoder.isValidLongForm(string) || OlcDecoder.isValidShortForm(string));
    }

    private void finish() {
        OlcArea olcArea = OlcDecoder.decode(this._codeField.getText(), this._app.getViewport().getCentreLatitude(), this._app.getViewport().getCentreLongitude());
        if (olcArea == null) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.pluscode.nothingfound"), this.getName(), 0);
        } else if (this.loadTrack(olcArea)) {
            this._dialog.dispose();
        }
    }

    private boolean loadTrack(OlcArea olcArea) {
        Object object;
        if (olcArea == null) {
            return false;
        }
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        if (olcArea.minLat == olcArea.maxLat && olcArea.minLon == olcArea.maxLon) {
            object = new DataPoint(new Latitude("" + olcArea.minLat), new Longitude("" + olcArea.minLon), null);
            ((DataPoint)object).setFieldValue(Field.WAYPT_NAME, olcArea.code, false);
            arrayList.add((DataPoint)object);
        } else {
            Object object2;
            Coordinate coordinate;
            int n = 0;
            while (n < 5) {
                coordinate = new Latitude("" + (n % 4 == 0 || n == 3 ? olcArea.minLat : olcArea.maxLat));
                object2 = new Longitude("" + (n % 4 == 0 || n == 1 ? olcArea.minLon : olcArea.maxLon));
                DataPoint dataPoint = new DataPoint(coordinate, (Coordinate)object2, null);
                dataPoint.setSegmentStart(n == 0);
                arrayList.add(dataPoint);
                ++n;
            }
            object = new Latitude("" + (olcArea.minLat + olcArea.maxLat) / 2.0);
            coordinate = new Longitude("" + (olcArea.minLon + olcArea.maxLon) / 2.0);
            object2 = new DataPoint((Coordinate)object, coordinate, null);
            ((DataPoint)object2).setFieldValue(Field.WAYPT_NAME, olcArea.code, false);
            arrayList.add((DataPoint)object2);
        }
        object = new AppendRangeCmd(arrayList);
        ((Command)object).setDescription(this.getName());
        ((Command)object).setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", arrayList.size()));
        return this._app.execute((Command)object);
    }
}

