/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.explorer.AliasEqualsCondition;
import org.freeplane.features.explorer.AliasExistsCondition;
import org.freeplane.features.explorer.AliasStartsWithCondition;
import org.freeplane.features.explorer.GlobalNodeCondition;
import org.freeplane.features.explorer.NodeAlias;
import org.freeplane.features.explorer.NodeAliases;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

public class MapExplorerConditionController
implements IElementaryConditionController {
    private final String FILTER_GLOBAL = "filter_global";
    static final String FILTER_ALIAS = "filter_alias";
    private final ExtendedComboBoxModel values = new ExtendedComboBoxModel();

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return this.canSelectValues(property, simpleCond);
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals("filter_global") || namedObject.objectEquals(FILTER_ALIAS);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return ((TranslatedObject)property).objectEquals(FILTER_ALIAS) && !simpleCond.objectEquals("filter_exist");
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        if (namedObject.objectEquals("filter_global")) {
            return new GlobalNodeCondition();
        }
        if (namedObject.objectEquals(FILTER_ALIAS)) {
            if (simpleCond.objectEquals("filter_is_equal_to")) {
                return new AliasEqualsCondition((String)value, matchCase, matchApproximately, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_starts_with")) {
                return new AliasStartsWithCondition((String)value, matchCase, matchApproximately, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_exist")) {
                return new AliasExistsCondition();
            }
            return null;
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        TranslatedObject[] conditions;
        TranslatedObject no = (TranslatedObject)property;
        if (no.getObject().equals("filter_global")) {
            conditions = new TranslatedObject[]{TranslatedObject.literal("")};
        } else if (no.getObject().equals(FILTER_ALIAS)) {
            conditions = new TranslatedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_starts_with"), TextUtils.createTranslatedString("filter_exist")};
        } else {
            throw new IllegalArgumentException();
        }
        return new DefaultComboBoxModel<TranslatedObject>(conditions);
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_ALIAS));
        list.addElement(TextUtils.createTranslatedString("filter_global"));
        return list;
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return new FixedBasicComboBoxEditor();
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object selectedItem, TranslatedObject simpleCond) {
        if (this.canSelectValues(selectedItem, simpleCond)) {
            this.values.setExtensionList(this.aliases());
        } else {
            this.values.setExtensionList(null);
        }
        return this.values;
    }

    private SortedComboBoxModel aliases() {
        MapModel map = Controller.getCurrentController().getMap();
        Collection<NodeAlias> aliases = NodeAliases.of(map).aliases();
        SortedComboBoxModel box = new SortedComboBoxModel();
        for (NodeAlias a : aliases) {
            box.add(a.value);
        }
        return box;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("alias_equals")) {
            String target = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            return new AliasEqualsCondition(target, matchCase, matchApproximately, Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("alias_starts_with")) {
            String target = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            return new AliasStartsWithCondition(target, matchCase, matchApproximately, Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("alias_exists")) {
            return new AliasExistsCondition();
        }
        if (element.getName().equalsIgnoreCase("filter_global")) {
            return new GlobalNodeCondition();
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        if (((TranslatedObject)selectedProperty).objectEquals("filter_global") || ((TranslatedObject)selectedProperty).objectEquals(FILTER_ALIAS) && selectedCondition.objectEquals("filter_exist")) {
            return new DefaultConditionRenderer("", true);
        }
        return null;
    }

    public static void installFilterConditions() {
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(100, new MapExplorerConditionController());
    }
}

