/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class MissionaryMessage
extends AttributeMessage {
    public static final String TAG = "missionary";
    private static final String DENOUNCE_TAG = "denounce";
    private static final String DIRECTION_TAG = "direction";
    private static final String UNIT_TAG = "unit";

    public MissionaryMessage(Unit unit, Direction direction, boolean denounce) {
        super(TAG, UNIT_TAG, unit.getId(), DIRECTION_TAG, String.valueOf(direction), DENOUNCE_TAG, String.valueOf(denounce));
    }

    public MissionaryMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DIRECTION_TAG, DENOUNCE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit.MoveType type;
        Tile tile;
        ServerUnit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String directionString = this.getStringAttribute(DIRECTION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(directionString);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return serverPlayer.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit missionary = is.getMissionary();
        boolean denounce = this.getBooleanAttribute(DENOUNCE_TAG, Boolean.FALSE);
        if (denounce) {
            if (missionary == null) {
                return serverPlayer.clientError("Denouncing an empty mission at: " + is.getId());
            }
            if (missionary.getOwner() == serverPlayer) {
                return serverPlayer.clientError("Denouncing our own missionary at: " + is.getId());
            }
            if (!unit.hasAbility("model.ability.denounceHeresy")) {
                return serverPlayer.clientError("Unit lacks denouncement ability: " + unitId);
            }
        } else {
            if (missionary != null) {
                return serverPlayer.clientError("Establishing extra mission at: " + is.getId());
            }
            if (!unit.hasAbility("model.ability.establishMission")) {
                return serverPlayer.clientError("Unit lacks establish mission ability: " + unitId);
            }
        }
        if ((type = unit.getMoveType(is.getTile())) != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return serverPlayer.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return denounce ? this.igc(freeColServer).denounceMission(serverPlayer, unit, is) : this.igc(freeColServer).establishMission(serverPlayer, unit, is);
    }
}

