/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnaryExpression
extends OperatorExpression {
    public Expression expression;
    public Constant optimizedBooleanConstant;

    public UnaryExpression(Expression expression, int n) {
        this.expression = expression;
        this.bits |= n << 8;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0x3F00) >> 8 == 11) {
            flowContext.tagBits ^= 4;
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
            flowContext.tagBits ^= 4;
        } else {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
        }
        this.expression.checkNPE(blockScope, flowContext, flowInfo);
        return flowInfo;
    }

    @Override
    protected void updateFlowOnBooleanResult(FlowInfo flowInfo, boolean bl) {
        if ((this.bits & 0x3F00) >> 8 == 11) {
            this.expression.updateFlowOnBooleanResult(flowInfo, !bl);
        }
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        switch ((this.bits & 0x3F00) >> 8) {
            case 11: {
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 5: {
                        BranchLabel branchLabel = new BranchLabel(codeStream);
                        this.expression.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel, bl);
                        if (bl) {
                            codeStream.iconst_0();
                            if (branchLabel.forwardReferenceCount() <= 0) break;
                            BranchLabel branchLabel2 = new BranchLabel(codeStream);
                            codeStream.goto_(branchLabel2);
                            codeStream.decrStackSize(1);
                            branchLabel.place();
                            codeStream.iconst_1();
                            branchLabel2.place();
                            break;
                        }
                        branchLabel.place();
                    }
                }
                break;
            }
            case 12: {
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        this.expression.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.iconst_m1();
                        codeStream.ixor();
                        break;
                    }
                    case 7: {
                        this.expression.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ldc2_w(-1L);
                        codeStream.lxor();
                    }
                }
                break;
            }
            case 13: {
                if (this.constant != Constant.NotAConstant) {
                    if (!bl) break;
                    switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                        case 10: {
                            codeStream.generateInlinedValue(this.constant.intValue() * -1);
                            break;
                        }
                        case 9: {
                            codeStream.generateInlinedValue(this.constant.floatValue() * -1.0f);
                            break;
                        }
                        case 7: {
                            codeStream.generateInlinedValue(this.constant.longValue() * -1L);
                            break;
                        }
                        case 8: {
                            codeStream.generateInlinedValue(this.constant.doubleValue() * -1.0);
                        }
                    }
                    break;
                }
                this.expression.generateCode(blockScope, codeStream, bl);
                if (!bl) break;
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.ineg();
                        break;
                    }
                    case 9: {
                        codeStream.fneg();
                        break;
                    }
                    case 7: {
                        codeStream.lneg();
                        break;
                    }
                    case 8: {
                        codeStream.dneg();
                    }
                }
                break;
            }
            case 14: {
                this.expression.generateCode(blockScope, codeStream, bl);
            }
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            return;
        }
        if ((this.bits & 0x3F00) >> 8 == 11) {
            this.expression.generateOptimizedBoolean(blockScope, codeStream, branchLabel2, branchLabel, bl);
        } else {
            super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
        }
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        this.expression.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
        if ((this.bits & 0x3F00) >> 8 == 11) {
            localVariableBindingArray = this.expression.getPatternVariablesWhenTrue();
            if (localVariableBindingArray != null) {
                this.addPatternVariablesWhenFalse(localVariableBindingArray);
            }
            if ((localVariableBindingArray = this.expression.getPatternVariablesWhenFalse()) != null) {
                this.addPatternVariablesWhenTrue(localVariableBindingArray);
            }
        } else {
            localVariableBindingArray = this.expression.getPatternVariablesWhenTrue();
            this.addPatternVariablesWhenTrue(localVariableBindingArray);
            localVariableBindingArray = this.expression.getPatternVariablesWhenFalse();
            this.addPatternVariablesWhenFalse(localVariableBindingArray);
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        boolean bl;
        TypeBinding typeBinding;
        boolean bl2 = this.expression instanceof CastExpression;
        if (bl2) {
            this.expression.bits |= 0x20;
        }
        if ((typeBinding = this.expression.resolveType(blockScope)) == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int n2 = typeBinding.id;
        boolean bl3 = bl = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        if (bl && !typeBinding.isBaseType()) {
            n2 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id;
        }
        if (n2 > 15) {
            this.constant = Constant.NotAConstant;
            blockScope.problemReporter().invalidOperator(this, typeBinding);
            return null;
        }
        switch ((this.bits & 0x3F00) >> 8) {
            case 11: {
                n = 0;
                break;
            }
            case 12: {
                n = 10;
                break;
            }
            default: {
                n = 13;
            }
        }
        int n3 = OperatorSignatures[n][(n2 << 4) + n2];
        this.expression.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n3 >>> 16 & 0xF), typeBinding);
        this.bits |= n3 & 0xF;
        switch (n3 & 0xF) {
            case 5: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                this.resolvedType = TypeBinding.BYTE;
                break;
            }
            case 2: {
                this.resolvedType = TypeBinding.CHAR;
                break;
            }
            case 8: {
                this.resolvedType = TypeBinding.DOUBLE;
                break;
            }
            case 9: {
                this.resolvedType = TypeBinding.FLOAT;
                break;
            }
            case 10: {
                this.resolvedType = TypeBinding.INT;
                break;
            }
            case 7: {
                this.resolvedType = TypeBinding.LONG;
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                if (n2 != 0) {
                    blockScope.problemReporter().invalidOperator(this, typeBinding);
                }
                return null;
            }
        }
        if (this.expression.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperation(this.expression.constant, n2, (this.bits & 0x3F00) >> 8);
        } else {
            Constant constant;
            this.constant = Constant.NotAConstant;
            if ((this.bits & 0x3F00) >> 8 == 11 && (constant = this.expression.optimizedBooleanConstant()) != Constant.NotAConstant) {
                this.optimizedBooleanConstant = BooleanConstant.fromValue(!constant.booleanValue());
            }
        }
        if (bl2) {
            CastExpression.checkNeedForArgumentCast(blockScope, n, n3, this.expression, n2);
        }
        return this.resolvedType;
    }

    @Override
    public boolean containsPatternVariable() {
        return this.expression.containsPatternVariable();
    }

    @Override
    public LocalDeclaration getPatternVariableIntroduced() {
        return this.expression.getPatternVariableIntroduced();
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

