/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression expression, Expression expression2, int n) {
        this.lhs = expression;
        expression.bits |= 0x2000;
        this.expression = expression2;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = n;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        VariableBinding variableBinding;
        boolean bl;
        LocalVariableBinding localVariableBinding = this.lhs.localVariableBinding();
        this.expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        UnconditionalFlowInfo unconditionalFlowInfo = null;
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        boolean bl2 = bl = localVariableBinding != null && flowInfo.reachMode() == 0 && compilerOptions.analyseResourceLeaks && (FakedTrackingVariable.isAnyCloseable(this.expression.resolvedType) || this.expression.resolvedType == TypeBinding.NULL);
        if (bl) {
            unconditionalFlowInfo = flowInfo.unconditionalCopy();
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(this, localVariableBinding, this.expression, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, false).unconditionalInits();
        if (bl) {
            FakedTrackingVariable.handleResourceAssignment(blockScope, unconditionalFlowInfo, flowInfo, flowContext, this, this.expression, localVariableBinding);
        } else {
            FakedTrackingVariable.cleanUpAfterAssignment(blockScope, this.lhs.bits, this.expression);
        }
        int n = this.expression.nullStatus(flowInfo, flowContext);
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L && n == 2) {
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.lhs, 769, flowInfo);
        }
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && (variableBinding = this.lhs.nullAnnotatedVariableBinding(compilerOptions.sourceLevel >= 0x340000L)) != null && (n = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, n, this.expression, this.expression.resolvedType)) == 4 && variableBinding instanceof FieldBinding && this.lhs instanceof Reference && compilerOptions.enableSyntacticNullAnalysisForFields) {
            int n2 = (this.bits & 0x100000) != 0 ? 2 : 1;
            flowContext.recordNullCheckedFieldReference((Reference)this.lhs, n2);
        }
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            flowInfo.markNullStatus(localVariableBinding, n);
            flowContext.markFinallyNullStatus(localVariableBinding, n);
        }
        return flowInfo;
    }

    void checkAssignment(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        FieldBinding fieldBinding = this.getLastField(this.lhs);
        if (fieldBinding != null && typeBinding2 != TypeBinding.NULL && typeBinding.kind() == 516 && ((WildcardBinding)typeBinding).boundKind != 2) {
            blockScope.problemReporter().wildcardAssignment(typeBinding, typeBinding2, this.expression);
        } else if (fieldBinding != null && !fieldBinding.isStatic() && fieldBinding.declaringClass != null && fieldBinding.declaringClass.isRawType()) {
            blockScope.problemReporter().unsafeRawFieldAssignment(fieldBinding, typeBinding2, this.lhs);
        } else if (typeBinding2.needsUncheckedConversion(typeBinding)) {
            blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding2, typeBinding);
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ((Reference)this.lhs).generateAssignment(blockScope, codeStream, this, bl);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    FieldBinding getLastField(Expression expression) {
        if (expression instanceof SingleNameReference) {
            if ((expression.bits & 7) == 1) {
                return (FieldBinding)((SingleNameReference)expression).binding;
            }
        } else {
            if (expression instanceof FieldReference) {
                return ((FieldReference)expression).binding;
            }
            if (expression instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
                if (qualifiedNameReference.otherBindings == null) {
                    if ((expression.bits & 7) == 1) {
                        return (FieldBinding)qualifiedNameReference.binding;
                    }
                } else {
                    return qualifiedNameReference.otherBindings[qualifiedNameReference.otherBindings.length - 1];
                }
            }
        }
        return null;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        return this.expression.nullStatus(flowInfo, flowContext);
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Assignment.printIndent(n, stringBuffer);
        return this.printExpressionNoParenthesis(n, stringBuffer);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        return this.printExpressionNoParenthesis(0, stringBuffer).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.lhs.printExpression(n, stringBuffer).append(" = ");
        return this.expression.printExpression(0, stringBuffer);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        LocalVariableBinding localVariableBinding;
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        this.expression.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
        this.expression.setExpectedType(typeBinding);
        if (typeBinding != null) {
            this.resolvedType = typeBinding.capture(blockScope, this.lhs.sourceStart, this.lhs.sourceEnd);
        }
        if ((localVariableBinding = this.lhs.localVariableBinding()) != null && (localVariableBinding.isCatchParameter() || localVariableBinding.isParameter())) {
            localVariableBinding.tagBits &= 0xFFFFFFFFFFFFF7FFL;
        }
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        Binding binding = Assignment.getDirectBinding(this.lhs);
        if (binding != null && !binding.isVolatile() && binding == Assignment.getDirectBinding(this.expression)) {
            blockScope.problemReporter().assignmentHasNoEffect(this, binding.shortReadableName());
        }
        if (TypeBinding.notEquals(typeBinding, typeBinding2)) {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding2);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding, blockScope)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            this.checkAssignment(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        if (this.isBoxingCompatible(typeBinding2, typeBinding, this.expression, blockScope)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.expression, (ASTNode)this.lhs);
        return typeBinding;
    }

    @Override
    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = super.resolveTypeExpecting(blockScope, typeBinding);
        if (typeBinding2 == null) {
            return null;
        }
        TypeBinding typeBinding3 = this.resolvedType;
        TypeBinding typeBinding4 = this.expression.resolvedType;
        if (TypeBinding.equalsEquals(typeBinding, TypeBinding.BOOLEAN) && TypeBinding.equalsEquals(typeBinding3, TypeBinding.BOOLEAN) && (this.lhs.bits & 0x2000) != 0) {
            blockScope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        this.checkAssignment(blockScope, typeBinding3, typeBinding4);
        return typeBinding2;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public LocalVariableBinding localVariableBinding() {
        return this.lhs.localVariableBinding();
    }

    @Override
    public boolean statementExpression() {
        return (this.bits & 0x1FE00000) == 0;
    }
}

