/* dspy-version.h.in
 *
 * Copyright 2021 Christian Hergert <chergert@redhat.com>
 *
 * This file is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTVERSIONLITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#pragma once

/**
 * SECTION:dspy-version
 * @title: Version Checking
 * @short_description: Conditionally include code based on D-Spy version
 *
 * This module provides various macros that may be used to build code based
 * on the version of D-Spy at build time.
 */

/**
 * DSPY_MAJOR_VERSION:
 *
 * D-Spy major version component (e.g. 1 if %DSPY_VERSION is 1.2.3)
 */
#define DSPY_MAJOR_VERSION (1)

/**
 * DSPY_MINOR_VERSION:
 *
 * D-Spy minor version component (e.g. 2 if %DSPY_VERSION is 1.2.3)
 */
#define DSPY_MINOR_VERSION (8)

/**
 * DSPY_MICRO_VERSION:
 *
 * D-Spy micro version component (e.g. 3 if %DSPY_VERSION is 1.2.3)
 */
#define DSPY_MICRO_VERSION (0)

/**
 * DSPY_VERSION
 *
 * D-Spy version.
 */
#define DSPY_VERSION (1.8.0)

/**
 * DSPY_VERSION_S:
 *
 * D-Spy version, encoded as a string, useful for printing and
 * concatenation.
 */
#define DSPY_VERSION_S "1.8.0"

#define DSPY_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * DSPY_VERSION_HEX:
 *
 * D-Spy version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 */
#define DSPY_VERSION_HEX \
        (DSPY_ENCODE_VERSION (DSPY_MAJOR_VERSION, DSPY_MINOR_VERSION, DSPY_MICRO_VERSION))

/**
 * DSPY_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of D-Spy is greater than the required one.
 */
#define DSPY_CHECK_VERSION(major,minor,micro)   \
        (DSPY_MAJOR_VERSION > (major) || \
         (DSPY_MAJOR_VERSION == (major) && DSPY_MINOR_VERSION > (minor)) || \
         (DSPY_MAJOR_VERSION == (major) && DSPY_MINOR_VERSION == (minor) && \
          DSPY_MICRO_VERSION >= (micro)))
