/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.model.EventPoster;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Int;
import bt747.sys.interfaces.BT747Time;
import gps.BT747Constants;
import gps.convert.Conv;
import gps.mvc.GpsLinkHandler;
import gps.mvc.GpsModel;
import gps.mvc.MTKLogDownloadHandler;
import gps.mvc.commands.CmdVisitor;
import gps.mvc.commands.GpsLinkExecCommand;
import gps.mvc.commands.GpsLinkNmeaCommand;
import net.sf.bt747.gps.mtk.MtkBinTransportMessageModel;
import net.sf.bt747.util.GpsConvert;

public class MtkModel
implements EventPoster {
    private final GpsLinkHandler handler;
    protected MTKLogDownloadHandler mtkLogHandler;
    private int logFormat = 0;
    protected int logTimeIntervalX100ms = 0;
    private int logSpeedInterval = 0;
    protected int logDistanceIntervalDm = 0;
    private int logStatus = 0;
    private int initialLogMode = 0;
    private int lastLogBlock = 0;
    public int logNbrLogPts = 0;
    private int logMemUsed = 0;
    public int logMemUsedPercent = 0;
    private int logFixPeriod = 0;
    private int datum = 0;
    private boolean loggingActive = false;
    private boolean loggerIsFull = false;
    private boolean loggerNeedsInit = false;
    private boolean loggerIsDisabled = false;
    protected boolean logFullOverwrite = false;
    private int dgpsMode = 0;
    private int dtUserOptionTimesLeft;
    private int dtUpdateRate;
    private int dtBaudRate;
    private int dtGLL_Period;
    private int dtRMC_Period;
    private int dtVTG_Period;
    private int dtGSA_Period;
    private int dtGSV_Period;
    private int dtGGA_Period;
    private int dtZDA_Period;
    private int dtMCHN_Period;
    private String mainVersion = "";
    private String model = "";
    protected String device = "";
    protected String firmwareVersion = "";
    private String MtkLogVersion = "";
    private int flashManuProdID = 0;
    private String sBtMacAddr = "";
    private int[] NMEA_periods = new int[19];
    protected boolean holux = false;
    protected String holuxName = "";
    private boolean SBASEnabled = false;
    private boolean SBASTestEnabled = false;
    private boolean powerSaveEnabled = false;
    private GpsModel context;
    private boolean hasAgps = false;
    private int agpsDataCount = 0;
    private BT747Time agpsStartTime;
    private BT747Time agpsEndTime;
    private BT747Time agpsStart2Time;
    private BT747Time agpsEnd2Time;
    protected int dataOK = 0;
    private final boolean[] dataAvailable = new boolean[27];
    private final boolean[] dataSupported = new boolean[27];
    private final int[] dataRequested = new int[27];
    private final boolean[] dataTimesOut = new boolean[]{false, true, true, false, false, false, false, true, false, true};
    public static final int DATA_FLASH_TYPE = 0;
    public static final int DATA_MEM_PTS_LOGGED = 1;
    public static final int DATA_MEM_USED = 2;
    public static final int DATA_LOG_FORMAT = 3;
    public static final int DATA_MTK_VERSION = 4;
    public static final int DATA_MTK_RELEASE = 5;
    public static final int DATA_INITIAL_LOG = 6;
    public static final int DATA_LOG_STATUS = 7;
    public static final int DATA_LOG_VERSION = 8;
    public static final int DATA_LAST_LOG_BLOCK = 9;
    public static final int DATA_DEVICE_NAME = 10;
    public static final int DATA_LOG_TIME_INTERVAL = 11;
    public static final int DATA_LOG_SPEED_INTERVAL = 12;
    public static final int DATA_LOG_DISTANCE_INTERVAL = 13;
    public static final int DATA_LOG_FLASH_STATUS = 14;
    public static final int DATA_LOG_FLASH_SECTOR_STATUS = 15;
    public static final int DATA_FIX_PERIOD = 16;
    public static final int DATA_AGPS_STORED_RANGE = 17;
    public static final int DATA_LOG_OVERWRITE_STATUS = 18;
    public static final int DATA_SBAS_TEST_STATUS = 19;
    public static final int DATA_SBAS_STATUS = 20;
    public static final int DATA_POWERSAVE_STATUS = 21;
    public static final int DATA_DATUM_MODE = 22;
    public static final int DATA_NMEA_OUTPUT_PERIODS = 23;
    public static final int DATA_DGPS_MODE = 24;
    public static final int DATA_BT_MAC_ADDR = 25;
    public static final int DATA_FLASH_USER_OPTION = 26;
    private boolean autofetch = true;
    private boolean eraseOngoing = false;
    private int logDownloadEndAddr;
    private int nextReadAddr;
    private boolean isLogDownloadOngoing = false;

    protected final void setLogHandler(MTKLogDownloadHandler mTKLogDownloadHandler) {
        this.mtkLogHandler = mTKLogDownloadHandler;
    }

    public MtkModel(GpsModel gpsModel, GpsLinkHandler gpsLinkHandler) {
        this.handler = gpsLinkHandler;
        this.context = gpsModel;
    }

    public final GpsModel getContext() {
        return this.context;
    }

    public final boolean isDataOK$134632() {
        return (this.dataOK & 0x3DF) == 991;
    }

    protected final void setAllUnavailable() {
        int n = Generic.getTimeStamp() - 300000;
        for (int i = 0; i < 27; ++i) {
            this.dataAvailable[i] = false;
            this.dataRequested[i] = n;
            this.dataSupported[i] = true;
        }
        this.hasAgps = false;
        this.agpsDataCount = 0;
        this.agpsStartTime = null;
        this.agpsEndTime = null;
        this.agpsStart2Time = null;
        this.agpsEnd2Time = null;
    }

    public final void setAutoFetch(boolean bl) {
        this.autofetch = bl;
    }

    protected final boolean isDataNeedsRequest(int n, int n2) {
        int n3;
        if (n2 > 9) {
            return true;
        }
        if (!this.autofetch) {
            return false;
        }
        if (!this.dataSupported[n2]) {
            return false;
        }
        if (Generic.getDebugLevel() > 3) {
            Generic.debug("ts:" + n + " type:" + n2 + " timesout:" + this.dataTimesOut[n2] + " available:" + this.dataAvailable[n2] + " requested:" + (n - this.dataRequested[n2]));
        }
        if ((this.autofetch && this.dataTimesOut[n2] || !this.dataAvailable[n3 = n2]) && n - this.dataRequested[n2] > 3500) {
            this.dataRequested[n2] = n;
            return true;
        }
        return false;
    }

    protected final void setAvailable(int n) {
        this.setAvailable(n, true);
    }

    protected final void setUnAvailable$13462e() {
        this.setAvailable(17, false);
    }

    private void setAvailable(int n, boolean bl) {
        this.dataAvailable[n] = bl;
        if (!bl) {
            return;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 3: {
                this.dataOK |= 0x200;
                break;
            }
            case 9: {
                this.dataRequested[9] = this.dataRequested[9] + 30000;
            }
        }
        BT747Int bT747Int = BT747Int.get(n);
        this.context.postGpsEvent(37, bT747Int);
    }

    public final boolean isDataAvailable(int n) {
        return this.dataAvailable[n];
    }

    protected final void setChanged$13462e() {
        this.dataAvailable[3] = false;
        this.dataRequested[3] = 0;
    }

    public GpsLinkHandler getHandler() {
        return this.handler;
    }

    protected boolean analyseResponse(Object object) {
        if (object instanceof MtkBinTransportMessageModel) {
            object = (MtkBinTransportMessageModel)object;
            if (Generic.isDebug()) {
                Generic.debug("<" + ((MtkBinTransportMessageModel)object).toString());
            }
            return true;
        }
        if (object instanceof String[]) {
            if (!this.context.analyseNMEA((String[])object)) {
                return this.analyseMtkNmea((String[])object);
            }
            return true;
        }
        return false;
    }

    private boolean analyseLogNmea(String[] stringArray) {
        this.handler.resetLogTimeOut();
        if (stringArray.length > 2) {
            block1 : switch (JavaLibBridge.toInt(stringArray[1])) {
                case 3: {
                    int n = JavaLibBridge.toInt(stringArray[2]);
                    if (stringArray.length != 4) break;
                    switch (n) {
                        case 1: {
                            this.mtkLogHandler.handleLogFlashStatReply(stringArray[3]);
                            break block1;
                        }
                        case 2: {
                            this.logFormat = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(3, true);
                            this.postEvent(2);
                            break block1;
                        }
                        case 3: {
                            this.logTimeIntervalX100ms = JavaLibBridge.toInt(stringArray[3]);
                            this.dataOK |= 0x40;
                            this.setAvailable(11, true);
                            this.postEvent(18);
                            break block1;
                        }
                        case 4: {
                            this.logDistanceIntervalDm = JavaLibBridge.toInt(stringArray[3]);
                            this.dataOK |= 0x100;
                            this.setAvailable(13, true);
                            this.postEvent(20);
                            break block1;
                        }
                        case 5: {
                            this.logSpeedInterval = JavaLibBridge.toInt(stringArray[3]) / 10;
                            this.dataOK |= 0x80;
                            this.setAvailable(12, true);
                            this.postEvent(19);
                            break block1;
                        }
                        case 6: {
                            this.logFullOverwrite = JavaLibBridge.toInt(stringArray[3]) == 1;
                            this.postEvent(27);
                            break block1;
                        }
                        case 7: {
                            this.logStatus = JavaLibBridge.toInt(stringArray[3]);
                            n = (this.logStatus & 2) != 0 ? 1 : 0;
                            this.loggingActive = n;
                            this.loggerIsFull = (this.logStatus & 0x800) != 0;
                            this.loggerNeedsInit = (this.logStatus & 0x400) != 0;
                            this.loggerIsDisabled = (this.logStatus & 0x200) != 0 || (this.logStatus & 0x100) == 0;
                            this.setAvailable(7, true);
                            this.postEvent(28);
                            break block1;
                        }
                        case 8: {
                            this.setLogMemUsed(Conv.hex2Int(stringArray[3]));
                            break block1;
                        }
                        case 9: {
                            this.flashManuProdID = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(0, true);
                            this.postEvent(23);
                            break block1;
                        }
                        case 10: {
                            this.logNbrLogPts = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(1, true);
                            this.postEvent(24);
                            break block1;
                        }
                        case 11: {
                            this.setAvailable(15, true);
                            this.postEvent(25);
                            break block1;
                        }
                        case 12: {
                            this.MtkLogVersion = "V" + JavaLibBridge.toString((float)JavaLibBridge.toInt(stringArray[3]) / 100.0f, 2);
                            this.setAvailable(8, true);
                            this.postEvent(26);
                            break block1;
                        }
                    }
                    break;
                }
                case 8: {
                    try {
                        if (Conv.hex2Int(stringArray[2]) == 6) {
                            this.initialLogMode = Conv.hex2Int(stringArray[3].substring(0, 4));
                            this.initialLogMode = this.initialLogMode & 0xFF00 | this.initialLogMode >> 8;
                            this.setAvailable(6, true);
                            break;
                        }
                        if (Conv.hex2Int(stringArray[2]) == (this.getLogMemSize() - 1 & 0xFFFF0000) + 6) {
                            this.lastLogBlock = Conv.hex2Int(stringArray[3].substring(0, 8));
                            this.setAvailable(9, true);
                            break;
                        }
                        this.mtkLogHandler.analyzeLogPart(Conv.hex2Int(stringArray[2]), stringArray[3]);
                        break;
                    }
                    catch (Exception exception) {
                        Generic.debug("analyzeLogNMEA", exception);
                    }
                }
            }
        }
        return true;
    }

    public boolean analyseMtkNmea(String[] stringArray) {
        int n;
        block42: {
            block41: {
                n = 0;
                if (stringArray == null || stringArray.length <= 0) {
                    return false;
                }
                if (!stringArray[0].startsWith("PMTK")) break block41;
                if (Generic.isDebug()) {
                    n = stringArray.length;
                    if (stringArray[1].length() > 0 && stringArray[1].charAt(0) == '8') {
                        n = 3;
                    }
                    StringBuffer stringBuffer = new StringBuffer(60);
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(',');
                    }
                    Generic.debug(stringBuffer.toString());
                }
                int n2 = JavaLibBridge.toInt(stringArray[0].substring(4));
                n = 0;
                switch (n2) {
                    case 182: {
                        n = this.analyseLogNmea(stringArray) ? 1 : 0;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        n = this.analyseMTK_Ack(stringArray) ? 1 : 0;
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 500: {
                        if (stringArray.length >= 2) {
                            this.logFixPeriod = JavaLibBridge.toInt(stringArray[1]);
                            this.setAvailable(16, true);
                            this.postEvent(13);
                        }
                        this.dataOK |= 1;
                        break;
                    }
                    case 501: {
                        if (stringArray.length == 2) {
                            this.dgpsMode = JavaLibBridge.toInt(stringArray[1]);
                        }
                        this.dataOK |= 2;
                        this.postEvent(29);
                        break;
                    }
                    case 513: {
                        if (stringArray.length == 2) {
                            this.SBASEnabled = stringArray[1].equals("1");
                        }
                        this.dataOK |= 4;
                        this.postEvent(30);
                        break;
                    }
                    case 514: {
                        if (stringArray.length - 1 == 19) {
                            for (n2 = 0; n2 < 19; ++n2) {
                                this.NMEA_periods[n2] = JavaLibBridge.toInt(stringArray[n2 + 1]);
                            }
                        }
                        this.dataOK |= 8;
                        this.postEvent(15);
                        break;
                    }
                    case 519: {
                        if (stringArray.length == 2) {
                            this.SBASTestEnabled = stringArray[1].equals("0");
                        }
                        this.dataOK |= 0x10;
                        this.postEvent(31);
                        break;
                    }
                    case 520: {
                        if (stringArray.length == 2) {
                            this.powerSaveEnabled = stringArray[1].equals("1");
                        }
                        this.postEvent(32);
                        break;
                    }
                    case 530: {
                        if (stringArray.length == 2) {
                            this.datum = JavaLibBridge.toInt(stringArray[1]);
                        }
                        this.dataOK |= 0x20;
                        this.postEvent(33);
                        break;
                    }
                    case 590: {
                        this.dtUserOptionTimesLeft = JavaLibBridge.toInt(stringArray[1]);
                        this.dtUpdateRate = JavaLibBridge.toInt(stringArray[2]);
                        this.dtBaudRate = JavaLibBridge.toInt(stringArray[3]);
                        this.dtGLL_Period = JavaLibBridge.toInt(stringArray[4]);
                        this.dtRMC_Period = JavaLibBridge.toInt(stringArray[5]);
                        this.dtVTG_Period = JavaLibBridge.toInt(stringArray[6]);
                        this.dtGSA_Period = JavaLibBridge.toInt(stringArray[7]);
                        this.dtGSV_Period = JavaLibBridge.toInt(stringArray[8]);
                        this.dtGGA_Period = JavaLibBridge.toInt(stringArray[9]);
                        this.dtZDA_Period = JavaLibBridge.toInt(stringArray[10]);
                        this.dtMCHN_Period = JavaLibBridge.toInt(stringArray[11]);
                        this.postEvent(16);
                        break;
                    }
                    case 592: {
                        if (stringArray[1].length() == 12) {
                            this.sBtMacAddr = stringArray[1].substring(10, 12) + ":" + stringArray[1].substring(8, 10) + ":" + stringArray[1].substring(6, 8) + ":" + stringArray[1].substring(4, 6) + ":" + stringArray[1].substring(2, 4) + ":" + stringArray[1].substring(0, 2);
                        }
                        this.postEvent(34);
                        break;
                    }
                    case 702: {
                        break;
                    }
                    case 704: {
                        this.mainVersion = stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                        this.setAvailable(4, true);
                        this.postEvent(35);
                        break;
                    }
                    case 705: {
                        this.firmwareVersion = stringArray[1];
                        this.model = stringArray[2];
                        if (stringArray.length >= 4) {
                            this.device = stringArray[3];
                            this.firmwareVersion = this.firmwareVersion + " (" + this.device + ")";
                        } else {
                            this.device = "";
                        }
                        this.setAvailable(5, true);
                        this.postEvent(36);
                        break;
                    }
                    case 707: {
                        if (stringArray.length >= 10) {
                            this.hasAgps = true;
                            this.agpsDataCount = JavaLibBridge.toInt(stringArray[1]);
                            this.agpsStartTime = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[2]), JavaLibBridge.toInt(stringArray[3]));
                            this.agpsEndTime = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[4]), JavaLibBridge.toInt(stringArray[5]));
                            this.agpsStart2Time = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[6]), JavaLibBridge.toInt(stringArray[7]));
                            this.agpsEnd2Time = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[8]), JavaLibBridge.toInt(stringArray[9]));
                            this.setAvailable(17, true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block42;
            }
            if (stringArray[0].equals("HOLUX001")) {
                this.holux = true;
                if (Generic.isDebug()) {
                    n = stringArray.length;
                    StringBuffer stringBuffer = new StringBuffer(60);
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(',');
                    }
                    Generic.debug(stringBuffer.toString());
                }
                int n3 = JavaLibBridge.toInt(stringArray[1]);
                n = 0;
                switch (n3) {
                    case 5: {
                        if (stringArray.length != 3) break;
                        this.holuxName = stringArray[2];
                        this.postEvent(17);
                    }
                }
            }
        }
        return n != 0;
    }

    private boolean analyseMTK_Ack(String[] stringArray) {
        int n = 0;
        if (stringArray.length >= 3) {
            n = JavaLibBridge.toInt(stringArray[stringArray.length - 1]);
            int n2 = JavaLibBridge.toInt(stringArray[1]);
            StringBuffer stringBuffer = new StringBuffer("PMTK");
            stringBuffer.append(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(stringArray[i]);
            }
            this.handler.removeFromSentCmds(new MtkVisitor(stringBuffer.toString()));
            switch (n) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 604: {
                            this.dataSupported[4] = false;
                        }
                    }
                    n = 1;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n != 0;
    }

    protected final void postEvent(int n) {
        this.context.postGpsEvent(n, null);
    }

    @Override
    public void postEvent(ModelEvent modelEvent) {
        this.context.postEvent(modelEvent);
    }

    public final int logMemUsefullSize() {
        return (this.getLogMemSize() >> 16) * 65024;
    }

    public final String getBtMacAddr() {
        return this.sBtMacAddr;
    }

    public final int getFlashManuProdID() {
        return this.flashManuProdID;
    }

    public final String getFlashDesc() {
        return BT747Constants.getFlashDesc(this.flashManuProdID);
    }

    public final String getMtkLogVersion() {
        return this.MtkLogVersion;
    }

    public final boolean isHolux() {
        return this.holux;
    }

    public final String getHoluxName() {
        return this.holuxName;
    }

    public final int getLogFormat() {
        return this.logFormat;
    }

    public final int getDtUpdateRate() {
        return this.dtUpdateRate;
    }

    public final int getDtGLL_Period() {
        return this.dtGLL_Period;
    }

    public final int getDtRMC_Period() {
        return this.dtRMC_Period;
    }

    public final int getDtVTG_Period() {
        return this.dtVTG_Period;
    }

    public final int getDtGSA_Period() {
        return this.dtGSA_Period;
    }

    public final int getDtGSV_Period() {
        return this.dtGSV_Period;
    }

    public final int getDtGGA_Period() {
        return this.dtGGA_Period;
    }

    public final int getDtZDA_Period() {
        return this.dtZDA_Period;
    }

    public final int getDtMCHN_Period() {
        return this.dtMCHN_Period;
    }

    public final int getDtBaudRate() {
        return this.dtBaudRate;
    }

    public final int getDtUserOptionTimesLeft() {
        return this.dtUserOptionTimesLeft;
    }

    public final int getLogTimeInterval() {
        return this.logTimeIntervalX100ms;
    }

    public final int getLogSpeedInterval() {
        return this.logSpeedInterval;
    }

    public final int getLogDistanceInterval() {
        return this.logDistanceIntervalDm;
    }

    public final int getLogFixPeriod() {
        return this.logFixPeriod;
    }

    public final boolean isSBASEnabled() {
        return this.SBASEnabled;
    }

    public final boolean isSBASTestEnabled() {
        return this.SBASTestEnabled;
    }

    public final boolean isPowerSaveEnabled() {
        return this.powerSaveEnabled;
    }

    public final boolean isInitialLogOverwrite() {
        return (this.initialLogMode & 4) == 0 && this.lastLogBlock != -1;
    }

    public final int getDgpsMode() {
        return this.dgpsMode;
    }

    protected final void setLoggingActive(boolean bl) {
        this.loggingActive = bl;
    }

    public final boolean isLogFullOverwrite() {
        return this.logFullOverwrite;
    }

    public final int getDatum() {
        return this.datum;
    }

    public final int getNMEAPeriod(int n) {
        return this.NMEA_periods[n];
    }

    protected final boolean isEraseOngoing() {
        return this.eraseOngoing;
    }

    protected final void setEraseOngoing(boolean bl) {
        if (this.eraseOngoing != bl) {
            this.eraseOngoing = bl;
            if (bl) {
                this.postEvent(9);
                return;
            }
            this.postEvent(10);
            this.handler.setEraseOngoing(false);
        }
    }

    public final boolean isLoggingActive() {
        return this.loggingActive;
    }

    public final boolean isLoggingDisabled() {
        return this.loggerIsDisabled;
    }

    public final boolean isLoggerNeedsFormat() {
        return this.loggerNeedsInit && !this.loggerIsFull;
    }

    public final String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public final String getMainVersion() {
        return this.mainVersion;
    }

    public final int getLogMemSize() {
        return BT747Constants.getFlashSize(this.flashManuProdID);
    }

    protected final void setLogMemUsed(int n) {
        this.logMemUsed = n;
        this.logMemUsedPercent = 100 * (this.getLogMemUsed() - 512 * ((this.getLogMemUsed() + 65535) / 65536)) / this.logMemUsefullSize();
        this.setAvailable(2, true);
        this.postEvent(22);
    }

    public final int getLogMemUsed() {
        return this.logMemUsed;
    }

    public final String getModel() {
        if (this.model.length() != 0) {
            MtkModel mtkModel = this;
            return this.model + " (" + BT747Constants.modelName(Conv.hex2Int(mtkModel.model), mtkModel.device) + ')';
        }
        return "";
    }

    public final int getStartAddr() {
        return this.mtkLogHandler.getStartAddr();
    }

    public final int getEndAddr() {
        return this.logDownloadEndAddr;
    }

    protected final void setEndAddr(int n) {
        this.logDownloadEndAddr = n;
    }

    protected final void setNextReadAddr(int n) {
        this.nextReadAddr = n;
    }

    public final int getNextReadAddr() {
        return this.nextReadAddr;
    }

    public final boolean isLogDownloadOngoing() {
        return this.isLogDownloadOngoing;
    }

    protected final void setLogDownloadOngoing(boolean bl) {
        this.isLogDownloadOngoing = bl;
    }

    public final int getAgpsDataCount() {
        return this.agpsDataCount;
    }

    public final BT747Time getAgpsStartTime() {
        return this.agpsStartTime;
    }

    public final BT747Time getAgpsEndTime() {
        return this.agpsEndTime;
    }

    public final BT747Time getAgpsStart2Time() {
        return this.agpsStart2Time;
    }

    public final BT747Time getAgpsEnd2Time() {
        return this.agpsEnd2Time;
    }

    public final boolean hasAgps() {
        return this.hasAgps;
    }

    public boolean isTimeDistanceLogConditionExclusive() {
        return false;
    }

    static final class MtkVisitor
    implements CmdVisitor {
        private final String cmd;

        public MtkVisitor(String string) {
            this.cmd = string;
        }

        @Override
        public final boolean isAcknowledgeOf(GpsLinkExecCommand gpsLinkExecCommand) {
            if (gpsLinkExecCommand instanceof GpsLinkNmeaCommand) {
                return ((GpsLinkNmeaCommand)gpsLinkExecCommand).getNmeaValue().startsWith(this.cmd);
            }
            return false;
        }
    }
}

