
#ifndef WRAPLANDSERVER_EXPORT_H
#define WRAPLANDSERVER_EXPORT_H

#ifdef WRAPLANDSERVER_STATIC_DEFINE
#  define WRAPLANDSERVER_EXPORT
#  define WRAPLANDSERVER_NO_EXPORT
#else
#  ifndef WRAPLANDSERVER_EXPORT
#    ifdef WraplandServer_EXPORTS
        /* We are building this library */
#      define WRAPLANDSERVER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define WRAPLANDSERVER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef WRAPLANDSERVER_NO_EXPORT
#    define WRAPLANDSERVER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef WRAPLANDSERVER_DECL_DEPRECATED
#  define WRAPLANDSERVER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef WRAPLANDSERVER_DECL_DEPRECATED_EXPORT
#  define WRAPLANDSERVER_DECL_DEPRECATED_EXPORT WRAPLANDSERVER_EXPORT WRAPLANDSERVER_DECL_DEPRECATED
#endif

#ifndef WRAPLANDSERVER_DECL_DEPRECATED_NO_EXPORT
#  define WRAPLANDSERVER_DECL_DEPRECATED_NO_EXPORT WRAPLANDSERVER_NO_EXPORT WRAPLANDSERVER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef WRAPLANDSERVER_NO_DEPRECATED
#    define WRAPLANDSERVER_NO_DEPRECATED
#  endif
#endif

#define WRAPLANDSERVER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(WRAPLANDSERVER_NO_DEPRECATED)
#  undef WRAPLANDSERVER_DEPRECATED
#  define WRAPLANDSERVER_DEPRECATED_EXPORT WRAPLANDSERVER_EXPORT
#  define WRAPLANDSERVER_DEPRECATED_NO_EXPORT WRAPLANDSERVER_NO_EXPORT
#elif defined(WRAPLANDSERVER_NO_DEPRECATED_WARNINGS)
#  define WRAPLANDSERVER_DEPRECATED
#  define WRAPLANDSERVER_DEPRECATED_EXPORT WRAPLANDSERVER_EXPORT
#  define WRAPLANDSERVER_DEPRECATED_NO_EXPORT WRAPLANDSERVER_NO_EXPORT
#else
#  define WRAPLANDSERVER_DEPRECATED WRAPLANDSERVER_DECL_DEPRECATED
#  define WRAPLANDSERVER_DEPRECATED_EXPORT WRAPLANDSERVER_DECL_DEPRECATED_EXPORT
#  define WRAPLANDSERVER_DEPRECATED_NO_EXPORT WRAPLANDSERVER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define WRAPLANDSERVER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define WRAPLANDSERVER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef WRAPLANDSERVER_NO_DEPRECATED
#  define WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x20f00
#endif
#ifdef WRAPLANDSERVER_NO_DEPRECATED_WARNINGS
#  define WRAPLANDSERVER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef WRAPLANDSERVER_DEPRECATED_WARNINGS_SINCE
#  ifdef WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define WRAPLANDSERVER_DEPRECATED_WARNINGS_SINCE WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define WRAPLANDSERVER_DEPRECATED_WARNINGS_SINCE 0x20f00
#  endif
#endif

#ifndef WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x0
#endif

#ifdef WRAPLANDSERVER_DEPRECATED
#  define WRAPLANDSERVER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > WRAPLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define WRAPLANDSERVER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* WRAPLANDSERVER_EXPORT_H */
