"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const url_1 = require("url");
const URL_REGEX = /^https?:\/\/.*$/;
var Protocol;
(function (Protocol) {
    Protocol["Http"] = "http";
    Protocol["Https"] = "https";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
class ProxySetting {
    constructor(params) {
        this.protocol = Protocol.Http;
        if (typeof params === "string") {
            this._parseUrl(params);
        }
        else {
            this.host = params.host;
            this.port = params.port;
            this.protocol = params.protocol || Protocol.Http;
            this.credentials = params.credentials;
        }
    }
    toString() {
        let cred = "";
        if (this.credentials) {
            cred = `${this.credentials.username}`;
            if (this.credentials.password) {
                cred += `:${this.credentials.password}`;
            }
            cred += "@";
        }
        return `${this.protocol}://${cred}${this.host}:${this.port}`;
    }
    getAuthorizationHeader() {
        if (!this.credentials) {
            return null;
        }
        const cred = `${this.credentials.username}:${this.credentials.password}`;
        return `Basic ${Buffer.from(cred).toString("base64")}`;
    }
    _parseUrl(value) {
        value = ensureProtocol(value);
        const url = new url_1.URL(value);
        this.host = url.hostname;
        this.port = url.port;
        if (url.protocol === "https:") {
            this.protocol = Protocol.Https;
        }
        else {
            this.protocol = Protocol.Http;
        }
        if (!this.port) {
            this.port = this.protocol === Protocol.Https ? "443" : "80";
        }
        if (url.username) {
            this.credentials = {
                username: url.username,
                password: url.password,
            };
        }
    }
}
exports.ProxySetting = ProxySetting;
function ensureProtocol(value) {
    if (URL_REGEX.test(value)) {
        return value;
    }
    else {
        return `http://${value}`;
    }
}
//# sourceMappingURL=proxy-settings.js.map