"use strict";
/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.manySelectors = exports.filterProps = exports.inlineSVG = exports.noop = void 0;
const noop = () => { };
exports.noop = noop;
const inlineSVG = (svg) => `data:image/svg+xml;utf8,${encodeURIComponent(svg)}`;
exports.inlineSVG = inlineSVG;
const filterProps = (props, propsToFilter) => {
    return Object.entries(props).reduce((accumulator, [key, value]) => (!propsToFilter.includes(key) ? Object.assign(Object.assign({}, accumulator), { [key]: value }) : accumulator), {});
};
exports.filterProps = filterProps;
const manySelectors = (selectors, css) => selectors.reduce((acc, selector) => {
    acc[selector] = css;
    return acc;
}, {});
exports.manySelectors = manySelectors;
