"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ButtonLink = exports.buttonLinkStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Button_1 = require("./Button");
const Identity_1 = require("../Identity");
const Misc_1 = require("../Misc");
const Text_1 = require("../Text");
const util_1 = require("../util");
const buttonLinkStyle = (theme, props) => (Object.assign(Object.assign({}, (0, Button_1.buttonStyle)(theme, props)), { display: 'inline-flex !important' }));
exports.buttonLinkStyle = buttonLinkStyle;
const filterButtonLinkProps = (props) => {
    return (0, util_1.filterProps)((0, Text_1.filterTextProps)(props), [
        'backgroundColor',
        'disabled',
        'noCapital',
    ]);
};
const ButtonLink = (_a) => {
    var { children, showLoading, loadingColor = Identity_1.COLOR.WHITE } = _a, props = __rest(_a, ["children", "showLoading", "loadingColor"]);
    return ((0, jsx_runtime_1.jsx)("a", Object.assign({ css: (theme) => (0, exports.buttonLinkStyle)(theme, props) }, filterButtonLinkProps(props), { children: showLoading ? (0, jsx_runtime_1.jsx)(Misc_1.Loading, { size: 30, color: loadingColor, style: { display: 'flex', margin: 'auto' } }) : children })));
};
exports.ButtonLink = ButtonLink;
