"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const eventType_1 = require("../../lib/eventType");
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_RENDER, (event, labels) => {
    for (const label in labels) {
        const labelElement = document.querySelector(`[data-string="${label}"]`);
        if (labelElement) {
            labelElement.textContent = labels[label];
        }
    }
});
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOADED, () => {
    const labels = [];
    const dataStrings = document.querySelectorAll('[data-string]');
    for (const index in dataStrings) {
        const label = dataStrings[index];
        if (label.dataset) {
            labels.push(label.dataset.string);
        }
    }
    electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_VALUES, labels);
    const okButton = document.querySelector('#okButton');
    const cancelButton = document.querySelector('#cancelButton');
    const usernameInput = document.querySelector('#usernameInput');
    const passwordInput = document.querySelector('#passwordInput');
    const form = document.querySelector('#form');
    if (cancelButton && okButton && usernameInput && passwordInput && form) {
        usernameInput.focus();
        const sendData = () => {
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.SUBMITTED, {
                password: passwordInput.value,
                username: usernameInput.value,
            });
            window.close();
        };
        cancelButton.addEventListener('click', () => {
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.CANCELED);
            window.close();
        });
        form.addEventListener('submit', () => sendData());
        window.addEventListener('keydown', event => {
            if (event.key === 'Escape') {
                electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.CANCELED);
                window.close();
            }
        });
    }
});
//# sourceMappingURL=preload-proxy-prompt.js.map