/*
 *  oFono - Open Source Telephony
 *
 *  Copyright (C) 2018 Jolla Ltd.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 */

#ifndef __OFONO_RIL_CONSTANTS_H
#define __OFONO_RIL_CONSTANTS_H

#ifdef __cplusplus
extern "C" {
#endif

/* Error Codes */
enum ril_status {
	RIL_E_SUCCESS = 0,
	RIL_E_RADIO_NOT_AVAILABLE = 1,
	RIL_E_GENERIC_FAILURE = 2,
	RIL_E_PASSWORD_INCORRECT = 3,
	RIL_E_SIM_PIN2 = 4,
	RIL_E_SIM_PUK2 = 5,
	RIL_E_REQUEST_NOT_SUPPORTED = 6,
	RIL_E_CANCELLED = 7,
	RIL_E_OP_NOT_ALLOWED_DURING_VOICE_CALL = 8,
	RIL_E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW = 9,
	RIL_E_SMS_SEND_FAIL_RETRY = 10,
	RIL_E_SIM_ABSENT = 11,
	RIL_E_SUBSCRIPTION_NOT_AVAILABLE = 12,
	RIL_E_MODE_NOT_SUPPORTED = 13,
	RIL_E_FDN_CHECK_FAILURE = 14,
	RIL_E_ILLEGAL_SIM_OR_ME = 15,
	RIL_E_MISSING_RESOURCE = 16,
	RIL_E_NO_SUCH_ELEMENT = 17,
	RIL_E_DIAL_MODIFIED_TO_USSD = 18,
	RIL_E_DIAL_MODIFIED_TO_SS = 19,
	RIL_E_DIAL_MODIFIED_TO_DIAL = 20,
	RIL_E_USSD_MODIFIED_TO_DIAL = 21,
	RIL_E_USSD_MODIFIED_TO_SS = 22,
	RIL_E_USSD_MODIFIED_TO_USSD = 23,
	RIL_E_SS_MODIFIED_TO_DIAL = 24,
	RIL_E_SS_MODIFIED_TO_USSD = 25,
	RIL_E_SUBSCRIPTION_NOT_SUPPORTED = 26,
	RIL_E_SS_MODIFIED_TO_SS = 27,
	RIL_E_LCE_NOT_SUPPORTED = 36,
	RIL_E_NO_MEMORY = 37,
	RIL_E_INTERNAL_ERR = 38,
	RIL_E_SYSTEM_ERR = 39,
	RIL_E_MODEM_ERR = 40,
	RIL_E_INVALID_STATE = 41,
	RIL_E_NO_RESOURCES = 42,
	RIL_E_SIM_ERR = 43,
	RIL_E_INVALID_ARGUMENTS = 44,
	RIL_E_INVALID_SIM_STATE = 45,
	RIL_E_INVALID_MODEM_STATE = 46,
	RIL_E_INVALID_CALL_ID = 47,
	RIL_E_NO_SMS_TO_ACK = 48,
	RIL_E_NETWORK_ERR = 49,
	RIL_E_REQUEST_RATE_LIMITED = 50,
	RIL_E_SIM_BUSY = 51,
	RIL_E_SIM_FULL = 52,
	RIL_E_NETWORK_REJECT = 53,
	RIL_E_OPERATION_NOT_ALLOWED = 54,
	RIL_E_EMPTY_RECORD = 55,
	RIL_E_INVALID_SMS_FORMAT = 56,
	RIL_E_ENCODING_ERR = 57,
	RIL_E_INVALID_SMSC_ADDRESS = 58,
	RIL_E_NO_SUCH_ENTRY = 59,
	RIL_E_NETWORK_NOT_READY = 60,
	RIL_E_NOT_PROVISIONED = 61,
	RIL_E_NO_SUBSCRIPTION = 62,
	RIL_E_NO_NETWORK_FOUND = 63,
	RIL_E_DEVICE_IN_USE = 64,
	RIL_E_ABORTED = 65,
	RIL_E_INVALID_RESPONSE = 66
};

/* RIL Request Messages, ofono -> rild */
enum ril_request {
	RIL_REQUEST_GET_SIM_STATUS = 1,
	RIL_REQUEST_ENTER_SIM_PIN = 2,
	RIL_REQUEST_ENTER_SIM_PUK = 3,
	RIL_REQUEST_ENTER_SIM_PIN2 = 4,
	RIL_REQUEST_ENTER_SIM_PUK2 = 5,
	RIL_REQUEST_CHANGE_SIM_PIN = 6,
	RIL_REQUEST_CHANGE_SIM_PIN2 = 7,
	RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION = 8,
	RIL_REQUEST_GET_CURRENT_CALLS = 9,
	RIL_REQUEST_DIAL = 10,
	RIL_REQUEST_GET_IMSI = 11,
	RIL_REQUEST_HANGUP = 12,
	RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND = 13,
	RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND = 14,
	RIL_REQUEST_SWITCH_HOLDING_AND_ACTIVE = 15,
	RIL_REQUEST_CONFERENCE = 16,
	RIL_REQUEST_UDUB = 17,
	RIL_REQUEST_LAST_CALL_FAIL_CAUSE = 18,
	RIL_REQUEST_SIGNAL_STRENGTH = 19,
	RIL_REQUEST_VOICE_REGISTRATION_STATE = 20,
	RIL_REQUEST_DATA_REGISTRATION_STATE = 21,
	RIL_REQUEST_OPERATOR = 22,
	RIL_REQUEST_RADIO_POWER = 23,
	RIL_REQUEST_DTMF = 24,
	RIL_REQUEST_SEND_SMS = 25,
	RIL_REQUEST_SEND_SMS_EXPECT_MORE = 26,
	RIL_REQUEST_SETUP_DATA_CALL = 27,
	RIL_REQUEST_SIM_IO = 28,
	RIL_REQUEST_SEND_USSD = 29,
	RIL_REQUEST_CANCEL_USSD = 30,
	RIL_REQUEST_GET_CLIR = 31,
	RIL_REQUEST_SET_CLIR = 32,
	RIL_REQUEST_QUERY_CALL_FORWARD_STATUS = 33,
	RIL_REQUEST_SET_CALL_FORWARD = 34,
	RIL_REQUEST_QUERY_CALL_WAITING = 35,
	RIL_REQUEST_SET_CALL_WAITING = 36,
	RIL_REQUEST_SMS_ACKNOWLEDGE = 37,
	RIL_REQUEST_GET_IMEI = 38,
	RIL_REQUEST_GET_IMEISV = 39,
	RIL_REQUEST_ANSWER = 40,
	RIL_REQUEST_DEACTIVATE_DATA_CALL = 41,
	RIL_REQUEST_QUERY_FACILITY_LOCK = 42,
	RIL_REQUEST_SET_FACILITY_LOCK = 43,
	RIL_REQUEST_CHANGE_BARRING_PASSWORD = 44,
	RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE = 45,
	RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC = 46,
	RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL = 47,
	RIL_REQUEST_QUERY_AVAILABLE_NETWORKS = 48,
	RIL_REQUEST_DTMF_START = 49,
	RIL_REQUEST_DTMF_STOP = 50,
	RIL_REQUEST_BASEBAND_VERSION = 51,
	RIL_REQUEST_SEPARATE_CONNECTION = 52,
	RIL_REQUEST_SET_MUTE = 53,
	RIL_REQUEST_GET_MUTE = 54,
	RIL_REQUEST_QUERY_CLIP = 55,
	RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE = 56,
	RIL_REQUEST_DATA_CALL_LIST = 57,
	RIL_REQUEST_RESET_RADIO = 58,
	RIL_REQUEST_OEM_HOOK_RAW = 59,
	RIL_REQUEST_OEM_HOOK_STRINGS = 60,
	RIL_REQUEST_SCREEN_STATE = 61,
	RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION = 62,
	RIL_REQUEST_WRITE_SMS_TO_SIM = 63,
	RIL_REQUEST_DELETE_SMS_ON_SIM = 64,
	RIL_REQUEST_SET_BAND_MODE = 65,
	RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE = 66,
	RIL_REQUEST_STK_GET_PROFILE = 67,
	RIL_REQUEST_STK_SET_PROFILE = 68,
	RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND = 69,
	RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE = 70,
	RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM = 71,
	RIL_REQUEST_EXPLICIT_CALL_TRANSFER = 72,
	RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE = 73,
	RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE = 74,
	RIL_REQUEST_GET_NEIGHBORING_CELL_IDS = 75,
	RIL_REQUEST_SET_LOCATION_UPDATES = 76,
	RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE = 77,
	RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE = 78,
	RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE = 79,
	RIL_REQUEST_SET_TTY_MODE = 80,
	RIL_REQUEST_QUERY_TTY_MODE = 81,
	RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE = 82,
	RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE = 83,
	RIL_REQUEST_CDMA_FLASH = 84,
	RIL_REQUEST_CDMA_BURST_DTMF = 85,
	RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY = 86,
	RIL_REQUEST_CDMA_SEND_SMS = 87,
	RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE = 88,
	RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG = 89,
	RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG = 90,
	RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION = 91,
	RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG = 92,
	RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG = 93,
	RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION = 94,
	RIL_REQUEST_CDMA_SUBSCRIPTION = 95,
	RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM = 96,
	RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM = 97,
	RIL_REQUEST_DEVICE_IDENTITY = 98,
	RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE = 99,
	RIL_REQUEST_GET_SMSC_ADDRESS = 100,
	RIL_REQUEST_SET_SMSC_ADDRESS = 101,
	RIL_REQUEST_REPORT_SMS_MEMORY_STATUS = 102,
	RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING = 103,
	RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE = 104,
	RIL_REQUEST_ISIM_AUTHENTICATION = 105,
	RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU = 106,
	RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS = 107,
	RIL_REQUEST_VOICE_RADIO_TECH = 108,
	RIL_REQUEST_GET_CELL_INFO_LIST = 109,
	RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE = 110,
	RIL_REQUEST_SET_INITIAL_ATTACH_APN = 111,
	RIL_REQUEST_IMS_REGISTRATION_STATE = 112,
	RIL_REQUEST_IMS_SEND_SMS = 113,
	RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC = 114,
	RIL_REQUEST_SIM_OPEN_CHANNEL = 115,
	RIL_REQUEST_SIM_CLOSE_CHANNEL = 116,
	RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL = 117,
	RIL_REQUEST_NV_READ_ITEM = 118,
	RIL_REQUEST_NV_WRITE_ITEM = 119,
	RIL_REQUEST_NV_WRITE_CDMA_PRL = 120,
	RIL_REQUEST_NV_RESET_CONFIG = 121,
	/* SET_UICC_SUBSCRIPTION was 115 in v9 and 122 in v10 and later */
	RIL_REQUEST_V9_SET_UICC_SUBSCRIPTION = 115,
	RIL_REQUEST_SET_UICC_SUBSCRIPTION = 122,
	RIL_REQUEST_ALLOW_DATA = 123,
	RIL_REQUEST_GET_HARDWARE_CONFIG = 124,
	RIL_REQUEST_SIM_AUTHENTICATION = 125,
	RIL_REQUEST_GET_DC_RT_INFO = 126,
	RIL_REQUEST_SET_DC_RT_INFO_RATE = 127,
	RIL_REQUEST_SET_DATA_PROFILE = 128,
	RIL_REQUEST_SHUTDOWN = 129,
	RIL_REQUEST_GET_RADIO_CAPABILITY = 130,
	RIL_REQUEST_SET_RADIO_CAPABILITY = 131,
	RIL_REQUEST_START_LCE = 132,
	RIL_REQUEST_STOP_LCE = 133,
	RIL_REQUEST_GET_ACTIVITY_INFO = 135,
	RIL_REQUEST_GET_CARRIER_RESTRICTIONS = 137,
	RIL_REQUEST_SEND_DEVICE_STATE = 138,
	RIL_REQUEST_SET_UNSOLICITED_RESPONSE_FILTER = 139,
	RIL_REQUEST_SET_SIM_CARD_POWER = 140,
	RIL_REQUEST_SET_CARRIER_INFO_IMSI_ENCRYPTION = 141,
	RIL_REQUEST_START_NETWORK_SCAN = 142,
	RIL_REQUEST_STOP_NETWORK_SCAN = 143,
	RIL_REQUEST_START_KEEPALIVE = 144,
	RIL_REQUEST_STOP_KEEPALIVE = 145,
	/* A special message, not really a request */
	RIL_RESPONSE_ACKNOWLEDGEMENT = 800
};

/* RIL Unsolicited Messages, rild -> ofono */
enum ril_unsol {
	RIL_UNSOL_RESPONSE_BASE = 1000,
	RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED = 1000,
	RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED = 1001,
	RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED = 1002,
	RIL_UNSOL_RESPONSE_NEW_SMS = 1003,
	RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT = 1004,
	RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM = 1005,
	RIL_UNSOL_ON_USSD = 1006,
	RIL_UNSOL_ON_USSD_REQUEST = 1007,
	RIL_UNSOL_NITZ_TIME_RECEIVED = 1008,
	RIL_UNSOL_SIGNAL_STRENGTH = 1009,
	RIL_UNSOL_DATA_CALL_LIST_CHANGED = 1010,
	RIL_UNSOL_SUPP_SVC_NOTIFICATION = 1011,
	RIL_UNSOL_STK_SESSION_END = 1012,
	RIL_UNSOL_STK_PROACTIVE_COMMAND = 1013,
	RIL_UNSOL_STK_EVENT_NOTIFY = 1014,
	RIL_UNSOL_STK_CALL_SETUP = 1015,
	RIL_UNSOL_SIM_SMS_STORAGE_FULL = 1016,
	RIL_UNSOL_SIM_REFRESH = 1017,
	RIL_UNSOL_CALL_RING = 1018,
	RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED = 1019,
	RIL_UNSOL_RESPONSE_CDMA_NEW_SMS = 1020,
	RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS = 1021,
	RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL = 1022,
	RIL_UNSOL_RESTRICTED_STATE_CHANGED = 1023,
	RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE = 1024,
	RIL_UNSOL_CDMA_CALL_WAITING = 1025,
	RIL_UNSOL_CDMA_OTA_PROVISION_STATUS = 1026,
	RIL_UNSOL_CDMA_INFO_REC = 1027,
	RIL_UNSOL_OEM_HOOK_RAW = 1028,
	RIL_UNSOL_RINGBACK_TONE = 1029,
	RIL_UNSOL_RESEND_INCALL_MUTE = 1030,
	RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 1031,
	RIL_UNSOL_CDMA_PRL_CHANGED = 1032,
	RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE = 1033,
	RIL_UNSOL_RIL_CONNECTED = 1034,
	RIL_UNSOL_VOICE_RADIO_TECH_CHANGED = 1035,
	RIL_UNSOL_CELL_INFO_LIST = 1036,
	RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED = 1037,
	RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED = 1038,
	RIL_UNSOL_SRVCC_STATE_NOTIFY = 1039,
	RIL_UNSOL_HARDWARE_CONFIG_CHANGED = 1040,
	RIL_UNSOL_DC_RT_INFO_CHANGED = 1041,
	RIL_UNSOL_RADIO_CAPABILITY = 1042,
	RIL_UNSOL_ON_SS = 1043,
	RIL_UNSOL_STK_CC_ALPHA_NOTIFY = 1044
};

#ifdef __cplusplus
}
#endif

#endif /* __OFONO_RIL_CONSTANTS_H */

/*
 * Local Variables:
 * mode: C
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
