/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class SpChar
extends Macro
implements SingleToken {
    protected int charCode;

    public SpChar(int n) {
        this.charCode = n;
    }

    public SpChar() {
        this(94);
    }

    public SpChar(TeXParser teXParser) {
        this(teXParser.getSpChar());
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return 7;
    }

    @Override
    public Object clone() {
        return new SpChar(this.charCode);
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXObject teXObject2 = teXObjectList.peekStack();
        if (teXObject2 instanceof SpChar) {
            teXObjectList.push(teXParser.getListener().createGroup());
            teXParser.error(new TeXSyntaxException(teXParser, "tex.error.double_superscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().superscript(teXObject);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXObject teXObject2 = teXParser.peekStack();
        if (teXObject2 instanceof SpChar) {
            teXParser.push(teXParser.getListener().createGroup());
            teXParser.error(new TeXSyntaxException(teXParser, "tex.error.double_superscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().superscript(teXObject);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("superscript character %s", this.format());
    }
}

