/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers;

import ai.djl.huggingface.tokenizers.jni.CharSpan;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import java.util.Arrays;

public class Encoding {
    private long[] ids;
    private long[] typeIds;
    private String[] tokens;
    private long[] wordIds;
    private long[] attentionMask;
    private long[] specialTokenMask;
    private CharSpan[] charTokenSpans;
    private Encoding[] overflowing;
    private boolean exceedMaxLength;

    protected Encoding(long[] ids, long[] typeIds, String[] tokens, long[] wordIds, long[] attentionMask, long[] specialTokenMask, CharSpan[] charTokenSpans, boolean exceedMaxLength, Encoding[] overflowing) {
        this.ids = ids;
        this.typeIds = typeIds;
        this.tokens = tokens;
        this.wordIds = wordIds;
        this.attentionMask = attentionMask;
        this.specialTokenMask = specialTokenMask;
        this.charTokenSpans = charTokenSpans;
        this.exceedMaxLength = exceedMaxLength;
        this.overflowing = overflowing;
    }

    public NDList toNDList(NDManager manager, boolean withTokenType) {
        NDList list = new NDList(withTokenType ? 3 : 2);
        int[] intIds = Arrays.stream(this.ids).mapToInt(i -> (int)i).toArray();
        int[] intAttentionMask = Arrays.stream(this.attentionMask).mapToInt(i -> (int)i).toArray();
        list.add((Object)manager.create(intIds));
        list.add((Object)manager.create(intAttentionMask));
        if (withTokenType) {
            int[] intTypeIds = Arrays.stream(this.typeIds).mapToInt(i -> (int)i).toArray();
            list.add((Object)manager.create(intTypeIds));
        }
        return list;
    }

    public long[] getIds() {
        return this.ids;
    }

    public long[] getTypeIds() {
        return this.typeIds;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public long[] getWordIds() {
        return this.wordIds;
    }

    public long[] getAttentionMask() {
        return this.attentionMask;
    }

    public long[] getSpecialTokenMask() {
        return this.specialTokenMask;
    }

    public CharSpan[] getCharTokenSpans() {
        return this.charTokenSpans;
    }

    public boolean exceedMaxLength() {
        return this.exceedMaxLength;
    }

    public Encoding[] getOverflowing() {
        return this.overflowing;
    }
}

